/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.3.0 (build: 2013-04-09 19:13:20 UTC)
 *  on 2013-04-10 at 01:59:00 UTC 
 */

package com.google.api.services.analytics;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

/**
 * Service definition for Analytics (v2.4).
 *
 * <p>
 * View and manage your Google Analytics data
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/analytics/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AnalyticsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * <p>
 * Upgrade warning: this class now extends {@link AbstractGoogleJsonClient}, whereas in prior
 * version 1.8 it extended {@link com.google.api.client.googleapis.services.GoogleClient}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Analytics extends AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    Preconditions.checkState(GoogleUtils.VERSION.equals("1.13.2-beta"),
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.13.2-beta of google-api-client to run version " +
        "1.13.2-beta of the Google Analytics API library.", GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "analytics/v2.4/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.13)
   */
  @Deprecated
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport
   * @param jsonFactory JSON factory
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Analytics(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport,
        jsonFactory,
        DEFAULT_ROOT_URL,
        DEFAULT_SERVICE_PATH,
        httpRequestInitializer,
        false);
  }

  /**
   * @param transport HTTP transport
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @param rootUrl root URL of the service
   * @param servicePath service path
   * @param jsonObjectParser JSON object parser
   * @param googleClientRequestInitializer Google request initializer or {@code null} for none
   * @param applicationName application name to be sent in the User-Agent header of requests or
   *        {@code null} for none
   * @param suppressPatternChecks whether discovery pattern checks should be suppressed on required
   *        parameters
   */
  Analytics(HttpTransport transport,
      HttpRequestInitializer httpRequestInitializer,
      String rootUrl,
      String servicePath,
      JsonObjectParser jsonObjectParser,
      GoogleClientRequestInitializer googleClientRequestInitializer,
      String applicationName,
      boolean suppressPatternChecks) {
    super(transport,
        httpRequestInitializer,
        rootUrl,
        servicePath,
        jsonObjectParser,
        googleClientRequestInitializer,
        applicationName,
        suppressPatternChecks);
  }

  @Override
  protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Data collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Data.List request = analytics.data().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Data data() {
    return new Data();
  }

  /**
   * The "data" collection of methods.
   */
  public class Data {

    /**
     * Returns Analytics report data for a profile.
     *
     * Create a request for the method "data.get".
     *
     * This request holds the parameters needed by the the analytics server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param ids Unique table ID for retrieving report data. Table ID is of the form ga:XXXX, where XXXX is the
     *        Analytics profile ID.
     * @param startDate Start date for fetching report data. All requests should specify a start date formatted as YYYY-MM-
     *        DD.
     * @param endDate End date for fetching report data. All requests should specify an end date formatted as YYYY-MM-DD.
     * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
     *        must be specified to retrieve a valid Analytics report.
     * @return the request
     */
    public Get get(String ids, String startDate, String endDate, String metrics) throws java.io.IOException {
      Get result = new Get(ids, startDate, endDate, metrics);
      initialize(result);
      return result;
    }

    public class Get extends AnalyticsRequest<Void> {

      private static final String REST_PATH = "data";

      private final java.util.regex.Pattern IDS_PATTERN =
          java.util.regex.Pattern.compile("ga:[0-9]+");

      private final java.util.regex.Pattern STARTDATE_PATTERN =
          java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

      private final java.util.regex.Pattern ENDDATE_PATTERN =
          java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

      private final java.util.regex.Pattern METRICS_PATTERN =
          java.util.regex.Pattern.compile("ga:.+");

      private final java.util.regex.Pattern SORT_PATTERN =
          java.util.regex.Pattern.compile("(-)?ga:.+");

      private final java.util.regex.Pattern DIMENSIONS_PATTERN =
          java.util.regex.Pattern.compile("(ga:.+)?");

      private final java.util.regex.Pattern FILTERS_PATTERN =
          java.util.regex.Pattern.compile("ga:.+");

      /**
       * Returns Analytics report data for a profile.
       *
       * Create a request for the method "data.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param ids Unique table ID for retrieving report data. Table ID is of the form ga:XXXX, where XXXX is the
     *        Analytics profile ID.
       * @param startDate Start date for fetching report data. All requests should specify a start date formatted as YYYY-MM-
     *        DD.
       * @param endDate End date for fetching report data. All requests should specify an end date formatted as YYYY-MM-DD.
       * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
     *        must be specified to retrieve a valid Analytics report.
       * @since 1.13
       */
      protected Get(String ids, String startDate, String endDate, String metrics) {
        super(Analytics.this, "GET", REST_PATH, null, Void.class);
        this.ids = Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
              "Parameter ids must conform to the pattern " +
              "ga:[0-9]+");
        }
        this.startDate = Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
              "Parameter startDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.endDate = Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
              "Parameter endDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.metrics = Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
              "Parameter metrics must conform to the pattern " +
              "ga:.+");
        }
        set("alt", "json");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
     * Unique table ID for retrieving report data. Table ID is of the form ga:XXXX, where XXXX is
     * the Analytics profile ID.
     */
      @com.google.api.client.util.Key
      private String ids;

      /** Unique table ID for retrieving report data. Table ID is of the form ga:XXXX, where XXXX is the
     Analytics profile ID.
       */
      public String getIds() {
        return ids;
      }

      /**
     * Unique table ID for retrieving report data. Table ID is of the form ga:XXXX, where XXXX is
     * the Analytics profile ID.
     */
      public Get setIds(String ids) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
              "Parameter ids must conform to the pattern " +
              "ga:[0-9]+");
        }
        this.ids = ids;
        return this;
      }

      /**
     * Start date for fetching report data. All requests should specify a start date formatted as
     * YYYY-MM-DD.
     */
      @com.google.api.client.util.Key("start-date")
      private String startDate;

      /** Start date for fetching report data. All requests should specify a start date formatted as YYYY-MM-
     DD.
       */
      public String getStartDate() {
        return startDate;
      }

      /**
     * Start date for fetching report data. All requests should specify a start date formatted as
     * YYYY-MM-DD.
     */
      public Get setStartDate(String startDate) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
              "Parameter startDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.startDate = startDate;
        return this;
      }

      /**
     * End date for fetching report data. All requests should specify an end date formatted as YYYY-
     * MM-DD.
     */
      @com.google.api.client.util.Key("end-date")
      private String endDate;

      /** End date for fetching report data. All requests should specify an end date formatted as YYYY-MM-DD.
       */
      public String getEndDate() {
        return endDate;
      }

      /**
     * End date for fetching report data. All requests should specify an end date formatted as YYYY-
     * MM-DD.
     */
      public Get setEndDate(String endDate) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
              "Parameter endDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.endDate = endDate;
        return this;
      }

      /**
     * A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one
     * metric must be specified to retrieve a valid Analytics report.
     */
      @com.google.api.client.util.Key
      private String metrics;

      /** A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
     must be specified to retrieve a valid Analytics report.
       */
      public String getMetrics() {
        return metrics;
      }

      /**
     * A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one
     * metric must be specified to retrieve a valid Analytics report.
     */
      public Get setMetrics(String metrics) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
              "Parameter metrics must conform to the pattern " +
              "ga:.+");
        }
        this.metrics = metrics;
        return this;
      }

      /** The maximum number of entries to include in this feed. */
      @com.google.api.client.util.Key("max-results")
      private Integer maxResults;

      /** The maximum number of entries to include in this feed.
       */
      public Integer getMaxResults() {
        return maxResults;
      }

      /** The maximum number of entries to include in this feed. */
      public Get setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
     * A comma-separated list of dimensions or metrics that determine the sort order for the report
     * data.
     */
      @com.google.api.client.util.Key
      private String sort;

      /** A comma-separated list of dimensions or metrics that determine the sort order for the report data.
       */
      public String getSort() {
        return sort;
      }

      /**
     * A comma-separated list of dimensions or metrics that determine the sort order for the report
     * data.
     */
      public Get setSort(String sort) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
              "Parameter sort must conform to the pattern " +
              "(-)?ga:.+");
        }
        this.sort = sort;
        return this;
      }

      /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
      @com.google.api.client.util.Key
      private String dimensions;

      /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'.
       */
      public String getDimensions() {
        return dimensions;
      }

      /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
      public Get setDimensions(String dimensions) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
              "Parameter dimensions must conform to the pattern " +
              "(ga:.+)?");
        }
        this.dimensions = dimensions;
        return this;
      }

      /**
     * An index of the first entity to retrieve. Use this parameter as a pagination mechanism along
     * with the max-results parameter.
     */
      @com.google.api.client.util.Key("start-index")
      private Integer startIndex;

      /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
     the max-results parameter.

     [minimum: 1]
       */
      public Integer getStartIndex() {
        return startIndex;
      }

      /**
     * An index of the first entity to retrieve. Use this parameter as a pagination mechanism along
     * with the max-results parameter.
     */
      public Get setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      /** An Analytics advanced segment to be applied to the report data. */
      @com.google.api.client.util.Key
      private String segment;

      /** An Analytics advanced segment to be applied to the report data.
       */
      public String getSegment() {
        return segment;
      }

      /** An Analytics advanced segment to be applied to the report data. */
      public Get setSegment(String segment) {
        this.segment = segment;
        return this;
      }

      /** A comma-separated list of dimension or metric filters to be applied to the report data. */
      @com.google.api.client.util.Key
      private String filters;

      /** A comma-separated list of dimension or metric filters to be applied to the report data.
       */
      public String getFilters() {
        return filters;
      }

      /** A comma-separated list of dimension or metric filters to be applied to the report data. */
      public Get setFilters(String filters) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
              "Parameter filters must conform to the pattern " +
              "ga:.+");
        }
        this.filters = filters;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Management collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Management.List request = analytics.management().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Management management() {
    return new Management();
  }

  /**
   * The "management" collection of methods.
   */
  public class Management {

    /**
     * An accessor for creating requests from the Accounts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Accounts.List request = analytics.accounts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Accounts accounts() {
      return new Accounts();
    }

    /**
     * The "accounts" collection of methods.
     */
    public class Accounts {

      /**
       * Lists all accounts to which the user has access.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts";

        /**
         * Lists all accounts to which the user has access.
         *
         * Create a request for the method "accounts.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, Void.class);
          set("alt", "json");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of accounts to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of accounts to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of accounts to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first account to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first account to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first account to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Goals collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Goals.List request = analytics.goals().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Goals goals() {
      return new Goals();
    }

    /**
     * The "goals" collection of methods.
     */
    public class Goals {

      /**
       * Lists goals to which the user has access.
       *
       * Create a request for the method "goals.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
       * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
       * @param profileId Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which refers to all
       *        the profiles that user has access to.
       * @return the request
       */
      public List list(String accountId, String webPropertyId, String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";

        /**
         * Lists goals to which the user has access.
         *
         * Create a request for the method "goals.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
         * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
         * @param profileId Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which refers to all
       *        the profiles that user has access to.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId, String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, Void.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          set("alt", "json");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
       * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
       * refers to all the accounts that user has access to.
       */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to
       all the accounts that user has access to.
         */
        public String getAccountId() {
          return accountId;
        }

        /**
       * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
       * refers to all the accounts that user has access to.
       */
        public List setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
       * Web property ID to retrieve goals for. Can either be a specific web property ID or '~all',
       * which refers to all the web properties that user has access to.
       */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       refers to all the web properties that user has access to.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /**
       * Web property ID to retrieve goals for. Can either be a specific web property ID or '~all',
       * which refers to all the web properties that user has access to.
       */
        public List setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
       * Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which
       * refers to all the profiles that user has access to.
       */
        @com.google.api.client.util.Key
        private String profileId;

        /** Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which refers to
       all the profiles that user has access to.
         */
        public String getProfileId() {
          return profileId;
        }

        /**
       * Profile ID to retrieve goals for. Can either be a specific profile ID or '~all', which
       * refers to all the profiles that user has access to.
       */
        public List setProfileId(String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of goals to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of goals to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of goals to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first goal to retrieve. Use this parameter as a pagination mechanism along
       * with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the
       max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first goal to retrieve. Use this parameter as a pagination mechanism along
       * with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Profiles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Profiles.List request = analytics.profiles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Profiles profiles() {
      return new Profiles();
    }

    /**
     * The "profiles" collection of methods.
     */
    public class Profiles {

      /**
       * Lists profiles to which the user has access.
       *
       * Create a request for the method "profiles.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the profiles to retrieve. Can either be a specific account ID or '~all', which refers
       *        to all the accounts to which the user has access.
       * @param webPropertyId Web property ID for the profiles to retrieve. Can either be a specific web property ID or '~all',
       *        which refers to all the web properties to which the user has access.
       * @return the request
       */
      public List list(String accountId, String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";

        /**
         * Lists profiles to which the user has access.
         *
         * Create a request for the method "profiles.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the profiles to retrieve. Can either be a specific account ID or '~all', which refers
       *        to all the accounts to which the user has access.
         * @param webPropertyId Web property ID for the profiles to retrieve. Can either be a specific web property ID or '~all',
       *        which refers to all the web properties to which the user has access.
         * @since 1.13
         */
        protected List(String accountId, String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, Void.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          set("alt", "json");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
       * Account ID for the profiles to retrieve. Can either be a specific account ID or '~all',
       * which refers to all the accounts to which the user has access.
       */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID for the profiles to retrieve. Can either be a specific account ID or '~all', which
       refers to all the accounts to which the user has access.
         */
        public String getAccountId() {
          return accountId;
        }

        /**
       * Account ID for the profiles to retrieve. Can either be a specific account ID or '~all',
       * which refers to all the accounts to which the user has access.
       */
        public List setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
       * Web property ID for the profiles to retrieve. Can either be a specific web property ID or
       * '~all', which refers to all the web properties to which the user has access.
       */
        @com.google.api.client.util.Key
        private String webPropertyId;

        /** Web property ID for the profiles to retrieve. Can either be a specific web property ID or '~all',
       which refers to all the web properties to which the user has access.
         */
        public String getWebPropertyId() {
          return webPropertyId;
        }

        /**
       * Web property ID for the profiles to retrieve. Can either be a specific web property ID or
       * '~all', which refers to all the web properties to which the user has access.
       */
        public List setWebPropertyId(String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of profiles to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of profiles to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of profiles to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Segments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Segments.List request = analytics.segments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Segments segments() {
      return new Segments();
    }

    /**
     * The "segments" collection of methods.
     */
    public class Segments {

      /**
       * Lists advanced segments to which the user has access.
       *
       * Create a request for the method "segments.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/segments";

        /**
         * Lists advanced segments to which the user has access.
         *
         * Create a request for the method "segments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, Void.class);
          set("alt", "json");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of advanced segments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of advanced segments to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of advanced segments to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first advanced segment to retrieve. Use this parameter as a pagination
       * mechanism along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first advanced segment to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first advanced segment to retrieve. Use this parameter as a pagination
       * mechanism along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
    /**
     * An accessor for creating requests from the Webproperties collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Webproperties.List request = analytics.webproperties().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Webproperties webproperties() {
      return new Webproperties();
    }

    /**
     * The "webproperties" collection of methods.
     */
    public class Webproperties {

      /**
       * Lists web properties to which the user has access.
       *
       * Create a request for the method "webproperties.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
       * @return the request
       */
      public List list(String accountId) throws java.io.IOException {
        List result = new List(accountId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties";

        /**
         * Lists web properties to which the user has access.
         *
         * Create a request for the method "webproperties.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
         * @since 1.13
         */
        protected List(String accountId) {
          super(Analytics.this, "GET", REST_PATH, null, Void.class);
          this.accountId = Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          set("alt", "json");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
       * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
       * which refers to all the accounts that user has access to.
       */
        @com.google.api.client.util.Key
        private String accountId;

        /** Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       refers to all the accounts that user has access to.
         */
        public String getAccountId() {
          return accountId;
        }

        /**
       * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
       * which refers to all the accounts that user has access to.
       */
        public List setAccountId(String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** The maximum number of web properties to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private Integer maxResults;

        /** The maximum number of web properties to include in this response.
         */
        public Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of web properties to include in this response. */
        public List setMaxResults(Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        @com.google.api.client.util.Key("start-index")
        private Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public Integer getStartIndex() {
          return startIndex;
        }

        /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter.
       */
        public List setStartIndex(Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

      }

    }
  }

  /**
   * Builder for {@link Analytics}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport
     * @param jsonFactory JSON factory
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Analytics}. */
    @Override
    public Analytics build() {
      return new Analytics(getTransport(),
          getHttpRequestInitializer(),
          getRootUrl(),
          getServicePath(),
          getObjectParser(),
          getGoogleClientRequestInitializer(),
          getApplicationName(),
          getSuppressPatternChecks());
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    /**
     * Set the {@link AnalyticsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAnalyticsRequestInitializer(
        AnalyticsRequestInitializer analyticsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(analyticsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
