/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkstationConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workstationClusters/{workstation_cluster}/workstationConfigs/{workstation_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workstationCluster;
    private final String workstationConfig;

    @Deprecated
    protected WorkstationConfigName() {
        this.project = null;
        this.location = null;
        this.workstationCluster = null;
        this.workstationConfig = null;
    }

    private WorkstationConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workstationCluster = (String)Preconditions.checkNotNull((Object)builder.getWorkstationCluster());
        this.workstationConfig = (String)Preconditions.checkNotNull((Object)builder.getWorkstationConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkstationCluster() {
        return this.workstationCluster;
    }

    public String getWorkstationConfig() {
        return this.workstationConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkstationConfigName of(String project, String location, String workstationCluster, String workstationConfig) {
        return WorkstationConfigName.newBuilder().setProject(project).setLocation(location).setWorkstationCluster(workstationCluster).setWorkstationConfig(workstationConfig).build();
    }

    public static String format(String project, String location, String workstationCluster, String workstationConfig) {
        return WorkstationConfigName.newBuilder().setProject(project).setLocation(location).setWorkstationCluster(workstationCluster).setWorkstationConfig(workstationConfig).build().toString();
    }

    public static WorkstationConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG.validatedMatch(formattedString, "WorkstationConfigName.parse: formattedString not in valid format");
        return WorkstationConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workstation_cluster"), (String)matchMap.get("workstation_config"));
    }

    public static List<WorkstationConfigName> parseList(List<String> formattedStrings) {
        ArrayList<WorkstationConfigName> list = new ArrayList<WorkstationConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkstationConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkstationConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkstationConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkstationConfigName workstationConfigName = this;
            synchronized (workstationConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workstationCluster != null) {
                        fieldMapBuilder.put((Object)"workstation_cluster", (Object)this.workstationCluster);
                    }
                    if (this.workstationConfig != null) {
                        fieldMapBuilder.put((Object)"workstation_config", (Object)this.workstationConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "workstation_cluster", this.workstationCluster, "workstation_config", this.workstationConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            WorkstationConfigName that = (WorkstationConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workstationCluster, that.workstationCluster) && Objects.equals(this.workstationConfig, that.workstationConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.workstationCluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workstationConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workstationCluster;
        private String workstationConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkstationCluster() {
            return this.workstationCluster;
        }

        public String getWorkstationConfig() {
            return this.workstationConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkstationCluster(String workstationCluster) {
            this.workstationCluster = workstationCluster;
            return this;
        }

        public Builder setWorkstationConfig(String workstationConfig) {
            this.workstationConfig = workstationConfig;
            return this;
        }

        private Builder(WorkstationConfigName workstationConfigName) {
            this.project = workstationConfigName.project;
            this.location = workstationConfigName.location;
            this.workstationCluster = workstationConfigName.workstationCluster;
            this.workstationConfig = workstationConfigName.workstationConfig;
        }

        public WorkstationConfigName build() {
            return new WorkstationConfigName(this);
        }
    }
}

