/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorkflowName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workflows/{workflow}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workflow;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private WorkflowName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workflow = (String)Preconditions.checkNotNull((Object)builder.getWorkflow());
    }

    public static WorkflowName of(String project, String location, String workflow) {
        return WorkflowName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).build();
    }

    public static String format(String project, String location, String workflow) {
        return WorkflowName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).build().toString();
    }

    public static WorkflowName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "WorkflowName.parse: formattedString not in valid format");
        return WorkflowName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workflow"));
    }

    public static List<WorkflowName> parseList(List<String> formattedStrings) {
        ArrayList<WorkflowName> list = new ArrayList<WorkflowName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkflowName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkflowName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkflowName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkflowName workflowName = this;
            synchronized (workflowName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"workflow", (Object)this.workflow);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "workflow", this.workflow});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WorkflowName) {
            WorkflowName that = (WorkflowName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.workflow.equals(that.workflow);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.workflow.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String workflow;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        private Builder() {
        }

        private Builder(WorkflowName workflowName) {
            this.project = workflowName.project;
            this.location = workflowName.location;
            this.workflow = workflowName.workflow;
        }

        public WorkflowName build() {
            return new WorkflowName(this);
        }
    }
}

