/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.websecurityscanner.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ScanConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_SCAN_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/scanConfigs/{scan_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String scanConfig;

    @Deprecated
    protected ScanConfigName() {
        this.project = null;
        this.scanConfig = null;
    }

    private ScanConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.scanConfig = (String)Preconditions.checkNotNull((Object)builder.getScanConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getScanConfig() {
        return this.scanConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ScanConfigName of(String project, String scanConfig) {
        return ScanConfigName.newBuilder().setProject(project).setScanConfig(scanConfig).build();
    }

    public static String format(String project, String scanConfig) {
        return ScanConfigName.newBuilder().setProject(project).setScanConfig(scanConfig).build().toString();
    }

    public static ScanConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_SCAN_CONFIG.validatedMatch(formattedString, "ScanConfigName.parse: formattedString not in valid format");
        return ScanConfigName.of((String)matchMap.get("project"), (String)matchMap.get("scan_config"));
    }

    public static List<ScanConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ScanConfigName> list = new ArrayList<ScanConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ScanConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ScanConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ScanConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SCAN_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ScanConfigName scanConfigName = this;
            synchronized (scanConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.scanConfig != null) {
                        fieldMapBuilder.put((Object)"scan_config", (Object)this.scanConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_SCAN_CONFIG.instantiate(new String[]{"project", this.project, "scan_config", this.scanConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ScanConfigName that = (ScanConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.scanConfig, that.scanConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.scanConfig);
    }

    public static class Builder {
        private String project;
        private String scanConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getScanConfig() {
            return this.scanConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setScanConfig(String scanConfig) {
            this.scanConfig = scanConfig;
            return this;
        }

        private Builder(ScanConfigName scanConfigName) {
            this.project = scanConfigName.project;
            this.scanConfig = scanConfigName.scanConfig;
        }

        public ScanConfigName build() {
            return new ScanConfigName(this);
        }
    }
}

