/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LoggingServerName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRIVATE_CLOUD_LOGGING_SERVER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/privateClouds/{private_cloud}/loggingServers/{logging_server}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String privateCloud;
    private final String loggingServer;

    @Deprecated
    protected LoggingServerName() {
        this.project = null;
        this.location = null;
        this.privateCloud = null;
        this.loggingServer = null;
    }

    private LoggingServerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.privateCloud = (String)Preconditions.checkNotNull((Object)builder.getPrivateCloud());
        this.loggingServer = (String)Preconditions.checkNotNull((Object)builder.getLoggingServer());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrivateCloud() {
        return this.privateCloud;
    }

    public String getLoggingServer() {
        return this.loggingServer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LoggingServerName of(String project, String location, String privateCloud, String loggingServer) {
        return LoggingServerName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).setLoggingServer(loggingServer).build();
    }

    public static String format(String project, String location, String privateCloud, String loggingServer) {
        return LoggingServerName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).setLoggingServer(loggingServer).build().toString();
    }

    public static LoggingServerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRIVATE_CLOUD_LOGGING_SERVER.validatedMatch(formattedString, "LoggingServerName.parse: formattedString not in valid format");
        return LoggingServerName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("private_cloud"), (String)matchMap.get("logging_server"));
    }

    public static List<LoggingServerName> parseList(List<String> formattedStrings) {
        ArrayList<LoggingServerName> list = new ArrayList<LoggingServerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LoggingServerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LoggingServerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LoggingServerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRIVATE_CLOUD_LOGGING_SERVER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LoggingServerName loggingServerName = this;
            synchronized (loggingServerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.privateCloud != null) {
                        fieldMapBuilder.put((Object)"private_cloud", (Object)this.privateCloud);
                    }
                    if (this.loggingServer != null) {
                        fieldMapBuilder.put((Object)"logging_server", (Object)this.loggingServer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRIVATE_CLOUD_LOGGING_SERVER.instantiate(new String[]{"project", this.project, "location", this.location, "private_cloud", this.privateCloud, "logging_server", this.loggingServer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LoggingServerName that = (LoggingServerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.privateCloud, that.privateCloud) && Objects.equals(this.loggingServer, that.loggingServer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.privateCloud);
        h *= 1000003;
        return h ^= Objects.hashCode(this.loggingServer);
    }

    public static class Builder {
        private String project;
        private String location;
        private String privateCloud;
        private String loggingServer;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrivateCloud() {
            return this.privateCloud;
        }

        public String getLoggingServer() {
            return this.loggingServer;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrivateCloud(String privateCloud) {
            this.privateCloud = privateCloud;
            return this;
        }

        public Builder setLoggingServer(String loggingServer) {
            this.loggingServer = loggingServer;
            return this;
        }

        private Builder(LoggingServerName loggingServerName) {
            this.project = loggingServerName.project;
            this.location = loggingServerName.location;
            this.privateCloud = loggingServerName.privateCloud;
            this.loggingServer = loggingServerName.loggingServer;
        }

        public LoggingServerName build() {
            return new LoggingServerName(this);
        }
    }
}

