/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.database.v1;

public interface RestoreDatabaseMetadataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.spanner.admin.database.v1.RestoreDatabaseMetadata)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Name of the database being created and restored to.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the database being created and restored to.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The type of the restore source.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
   *
   * @return The enum numeric value on the wire for sourceType.
   */
  int getSourceTypeValue();

  /**
   *
   *
   * <pre>
   * The type of the restore source.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
   *
   * @return The sourceType.
   */
  com.google.spanner.admin.database.v1.RestoreSourceType getSourceType();

  /**
   *
   *
   * <pre>
   * Information about the backup used to restore the database.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
   *
   * @return Whether the backupInfo field is set.
   */
  boolean hasBackupInfo();

  /**
   *
   *
   * <pre>
   * Information about the backup used to restore the database.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
   *
   * @return The backupInfo.
   */
  com.google.spanner.admin.database.v1.BackupInfo getBackupInfo();

  /**
   *
   *
   * <pre>
   * Information about the backup used to restore the database.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
   */
  com.google.spanner.admin.database.v1.BackupInfoOrBuilder getBackupInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
   *
   * @return Whether the progress field is set.
   */
  boolean hasProgress();

  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
   *
   * @return The progress.
   */
  com.google.spanner.admin.database.v1.OperationProgress getProgress();

  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
   */
  com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder();

  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
   * `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
   *
   * @return Whether the cancelTime field is set.
   */
  boolean hasCancelTime();

  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
   * `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
   *
   * @return The cancelTime.
   */
  com.google.protobuf.Timestamp getCancelTime();

  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
   * `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCancelTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * If exists, the name of the long-running operation that will be used to
   * track the post-restore optimization process to optimize the performance of
   * the restored database, and remove the dependency on the restore source.
   * The name is of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
   * where the &lt;database&gt; is the name of database being created and restored to.
   * The metadata type of the  long-running operation is
   * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata].
   * This long-running operation will be automatically created by the system
   * after the RestoreDatabase long-running operation completes successfully.
   * This operation will not be created if the restore was not successful.
   * </pre>
   *
   * <code>string optimize_database_operation_name = 6;</code>
   *
   * @return The optimizeDatabaseOperationName.
   */
  java.lang.String getOptimizeDatabaseOperationName();

  /**
   *
   *
   * <pre>
   * If exists, the name of the long-running operation that will be used to
   * track the post-restore optimization process to optimize the performance of
   * the restored database, and remove the dependency on the restore source.
   * The name is of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
   * where the &lt;database&gt; is the name of database being created and restored to.
   * The metadata type of the  long-running operation is
   * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata].
   * This long-running operation will be automatically created by the system
   * after the RestoreDatabase long-running operation completes successfully.
   * This operation will not be created if the restore was not successful.
   * </pre>
   *
   * <code>string optimize_database_operation_name = 6;</code>
   *
   * @return The bytes for optimizeDatabaseOperationName.
   */
  com.google.protobuf.ByteString getOptimizeDatabaseOperationNameBytes();

  com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.SourceInfoCase getSourceInfoCase();
}
