/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup_schedule.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * CrontabSpec can be used to specify the version time and frequency at
 * which the backup should be created.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.CrontabSpec}
 */
public final class CrontabSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.CrontabSpec)
    CrontabSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CrontabSpec.newBuilder() to construct.
  private CrontabSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CrontabSpec() {
    text_ = "";
    timeZone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CrontabSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupScheduleProto
        .internal_static_google_spanner_admin_database_v1_CrontabSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupScheduleProto
        .internal_static_google_spanner_admin_database_v1_CrontabSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.CrontabSpec.class,
            com.google.spanner.admin.database.v1.CrontabSpec.Builder.class);
  }

  private int bitField0_;
  public static final int TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object text_ = "";

  /**
   *
   *
   * <pre>
   * Required. Textual representation of the crontab. User can customize the
   * backup frequency and the backup version time using the cron
   * expression. The version time must be in UTC timezone.
   *
   * The backup will contain an externally consistent copy of the
   * database at the version time. Allowed frequencies are 12 hour, 1 day,
   * 1 week and 1 month. Examples of valid cron specifications:
   *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
   *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
   *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
   *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
   *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
   * </pre>
   *
   * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Textual representation of the crontab. User can customize the
   * backup frequency and the backup version time using the cron
   * expression. The version time must be in UTC timezone.
   *
   * The backup will contain an externally consistent copy of the
   * database at the version time. Allowed frequencies are 12 hour, 1 day,
   * 1 week and 1 month. Examples of valid cron specifications:
   *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
   *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
   *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
   *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
   *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
   * </pre>
   *
   * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for text.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The time zone of the times in `CrontabSpec.text`. Currently
   * only UTC is supported.
   * </pre>
   *
   * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The time zone of the times in `CrontabSpec.text`. Currently
   * only UTC is supported.
   * </pre>
   *
   * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_WINDOW_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration creationWindow_;

  /**
   *
   *
   * <pre>
   * Output only. Schedule backups will contain an externally consistent copy
   * of the database at the version time specified in
   * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
   * of the scheduled backups at that version time. Spanner will initiate
   * the creation of scheduled backups within the time window bounded by the
   * version_time specified in `schedule_spec.cron_spec` and version_time +
   * `creation_window`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the creationWindow field is set.
   */
  @java.lang.Override
  public boolean hasCreationWindow() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Schedule backups will contain an externally consistent copy
   * of the database at the version time specified in
   * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
   * of the scheduled backups at that version time. Spanner will initiate
   * the creation of scheduled backups within the time window bounded by the
   * version_time specified in `schedule_spec.cron_spec` and version_time +
   * `creation_window`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationWindow.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getCreationWindow() {
    return creationWindow_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : creationWindow_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Schedule backups will contain an externally consistent copy
   * of the database at the version time specified in
   * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
   * of the scheduled backups at that version time. Spanner will initiate
   * the creation of scheduled backups within the time window bounded by the
   * version_time specified in `schedule_spec.cron_spec` and version_time +
   * `creation_window`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getCreationWindowOrBuilder() {
    return creationWindow_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : creationWindow_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, timeZone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreationWindow());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, timeZone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreationWindow());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.CrontabSpec)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.CrontabSpec other =
        (com.google.spanner.admin.database.v1.CrontabSpec) obj;

    if (!getText().equals(other.getText())) return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (hasCreationWindow() != other.hasCreationWindow()) return false;
    if (hasCreationWindow()) {
      if (!getCreationWindow().equals(other.getCreationWindow())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (hasCreationWindow()) {
      hash = (37 * hash) + CREATION_WINDOW_FIELD_NUMBER;
      hash = (53 * hash) + getCreationWindow().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.CrontabSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * CrontabSpec can be used to specify the version time and frequency at
   * which the backup should be created.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.CrontabSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.CrontabSpec)
      com.google.spanner.admin.database.v1.CrontabSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupScheduleProto
          .internal_static_google_spanner_admin_database_v1_CrontabSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupScheduleProto
          .internal_static_google_spanner_admin_database_v1_CrontabSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.CrontabSpec.class,
              com.google.spanner.admin.database.v1.CrontabSpec.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.CrontabSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreationWindowFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      text_ = "";
      timeZone_ = "";
      creationWindow_ = null;
      if (creationWindowBuilder_ != null) {
        creationWindowBuilder_.dispose();
        creationWindowBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupScheduleProto
          .internal_static_google_spanner_admin_database_v1_CrontabSpec_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CrontabSpec getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.CrontabSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CrontabSpec build() {
      com.google.spanner.admin.database.v1.CrontabSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CrontabSpec buildPartial() {
      com.google.spanner.admin.database.v1.CrontabSpec result =
          new com.google.spanner.admin.database.v1.CrontabSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.CrontabSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.text_ = text_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.timeZone_ = timeZone_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationWindow_ =
            creationWindowBuilder_ == null ? creationWindow_ : creationWindowBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.CrontabSpec) {
        return mergeFrom((com.google.spanner.admin.database.v1.CrontabSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.CrontabSpec other) {
      if (other == com.google.spanner.admin.database.v1.CrontabSpec.getDefaultInstance())
        return this;
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreationWindow()) {
        mergeCreationWindow(other.getCreationWindow());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                text_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreationWindowFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timezone.
     *
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timezone.
     *
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timezone.
     *
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timezone.
     *
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      text_ = getDefaultInstance().getText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timezone.
     *
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     * </pre>
     *
     * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     * </pre>
     *
     * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     * </pre>
     *
     * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     * </pre>
     *
     * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     * </pre>
     *
     * <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration creationWindow_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        creationWindowBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the creationWindow field is set.
     */
    public boolean hasCreationWindow() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationWindow.
     */
    public com.google.protobuf.Duration getCreationWindow() {
      if (creationWindowBuilder_ == null) {
        return creationWindow_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : creationWindow_;
      } else {
        return creationWindowBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationWindow(com.google.protobuf.Duration value) {
      if (creationWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        creationWindow_ = value;
      } else {
        creationWindowBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationWindow(com.google.protobuf.Duration.Builder builderForValue) {
      if (creationWindowBuilder_ == null) {
        creationWindow_ = builderForValue.build();
      } else {
        creationWindowBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreationWindow(com.google.protobuf.Duration value) {
      if (creationWindowBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && creationWindow_ != null
            && creationWindow_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getCreationWindowBuilder().mergeFrom(value);
        } else {
          creationWindow_ = value;
        }
      } else {
        creationWindowBuilder_.mergeFrom(value);
      }
      if (creationWindow_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreationWindow() {
      bitField0_ = (bitField0_ & ~0x00000004);
      creationWindow_ = null;
      if (creationWindowBuilder_ != null) {
        creationWindowBuilder_.dispose();
        creationWindowBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getCreationWindowBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreationWindowFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getCreationWindowOrBuilder() {
      if (creationWindowBuilder_ != null) {
        return creationWindowBuilder_.getMessageOrBuilder();
      } else {
        return creationWindow_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : creationWindow_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getCreationWindowFieldBuilder() {
      if (creationWindowBuilder_ == null) {
        creationWindowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getCreationWindow(), getParentForChildren(), isClean());
        creationWindow_ = null;
      }
      return creationWindowBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.CrontabSpec)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.CrontabSpec)
  private static final com.google.spanner.admin.database.v1.CrontabSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.CrontabSpec();
  }

  public static com.google.spanner.admin.database.v1.CrontabSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CrontabSpec> PARSER =
      new com.google.protobuf.AbstractParser<CrontabSpec>() {
        @java.lang.Override
        public CrontabSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CrontabSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CrontabSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.CrontabSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
