/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.RestoreDatabaseRequest}
 */
public final class RestoreDatabaseRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.RestoreDatabaseRequest)
    RestoreDatabaseRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreDatabaseRequest.newBuilder() to construct.
  private RestoreDatabaseRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreDatabaseRequest() {
    parent_ = "";
    databaseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreDatabaseRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_RestoreDatabaseRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_RestoreDatabaseRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.RestoreDatabaseRequest.class,
            com.google.spanner.admin.database.v1.RestoreDatabaseRequest.Builder.class);
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BACKUP(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 3:
          return BACKUP;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the instance in which to create the
   * restored database. This instance must be in the same project and
   * have the same instance configuration as the instance containing
   * the source backup. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the instance in which to create the
   * restored database. This instance must be in the same project and
   * have the same instance configuration as the instance containing
   * the source backup. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The id of the database to create and restore to. This
   * database must not already exist. The `database_id` appended to
   * `parent` forms the full database name of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
   * </pre>
   *
   * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The databaseId.
   */
  @java.lang.Override
  public java.lang.String getDatabaseId() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The id of the database to create and restore to. This
   * database must not already exist. The `database_id` appended to
   * `parent` forms the full database name of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
   * </pre>
   *
   * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for databaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseIdBytes() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Name of the backup from which to restore.  Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the backup field is set.
   */
  public boolean hasBackup() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Name of the backup from which to restore.  Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The backup.
   */
  public java.lang.String getBackup() {
    java.lang.Object ref = "";
    if (sourceCase_ == 3) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 3) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the backup from which to restore.  Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for backup.
   */
  public com.google.protobuf.ByteString getBackupBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 3) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 3) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. An encryption configuration describing the encryption type and
   * key resources in Cloud KMS used to encrypt/decrypt the database to restore
   * to. If this field is not specified, the restored database will use the same
   * encryption configuration as the backup by default, namely
   * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
   * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An encryption configuration describing the encryption type and
   * key resources in Cloud KMS used to encrypt/decrypt the database to restore
   * to. If this field is not specified, the restored database will use the same
   * encryption configuration as the backup by default, namely
   * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
   * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig
      getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An encryption configuration describing the encryption type and
   * key resources in Cloud KMS used to encrypt/decrypt the database to restore
   * to. If this field is not specified, the restored database will use the same
   * encryption configuration as the backup by default, namely
   * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
   * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, databaseId_);
    }
    if (sourceCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getEncryptionConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, databaseId_);
    }
    if (sourceCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEncryptionConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.RestoreDatabaseRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.RestoreDatabaseRequest other =
        (com.google.spanner.admin.database.v1.RestoreDatabaseRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDatabaseId().equals(other.getDatabaseId())) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 3:
        if (!getBackup().equals(other.getBackup())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DATABASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseId().hashCode();
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    switch (sourceCase_) {
      case 3:
        hash = (37 * hash) + BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getBackup().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.RestoreDatabaseRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.RestoreDatabaseRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.RestoreDatabaseRequest)
      com.google.spanner.admin.database.v1.RestoreDatabaseRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_RestoreDatabaseRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_RestoreDatabaseRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.RestoreDatabaseRequest.class,
              com.google.spanner.admin.database.v1.RestoreDatabaseRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.RestoreDatabaseRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      databaseId_ = "";
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_RestoreDatabaseRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreDatabaseRequest getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.RestoreDatabaseRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreDatabaseRequest build() {
      com.google.spanner.admin.database.v1.RestoreDatabaseRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreDatabaseRequest buildPartial() {
      com.google.spanner.admin.database.v1.RestoreDatabaseRequest result =
          new com.google.spanner.admin.database.v1.RestoreDatabaseRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.RestoreDatabaseRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.databaseId_ = databaseId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.spanner.admin.database.v1.RestoreDatabaseRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.RestoreDatabaseRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.RestoreDatabaseRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.RestoreDatabaseRequest other) {
      if (other == com.google.spanner.admin.database.v1.RestoreDatabaseRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDatabaseId().isEmpty()) {
        databaseId_ = other.databaseId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      switch (other.getSourceCase()) {
        case BACKUP:
          {
            sourceCase_ = 3;
            source_ = other.source_;
            onChanged();
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                databaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 3;
                source_ = s;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the instance in which to create the
     * restored database. This instance must be in the same project and
     * have the same instance configuration as the instance containing
     * the source backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance in which to create the
     * restored database. This instance must be in the same project and
     * have the same instance configuration as the instance containing
     * the source backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance in which to create the
     * restored database. This instance must be in the same project and
     * have the same instance configuration as the instance containing
     * the source backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance in which to create the
     * restored database. This instance must be in the same project and
     * have the same instance configuration as the instance containing
     * the source backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance in which to create the
     * restored database. This instance must be in the same project and
     * have the same instance configuration as the instance containing
     * the source backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object databaseId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The id of the database to create and restore to. This
     * database must not already exist. The `database_id` appended to
     * `parent` forms the full database name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The databaseId.
     */
    public java.lang.String getDatabaseId() {
      java.lang.Object ref = databaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the database to create and restore to. This
     * database must not already exist. The `database_id` appended to
     * `parent` forms the full database name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for databaseId.
     */
    public com.google.protobuf.ByteString getDatabaseIdBytes() {
      java.lang.Object ref = databaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the database to create and restore to. This
     * database must not already exist. The `database_id` appended to
     * `parent` forms the full database name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the database to create and restore to. This
     * database must not already exist. The `database_id` appended to
     * `parent` forms the full database name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseId() {
      databaseId_ = getDefaultInstance().getDatabaseId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the database to create and restore to. This
     * database must not already exist. The `database_id` appended to
     * `parent` forms the full database name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database_id&gt;`.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the backup from which to restore.  Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the backup field is set.
     */
    @java.lang.Override
    public boolean hasBackup() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Name of the backup from which to restore.  Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The backup.
     */
    @java.lang.Override
    public java.lang.String getBackup() {
      java.lang.Object ref = "";
      if (sourceCase_ == 3) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 3) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the backup from which to restore.  Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for backup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBackupBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 3) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 3) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the backup from which to restore.  Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 3;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the backup from which to restore.  Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackup() {
      if (sourceCase_ == 3) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the backup from which to restore.  Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 3;
      source_ = value;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig,
            com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig
        getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig
                .getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.Builder
            builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig
                    .getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig
                .getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An encryption configuration describing the encryption type and
     * key resources in Cloud KMS used to encrypt/decrypt the database to restore
     * to. If this field is not specified, the restored database will use the same
     * encryption configuration as the backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig,
            com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig,
                com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.RestoreDatabaseRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.RestoreDatabaseRequest)
  private static final com.google.spanner.admin.database.v1.RestoreDatabaseRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.RestoreDatabaseRequest();
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreDatabaseRequest> PARSER =
      new com.google.protobuf.AbstractParser<RestoreDatabaseRequest>() {
        @java.lang.Override
        public RestoreDatabaseRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreDatabaseRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreDatabaseRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreDatabaseRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
