/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/common.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Encryption configuration for a Cloud Spanner database.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.EncryptionConfig}
 */
public final class EncryptionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.EncryptionConfig)
    EncryptionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EncryptionConfig.newBuilder() to construct.
  private EncryptionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EncryptionConfig() {
    kmsKeyName_ = "";
    kmsKeyNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EncryptionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.CommonProto
        .internal_static_google_spanner_admin_database_v1_EncryptionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.CommonProto
        .internal_static_google_spanner_admin_database_v1_EncryptionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.EncryptionConfig.class,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder.class);
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud KMS key to be used for encrypting and decrypting
   * the database. Values are of the form
   * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
   * </pre>
   *
   * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS key to be used for encrypting and decrypting
   * the database. Values are of the form
   * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
   * </pre>
   *
   * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_NAMES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList kmsKeyNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Specifies the KMS configuration for the one or more keys used to encrypt
   * the database. Values are of the form
   * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
   *
   * The keys referenced by kms_key_names must fully cover all
   * regions of the database instance configuration. Some examples:
   * * For single region database instance configs, specify a single regional
   * location KMS key.
   * * For multi-regional database instance configs of type GOOGLE_MANAGED,
   * either specify a multi-regional location KMS key or multiple regional
   * location KMS keys that cover all regions in the instance config.
   * * For a database instance config of type USER_MANAGED, please specify only
   * regional location KMS keys to cover each region in the instance config.
   * Multi-regional location KMS keys are not supported for USER_MANAGED
   * instance configs.
   * </pre>
   *
   * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the kmsKeyNames.
   */
  public com.google.protobuf.ProtocolStringList getKmsKeyNamesList() {
    return kmsKeyNames_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the KMS configuration for the one or more keys used to encrypt
   * the database. Values are of the form
   * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
   *
   * The keys referenced by kms_key_names must fully cover all
   * regions of the database instance configuration. Some examples:
   * * For single region database instance configs, specify a single regional
   * location KMS key.
   * * For multi-regional database instance configs of type GOOGLE_MANAGED,
   * either specify a multi-regional location KMS key or multiple regional
   * location KMS keys that cover all regions in the instance config.
   * * For a database instance config of type USER_MANAGED, please specify only
   * regional location KMS keys to cover each region in the instance config.
   * Multi-regional location KMS keys are not supported for USER_MANAGED
   * instance configs.
   * </pre>
   *
   * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of kmsKeyNames.
   */
  public int getKmsKeyNamesCount() {
    return kmsKeyNames_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the KMS configuration for the one or more keys used to encrypt
   * the database. Values are of the form
   * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
   *
   * The keys referenced by kms_key_names must fully cover all
   * regions of the database instance configuration. Some examples:
   * * For single region database instance configs, specify a single regional
   * location KMS key.
   * * For multi-regional database instance configs of type GOOGLE_MANAGED,
   * either specify a multi-regional location KMS key or multiple regional
   * location KMS keys that cover all regions in the instance config.
   * * For a database instance config of type USER_MANAGED, please specify only
   * regional location KMS keys to cover each region in the instance config.
   * Multi-regional location KMS keys are not supported for USER_MANAGED
   * instance configs.
   * </pre>
   *
   * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The kmsKeyNames at the given index.
   */
  public java.lang.String getKmsKeyNames(int index) {
    return kmsKeyNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies the KMS configuration for the one or more keys used to encrypt
   * the database. Values are of the form
   * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
   *
   * The keys referenced by kms_key_names must fully cover all
   * regions of the database instance configuration. Some examples:
   * * For single region database instance configs, specify a single regional
   * location KMS key.
   * * For multi-regional database instance configs of type GOOGLE_MANAGED,
   * either specify a multi-regional location KMS key or multiple regional
   * location KMS keys that cover all regions in the instance config.
   * * For a database instance config of type USER_MANAGED, please specify only
   * regional location KMS keys to cover each region in the instance config.
   * Multi-regional location KMS keys are not supported for USER_MANAGED
   * instance configs.
   * </pre>
   *
   * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the kmsKeyNames at the given index.
   */
  public com.google.protobuf.ByteString getKmsKeyNamesBytes(int index) {
    return kmsKeyNames_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kmsKeyName_);
    }
    for (int i = 0; i < kmsKeyNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kmsKeyNames_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kmsKeyName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < kmsKeyNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(kmsKeyNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getKmsKeyNamesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.EncryptionConfig)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.EncryptionConfig other =
        (com.google.spanner.admin.database.v1.EncryptionConfig) obj;

    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getKmsKeyNamesList().equals(other.getKmsKeyNamesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    if (getKmsKeyNamesCount() > 0) {
      hash = (37 * hash) + KMS_KEY_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKeyNamesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.EncryptionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encryption configuration for a Cloud Spanner database.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.EncryptionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.EncryptionConfig)
      com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.CommonProto
          .internal_static_google_spanner_admin_database_v1_EncryptionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.CommonProto
          .internal_static_google_spanner_admin_database_v1_EncryptionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.EncryptionConfig.class,
              com.google.spanner.admin.database.v1.EncryptionConfig.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.EncryptionConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      kmsKeyName_ = "";
      kmsKeyNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.CommonProto
          .internal_static_google_spanner_admin_database_v1_EncryptionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.EncryptionConfig getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.EncryptionConfig build() {
      com.google.spanner.admin.database.v1.EncryptionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.EncryptionConfig buildPartial() {
      com.google.spanner.admin.database.v1.EncryptionConfig result =
          new com.google.spanner.admin.database.v1.EncryptionConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.EncryptionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        kmsKeyNames_.makeImmutable();
        result.kmsKeyNames_ = kmsKeyNames_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.EncryptionConfig) {
        return mergeFrom((com.google.spanner.admin.database.v1.EncryptionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.EncryptionConfig other) {
      if (other == com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance())
        return this;
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.kmsKeyNames_.isEmpty()) {
        if (kmsKeyNames_.isEmpty()) {
          kmsKeyNames_ = other.kmsKeyNames_;
          bitField0_ |= 0x00000002;
        } else {
          ensureKmsKeyNamesIsMutable();
          kmsKeyNames_.addAll(other.kmsKeyNames_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureKmsKeyNamesIsMutable();
                kmsKeyNames_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud KMS key to be used for encrypting and decrypting
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS key to be used for encrypting and decrypting
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS key to be used for encrypting and decrypting
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS key to be used for encrypting and decrypting
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS key to be used for encrypting and decrypting
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList kmsKeyNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureKmsKeyNamesIsMutable() {
      if (!kmsKeyNames_.isModifiable()) {
        kmsKeyNames_ = new com.google.protobuf.LazyStringArrayList(kmsKeyNames_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the kmsKeyNames.
     */
    public com.google.protobuf.ProtocolStringList getKmsKeyNamesList() {
      kmsKeyNames_.makeImmutable();
      return kmsKeyNames_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of kmsKeyNames.
     */
    public int getKmsKeyNamesCount() {
      return kmsKeyNames_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The kmsKeyNames at the given index.
     */
    public java.lang.String getKmsKeyNames(int index) {
      return kmsKeyNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the kmsKeyNames at the given index.
     */
    public com.google.protobuf.ByteString getKmsKeyNamesBytes(int index) {
      return kmsKeyNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The kmsKeyNames to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKmsKeyNamesIsMutable();
      kmsKeyNames_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyNames to add.
     * @return This builder for chaining.
     */
    public Builder addKmsKeyNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKmsKeyNamesIsMutable();
      kmsKeyNames_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The kmsKeyNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllKmsKeyNames(java.lang.Iterable<java.lang.String> values) {
      ensureKmsKeyNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, kmsKeyNames_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyNames() {
      kmsKeyNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the KMS configuration for the one or more keys used to encrypt
     * the database. Values are of the form
     * `projects/&lt;project&gt;/locations/&lt;location&gt;/keyRings/&lt;key_ring&gt;/cryptoKeys/&lt;kms_key_name&gt;`.
     *
     * The keys referenced by kms_key_names must fully cover all
     * regions of the database instance configuration. Some examples:
     * * For single region database instance configs, specify a single regional
     * location KMS key.
     * * For multi-regional database instance configs of type GOOGLE_MANAGED,
     * either specify a multi-regional location KMS key or multiple regional
     * location KMS keys that cover all regions in the instance config.
     * * For a database instance config of type USER_MANAGED, please specify only
     * regional location KMS keys to cover each region in the instance config.
     * Multi-regional location KMS keys are not supported for USER_MANAGED
     * instance configs.
     * </pre>
     *
     * <code>repeated string kms_key_names = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the kmsKeyNames to add.
     * @return This builder for chaining.
     */
    public Builder addKmsKeyNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureKmsKeyNamesIsMutable();
      kmsKeyNames_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.EncryptionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.EncryptionConfig)
  private static final com.google.spanner.admin.database.v1.EncryptionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.EncryptionConfig();
  }

  public static com.google.spanner.admin.database.v1.EncryptionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EncryptionConfig> PARSER =
      new com.google.protobuf.AbstractParser<EncryptionConfig>() {
        @java.lang.Override
        public EncryptionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EncryptionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EncryptionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
