/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.database.v1;

public interface DatabaseOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.spanner.admin.database.v1.Database)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the database. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
   * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
   * statement. This name can be passed to other API methods to
   * identify the database.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The name of the database. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
   * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
   * statement. This name can be passed to other API methods to
   * identify the database.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current database state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current database state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.spanner.admin.database.v1.Database.State getState();

  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the restoreInfo field is set.
   */
  boolean hasRestoreInfo();
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The restoreInfo.
   */
  com.google.spanner.admin.database.v1.RestoreInfo getRestoreInfo();
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.RestoreInfoOrBuilder getRestoreInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption configuration for the database.
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  boolean hasEncryptionConfig();
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption configuration for the database.
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionConfig.
   */
  com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig();
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption configuration for the database.
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder getEncryptionConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo> getEncryptionInfoList();
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInfo(int index);
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getEncryptionInfoCount();
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
      getEncryptionInfoOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. The period in which Cloud Spanner retains all versions of data
   * for the database. This is the same as the value of version_retention_period
   * database option set using
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
   * Defaults to 1 hour, if not set.
   * </pre>
   *
   * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The versionRetentionPeriod.
   */
  java.lang.String getVersionRetentionPeriod();
  /**
   *
   *
   * <pre>
   * Output only. The period in which Cloud Spanner retains all versions of data
   * for the database. This is the same as the value of version_retention_period
   * database option set using
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
   * Defaults to 1 hour, if not set.
   * </pre>
   *
   * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for versionRetentionPeriod.
   */
  com.google.protobuf.ByteString getVersionRetentionPeriodBytes();

  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read. This value is continuously updated by Cloud Spanner and becomes stale
   * the moment it is queried. If you are using this value to recover data, make
   * sure to account for the time from the moment when the value is queried to
   * the moment when you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the earliestVersionTime field is set.
   */
  boolean hasEarliestVersionTime();
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read. This value is continuously updated by Cloud Spanner and becomes stale
   * the moment it is queried. If you are using this value to recover data, make
   * sure to account for the time from the moment when the value is queried to
   * the moment when you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The earliestVersionTime.
   */
  com.google.protobuf.Timestamp getEarliestVersionTime();
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read. This value is continuously updated by Cloud Spanner and becomes stale
   * the moment it is queried. If you are using this value to recover data, make
   * sure to account for the time from the moment when the value is queried to
   * the moment when you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The read-write region which contains the database's leader
   * replicas.
   *
   * This is the same as the value of default_leader
   * database option set using DatabaseAdmin.CreateDatabase or
   * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
   * </pre>
   *
   * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The defaultLeader.
   */
  java.lang.String getDefaultLeader();
  /**
   *
   *
   * <pre>
   * Output only. The read-write region which contains the database's leader
   * replicas.
   *
   * This is the same as the value of default_leader
   * database option set using DatabaseAdmin.CreateDatabase or
   * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
   * </pre>
   *
   * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for defaultLeader.
   */
  com.google.protobuf.ByteString getDefaultLeaderBytes();

  /**
   *
   *
   * <pre>
   * Output only. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDialect.
   */
  int getDatabaseDialectValue();
  /**
   *
   *
   * <pre>
   * Output only. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The databaseDialect.
   */
  com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect();

  /**
   *
   *
   * <pre>
   * Whether drop protection is enabled for this database. Defaults to false,
   * if not set. For more details, please see how to [prevent accidental
   * database
   * deletion](https://cloud.google.com/spanner/docs/prevent-database-deletion).
   * </pre>
   *
   * <code>bool enable_drop_protection = 11;</code>
   *
   * @return The enableDropProtection.
   */
  boolean getEnableDropProtection();

  /**
   *
   *
   * <pre>
   * Output only. If true, the database is being updated. If false, there are no
   * ongoing update operations for the database.
   * </pre>
   *
   * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  boolean getReconciling();
}
