/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.CreateDatabaseRequest}
 */
public final class CreateDatabaseRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.CreateDatabaseRequest)
    CreateDatabaseRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateDatabaseRequest.newBuilder() to construct.
  private CreateDatabaseRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateDatabaseRequest() {
    parent_ = "";
    createStatement_ = "";
    extraStatements_ = com.google.protobuf.LazyStringArrayList.emptyList();
    databaseDialect_ = 0;
    protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateDatabaseRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.CreateDatabaseRequest.class,
            com.google.spanner.admin.database.v1.CreateDatabaseRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the instance that will serve the new database.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the instance that will serve the new database.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_STATEMENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object createStatement_ = "";
  /**
   *
   *
   * <pre>
   * Required. A `CREATE DATABASE` statement, which specifies the ID of the
   * new database.  The database ID must conform to the regular expression
   * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
   * If the database ID is a reserved word or if it contains a hyphen, the
   * database ID must be enclosed in backticks (`` ` ``).
   * </pre>
   *
   * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The createStatement.
   */
  @java.lang.Override
  public java.lang.String getCreateStatement() {
    java.lang.Object ref = createStatement_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      createStatement_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A `CREATE DATABASE` statement, which specifies the ID of the
   * new database.  The database ID must conform to the regular expression
   * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
   * If the database ID is a reserved word or if it contains a hyphen, the
   * database ID must be enclosed in backticks (`` ` ``).
   * </pre>
   *
   * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for createStatement.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreateStatementBytes() {
    java.lang.Object ref = createStatement_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      createStatement_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTRA_STATEMENTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList extraStatements_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the extraStatements.
   */
  public com.google.protobuf.ProtocolStringList getExtraStatementsList() {
    return extraStatements_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of extraStatements.
   */
  public int getExtraStatementsCount() {
    return extraStatements_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The extraStatements at the given index.
   */
  public java.lang.String getExtraStatements(int index) {
    return extraStatements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the extraStatements at the given index.
   */
  public com.google.protobuf.ByteString getExtraStatementsBytes(int index) {
    return extraStatements_.getByteString(index);
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration for the database. If this field is
   * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
   * Google default encryption.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration for the database. If this field is
   * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
   * Google default encryption.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration for the database. If this field is
   * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
   * Google default encryption.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  public static final int DATABASE_DIALECT_FIELD_NUMBER = 5;
  private int databaseDialect_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDialect.
   */
  @java.lang.Override
  public int getDatabaseDialectValue() {
    return databaseDialect_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The databaseDialect.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
    com.google.spanner.admin.database.v1.DatabaseDialect result =
        com.google.spanner.admin.database.v1.DatabaseDialect.forNumber(databaseDialect_);
    return result == null
        ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
        : result;
  }

  public static final int PROTO_DESCRIPTORS_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements in
   * 'extra_statements' above.
   * Contains a protobuf-serialized
   * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
   * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
   * run `protoc` with --include_imports and --descriptor_set_out. For example,
   * to generate for moon/shot/app.proto, run
   * ```
   * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
   *          --include_imports &#92;
   *          --descriptor_set_out=descriptors.data &#92;
   *          moon/shot/app.proto
   * ```
   * For more details, see protobuffer [self
   * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
   * </pre>
   *
   * <code>bytes proto_descriptors = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The protoDescriptors.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtoDescriptors() {
    return protoDescriptors_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createStatement_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, createStatement_);
    }
    for (int i = 0; i < extraStatements_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, extraStatements_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getEncryptionConfig());
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, databaseDialect_);
    }
    if (!protoDescriptors_.isEmpty()) {
      output.writeBytes(6, protoDescriptors_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createStatement_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, createStatement_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < extraStatements_.size(); i++) {
        dataSize += computeStringSizeNoTag(extraStatements_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExtraStatementsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEncryptionConfig());
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, databaseDialect_);
    }
    if (!protoDescriptors_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, protoDescriptors_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.CreateDatabaseRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.CreateDatabaseRequest other =
        (com.google.spanner.admin.database.v1.CreateDatabaseRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getCreateStatement().equals(other.getCreateStatement())) return false;
    if (!getExtraStatementsList().equals(other.getExtraStatementsList())) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (databaseDialect_ != other.databaseDialect_) return false;
    if (!getProtoDescriptors().equals(other.getProtoDescriptors())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + CREATE_STATEMENT_FIELD_NUMBER;
    hash = (53 * hash) + getCreateStatement().hashCode();
    if (getExtraStatementsCount() > 0) {
      hash = (37 * hash) + EXTRA_STATEMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getExtraStatementsList().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    hash = (37 * hash) + DATABASE_DIALECT_FIELD_NUMBER;
    hash = (53 * hash) + databaseDialect_;
    hash = (37 * hash) + PROTO_DESCRIPTORS_FIELD_NUMBER;
    hash = (53 * hash) + getProtoDescriptors().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.CreateDatabaseRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.CreateDatabaseRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.CreateDatabaseRequest)
      com.google.spanner.admin.database.v1.CreateDatabaseRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.CreateDatabaseRequest.class,
              com.google.spanner.admin.database.v1.CreateDatabaseRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.CreateDatabaseRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      createStatement_ = "";
      extraStatements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      databaseDialect_ = 0;
      protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateDatabaseRequest getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.CreateDatabaseRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateDatabaseRequest build() {
      com.google.spanner.admin.database.v1.CreateDatabaseRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateDatabaseRequest buildPartial() {
      com.google.spanner.admin.database.v1.CreateDatabaseRequest result =
          new com.google.spanner.admin.database.v1.CreateDatabaseRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.CreateDatabaseRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createStatement_ = createStatement_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        extraStatements_.makeImmutable();
        result.extraStatements_ = extraStatements_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.databaseDialect_ = databaseDialect_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.protoDescriptors_ = protoDescriptors_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.CreateDatabaseRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.CreateDatabaseRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.CreateDatabaseRequest other) {
      if (other == com.google.spanner.admin.database.v1.CreateDatabaseRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCreateStatement().isEmpty()) {
        createStatement_ = other.createStatement_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.extraStatements_.isEmpty()) {
        if (extraStatements_.isEmpty()) {
          extraStatements_ = other.extraStatements_;
          bitField0_ |= 0x00000004;
        } else {
          ensureExtraStatementsIsMutable();
          extraStatements_.addAll(other.extraStatements_);
        }
        onChanged();
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      if (other.databaseDialect_ != 0) {
        setDatabaseDialectValue(other.getDatabaseDialectValue());
      }
      if (other.getProtoDescriptors() != com.google.protobuf.ByteString.EMPTY) {
        setProtoDescriptors(other.getProtoDescriptors());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                createStatement_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExtraStatementsIsMutable();
                extraStatements_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                databaseDialect_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                protoDescriptors_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object createStatement_ = "";
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The createStatement.
     */
    public java.lang.String getCreateStatement() {
      java.lang.Object ref = createStatement_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        createStatement_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for createStatement.
     */
    public com.google.protobuf.ByteString getCreateStatementBytes() {
      java.lang.Object ref = createStatement_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        createStatement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The createStatement to set.
     * @return This builder for chaining.
     */
    public Builder setCreateStatement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      createStatement_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreateStatement() {
      createStatement_ = getDefaultInstance().getCreateStatement();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for createStatement to set.
     * @return This builder for chaining.
     */
    public Builder setCreateStatementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      createStatement_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList extraStatements_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExtraStatementsIsMutable() {
      if (!extraStatements_.isModifiable()) {
        extraStatements_ = new com.google.protobuf.LazyStringArrayList(extraStatements_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the extraStatements.
     */
    public com.google.protobuf.ProtocolStringList getExtraStatementsList() {
      extraStatements_.makeImmutable();
      return extraStatements_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of extraStatements.
     */
    public int getExtraStatementsCount() {
      return extraStatements_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The extraStatements at the given index.
     */
    public java.lang.String getExtraStatements(int index) {
      return extraStatements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the extraStatements at the given index.
     */
    public com.google.protobuf.ByteString getExtraStatementsBytes(int index) {
      return extraStatements_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The extraStatements to set.
     * @return This builder for chaining.
     */
    public Builder setExtraStatements(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraStatementsIsMutable();
      extraStatements_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The extraStatements to add.
     * @return This builder for chaining.
     */
    public Builder addExtraStatements(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraStatementsIsMutable();
      extraStatements_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The extraStatements to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraStatements(java.lang.Iterable<java.lang.String> values) {
      ensureExtraStatementsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extraStatements_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExtraStatements() {
      extraStatements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the extraStatements to add.
     * @return This builder for chaining.
     */
    public Builder addExtraStatementsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExtraStatementsIsMutable();
      extraStatements_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is
     * not specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionConfig,
                com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private int databaseDialect_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseDialect.
     */
    @java.lang.Override
    public int getDatabaseDialectValue() {
      return databaseDialect_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialectValue(int value) {
      databaseDialect_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The databaseDialect.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
      com.google.spanner.admin.database.v1.DatabaseDialect result =
          com.google.spanner.admin.database.v1.DatabaseDialect.forNumber(databaseDialect_);
      return result == null
          ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialect(com.google.spanner.admin.database.v1.DatabaseDialect value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      databaseDialect_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseDialect() {
      bitField0_ = (bitField0_ & ~0x00000010);
      databaseDialect_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements in
     * 'extra_statements' above.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
     *          --include_imports &#92;
     *          --descriptor_set_out=descriptors.data &#92;
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     * </pre>
     *
     * <code>bytes proto_descriptors = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The protoDescriptors.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProtoDescriptors() {
      return protoDescriptors_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements in
     * 'extra_statements' above.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
     *          --include_imports &#92;
     *          --descriptor_set_out=descriptors.data &#92;
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     * </pre>
     *
     * <code>bytes proto_descriptors = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The protoDescriptors to set.
     * @return This builder for chaining.
     */
    public Builder setProtoDescriptors(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protoDescriptors_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements in
     * 'extra_statements' above.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
     *          --include_imports &#92;
     *          --descriptor_set_out=descriptors.data &#92;
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     * </pre>
     *
     * <code>bytes proto_descriptors = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtoDescriptors() {
      bitField0_ = (bitField0_ & ~0x00000020);
      protoDescriptors_ = getDefaultInstance().getProtoDescriptors();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.CreateDatabaseRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.CreateDatabaseRequest)
  private static final com.google.spanner.admin.database.v1.CreateDatabaseRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.CreateDatabaseRequest();
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateDatabaseRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateDatabaseRequest>() {
        @java.lang.Override
        public CreateDatabaseRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateDatabaseRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateDatabaseRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.CreateDatabaseRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
