/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.enterpriseknowledgegraph.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudKnowledgeGraphEntityName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLOUD_KNOWLEDGE_GRAPH_ENTITY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cloudKnowledgeGraphEntities/{cloud_knowledge_graph_entity}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cloudKnowledgeGraphEntity;

    @Deprecated
    protected CloudKnowledgeGraphEntityName() {
        this.project = null;
        this.location = null;
        this.cloudKnowledgeGraphEntity = null;
    }

    private CloudKnowledgeGraphEntityName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudKnowledgeGraphEntity = (String)Preconditions.checkNotNull((Object)builder.getCloudKnowledgeGraphEntity());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudKnowledgeGraphEntity() {
        return this.cloudKnowledgeGraphEntity;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudKnowledgeGraphEntityName of(String project, String location, String cloudKnowledgeGraphEntity) {
        return CloudKnowledgeGraphEntityName.newBuilder().setProject(project).setLocation(location).setCloudKnowledgeGraphEntity(cloudKnowledgeGraphEntity).build();
    }

    public static String format(String project, String location, String cloudKnowledgeGraphEntity) {
        return CloudKnowledgeGraphEntityName.newBuilder().setProject(project).setLocation(location).setCloudKnowledgeGraphEntity(cloudKnowledgeGraphEntity).build().toString();
    }

    public static CloudKnowledgeGraphEntityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLOUD_KNOWLEDGE_GRAPH_ENTITY.validatedMatch(formattedString, "CloudKnowledgeGraphEntityName.parse: formattedString not in valid format");
        return CloudKnowledgeGraphEntityName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cloud_knowledge_graph_entity"));
    }

    public static List<CloudKnowledgeGraphEntityName> parseList(List<String> formattedStrings) {
        ArrayList<CloudKnowledgeGraphEntityName> list = new ArrayList<CloudKnowledgeGraphEntityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudKnowledgeGraphEntityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudKnowledgeGraphEntityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudKnowledgeGraphEntityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLOUD_KNOWLEDGE_GRAPH_ENTITY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudKnowledgeGraphEntityName cloudKnowledgeGraphEntityName = this;
            synchronized (cloudKnowledgeGraphEntityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudKnowledgeGraphEntity != null) {
                        fieldMapBuilder.put((Object)"cloud_knowledge_graph_entity", (Object)this.cloudKnowledgeGraphEntity);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLOUD_KNOWLEDGE_GRAPH_ENTITY.instantiate(new String[]{"project", this.project, "location", this.location, "cloud_knowledge_graph_entity", this.cloudKnowledgeGraphEntity});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudKnowledgeGraphEntityName that = (CloudKnowledgeGraphEntityName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudKnowledgeGraphEntity, that.cloudKnowledgeGraphEntity);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloudKnowledgeGraphEntity);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cloudKnowledgeGraphEntity;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudKnowledgeGraphEntity() {
            return this.cloudKnowledgeGraphEntity;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudKnowledgeGraphEntity(String cloudKnowledgeGraphEntity) {
            this.cloudKnowledgeGraphEntity = cloudKnowledgeGraphEntity;
            return this;
        }

        private Builder(CloudKnowledgeGraphEntityName cloudKnowledgeGraphEntityName) {
            this.project = cloudKnowledgeGraphEntityName.project;
            this.location = cloudKnowledgeGraphEntityName.location;
            this.cloudKnowledgeGraphEntity = cloudKnowledgeGraphEntityName.cloudKnowledgeGraphEntity;
        }

        public CloudKnowledgeGraphEntityName build() {
            return new CloudKnowledgeGraphEntityName(this);
        }
    }
}

