/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgecontainer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MachineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MACHINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/machines/{machine}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String machine;

    @Deprecated
    protected MachineName() {
        this.project = null;
        this.location = null;
        this.machine = null;
    }

    private MachineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.machine = (String)Preconditions.checkNotNull((Object)builder.getMachine());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMachine() {
        return this.machine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MachineName of(String project, String location, String machine) {
        return MachineName.newBuilder().setProject(project).setLocation(location).setMachine(machine).build();
    }

    public static String format(String project, String location, String machine) {
        return MachineName.newBuilder().setProject(project).setLocation(location).setMachine(machine).build().toString();
    }

    public static MachineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MACHINE.validatedMatch(formattedString, "MachineName.parse: formattedString not in valid format");
        return MachineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("machine"));
    }

    public static List<MachineName> parseList(List<String> formattedStrings) {
        ArrayList<MachineName> list = new ArrayList<MachineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MachineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MachineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MachineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MACHINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MachineName machineName = this;
            synchronized (machineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.machine != null) {
                        fieldMapBuilder.put((Object)"machine", (Object)this.machine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MACHINE.instantiate(new String[]{"project", this.project, "location", this.location, "machine", this.machine});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MachineName that = (MachineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.machine, that.machine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.machine);
    }

    public static class Builder {
        private String project;
        private String location;
        private String machine;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMachine() {
            return this.machine;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMachine(String machine) {
            this.machine = machine;
            return this;
        }

        private Builder(MachineName machineName) {
            this.project = machineName.project;
            this.location = machineName.location;
            this.machine = machineName.machine;
        }

        public MachineName build() {
            return new MachineName(this);
        }
    }
}

