/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountConnectorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ACCOUNT_CONNECTOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/accountConnectors/{account_connector}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String accountConnector;

    @Deprecated
    protected AccountConnectorName() {
        this.project = null;
        this.location = null;
        this.accountConnector = null;
    }

    private AccountConnectorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.accountConnector = (String)Preconditions.checkNotNull((Object)builder.getAccountConnector());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAccountConnector() {
        return this.accountConnector;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccountConnectorName of(String project, String location, String accountConnector) {
        return AccountConnectorName.newBuilder().setProject(project).setLocation(location).setAccountConnector(accountConnector).build();
    }

    public static String format(String project, String location, String accountConnector) {
        return AccountConnectorName.newBuilder().setProject(project).setLocation(location).setAccountConnector(accountConnector).build().toString();
    }

    public static AccountConnectorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ACCOUNT_CONNECTOR.validatedMatch(formattedString, "AccountConnectorName.parse: formattedString not in valid format");
        return AccountConnectorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("account_connector"));
    }

    public static List<AccountConnectorName> parseList(List<String> formattedStrings) {
        ArrayList<AccountConnectorName> list = new ArrayList<AccountConnectorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountConnectorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountConnectorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountConnectorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ACCOUNT_CONNECTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountConnectorName accountConnectorName = this;
            synchronized (accountConnectorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.accountConnector != null) {
                        fieldMapBuilder.put((Object)"account_connector", (Object)this.accountConnector);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ACCOUNT_CONNECTOR.instantiate(new String[]{"project", this.project, "location", this.location, "account_connector", this.accountConnector});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccountConnectorName that = (AccountConnectorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.accountConnector, that.accountConnector);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accountConnector);
    }

    public static class Builder {
        private String project;
        private String location;
        private String accountConnector;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAccountConnector() {
            return this.accountConnector;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAccountConnector(String accountConnector) {
            this.accountConnector = accountConnector;
            return this;
        }

        private Builder(AccountConnectorName accountConnectorName) {
            this.project = accountConnectorName.project;
            this.location = accountConnectorName.location;
            this.accountConnector = accountConnectorName.accountConnector;
        }

        public AccountConnectorName build() {
            return new AccountConnectorName(this);
        }
    }
}

