/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttachmentName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_CASE_ATTACHMENT_ID = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/cases/{case}/attachments/{attachment_id}");
    private static final PathTemplate PROJECT_CASE_ATTACHMENT_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/cases/{case}/attachments/{attachment_id}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String case_;
    private final String attachmentId;
    private final String project;

    @Deprecated
    protected AttachmentName() {
        this.organization = null;
        this.case_ = null;
        this.attachmentId = null;
        this.project = null;
    }

    private AttachmentName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.case_ = (String)Preconditions.checkNotNull((Object)builder.getCase());
        this.attachmentId = (String)Preconditions.checkNotNull((Object)builder.getAttachmentId());
        this.project = null;
        this.pathTemplate = ORGANIZATION_CASE_ATTACHMENT_ID;
    }

    private AttachmentName(ProjectCaseAttachmentIdBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.case_ = (String)Preconditions.checkNotNull((Object)builder.getCase());
        this.attachmentId = (String)Preconditions.checkNotNull((Object)builder.getAttachmentId());
        this.organization = null;
        this.pathTemplate = PROJECT_CASE_ATTACHMENT_ID;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCase() {
        return this.case_;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationCaseAttachmentIdBuilder() {
        return new Builder();
    }

    public static ProjectCaseAttachmentIdBuilder newProjectCaseAttachmentIdBuilder() {
        return new ProjectCaseAttachmentIdBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttachmentName of(String organization, String case_, String attachmentId) {
        return AttachmentName.newBuilder().setOrganization(organization).setCase(case_).setAttachmentId(attachmentId).build();
    }

    public static AttachmentName ofOrganizationCaseAttachmentIdName(String organization, String case_, String attachmentId) {
        return AttachmentName.newBuilder().setOrganization(organization).setCase(case_).setAttachmentId(attachmentId).build();
    }

    public static AttachmentName ofProjectCaseAttachmentIdName(String project, String case_, String attachmentId) {
        return AttachmentName.newProjectCaseAttachmentIdBuilder().setProject(project).setCase(case_).setAttachmentId(attachmentId).build();
    }

    public static String format(String organization, String case_, String attachmentId) {
        return AttachmentName.newBuilder().setOrganization(organization).setCase(case_).setAttachmentId(attachmentId).build().toString();
    }

    public static String formatOrganizationCaseAttachmentIdName(String organization, String case_, String attachmentId) {
        return AttachmentName.newBuilder().setOrganization(organization).setCase(case_).setAttachmentId(attachmentId).build().toString();
    }

    public static String formatProjectCaseAttachmentIdName(String project, String case_, String attachmentId) {
        return AttachmentName.newProjectCaseAttachmentIdBuilder().setProject(project).setCase(case_).setAttachmentId(attachmentId).build().toString();
    }

    public static AttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_CASE_ATTACHMENT_ID.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CASE_ATTACHMENT_ID.match(formattedString);
            return AttachmentName.ofOrganizationCaseAttachmentIdName((String)matchMap.get("organization"), (String)matchMap.get("case"), (String)matchMap.get("attachment_id"));
        }
        if (PROJECT_CASE_ATTACHMENT_ID.matches(formattedString)) {
            Map matchMap = PROJECT_CASE_ATTACHMENT_ID.match(formattedString);
            return AttachmentName.ofProjectCaseAttachmentIdName((String)matchMap.get("project"), (String)matchMap.get("case"), (String)matchMap.get("attachment_id"));
        }
        throw new ValidationException("AttachmentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<AttachmentName> list = new ArrayList<AttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_CASE_ATTACHMENT_ID.matches(formattedString) || PROJECT_CASE_ATTACHMENT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttachmentName attachmentName = this;
            synchronized (attachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.case_ != null) {
                        fieldMapBuilder.put((Object)"case", (Object)this.case_);
                    }
                    if (this.attachmentId != null) {
                        fieldMapBuilder.put((Object)"attachment_id", (Object)this.attachmentId);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttachmentName that = (AttachmentName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.case_, that.case_) && Objects.equals(this.attachmentId, that.attachmentId) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.case_);
        h *= 1000003;
        h ^= Objects.hashCode(this.attachmentId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectCaseAttachmentIdBuilder {
        private String project;
        private String case_;
        private String attachmentId;

        protected ProjectCaseAttachmentIdBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getCase() {
            return this.case_;
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }

        public ProjectCaseAttachmentIdBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectCaseAttachmentIdBuilder setCase(String case_) {
            this.case_ = case_;
            return this;
        }

        public ProjectCaseAttachmentIdBuilder setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public AttachmentName build() {
            return new AttachmentName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String case_;
        private String attachmentId;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getCase() {
            return this.case_;
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setCase(String case_) {
            this.case_ = case_;
            return this;
        }

        public Builder setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        private Builder(AttachmentName attachmentName) {
            Preconditions.checkArgument((boolean)Objects.equals(attachmentName.pathTemplate, ORGANIZATION_CASE_ATTACHMENT_ID), (Object)"toBuilder is only supported when AttachmentName has the pattern of organizations/{organization}/cases/{case}/attachments/{attachment_id}");
            this.organization = attachmentName.organization;
            this.case_ = attachmentName.case_;
            this.attachmentId = attachmentName.attachmentId;
        }

        public AttachmentName build() {
            return new AttachmentName(this);
        }
    }
}

