/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CommentName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_CASE_COMMENT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/cases/{case}/comments/{comment}");
    private static final PathTemplate PROJECT_CASE_COMMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/cases/{case}/comments/{comment}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String case_;
    private final String comment;
    private final String project;

    @Deprecated
    protected CommentName() {
        this.organization = null;
        this.case_ = null;
        this.comment = null;
        this.project = null;
    }

    private CommentName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.case_ = (String)Preconditions.checkNotNull((Object)builder.getCase());
        this.comment = (String)Preconditions.checkNotNull((Object)builder.getComment());
        this.project = null;
        this.pathTemplate = ORGANIZATION_CASE_COMMENT;
    }

    private CommentName(ProjectCaseCommentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.case_ = (String)Preconditions.checkNotNull((Object)builder.getCase());
        this.comment = (String)Preconditions.checkNotNull((Object)builder.getComment());
        this.organization = null;
        this.pathTemplate = PROJECT_CASE_COMMENT;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCase() {
        return this.case_;
    }

    public String getComment() {
        return this.comment;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationCaseCommentBuilder() {
        return new Builder();
    }

    public static ProjectCaseCommentBuilder newProjectCaseCommentBuilder() {
        return new ProjectCaseCommentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CommentName of(String organization, String case_, String comment) {
        return CommentName.newBuilder().setOrganization(organization).setCase(case_).setComment(comment).build();
    }

    public static CommentName ofOrganizationCaseCommentName(String organization, String case_, String comment) {
        return CommentName.newBuilder().setOrganization(organization).setCase(case_).setComment(comment).build();
    }

    public static CommentName ofProjectCaseCommentName(String project, String case_, String comment) {
        return CommentName.newProjectCaseCommentBuilder().setProject(project).setCase(case_).setComment(comment).build();
    }

    public static String format(String organization, String case_, String comment) {
        return CommentName.newBuilder().setOrganization(organization).setCase(case_).setComment(comment).build().toString();
    }

    public static String formatOrganizationCaseCommentName(String organization, String case_, String comment) {
        return CommentName.newBuilder().setOrganization(organization).setCase(case_).setComment(comment).build().toString();
    }

    public static String formatProjectCaseCommentName(String project, String case_, String comment) {
        return CommentName.newProjectCaseCommentBuilder().setProject(project).setCase(case_).setComment(comment).build().toString();
    }

    public static CommentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_CASE_COMMENT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CASE_COMMENT.match(formattedString);
            return CommentName.ofOrganizationCaseCommentName((String)matchMap.get("organization"), (String)matchMap.get("case"), (String)matchMap.get("comment"));
        }
        if (PROJECT_CASE_COMMENT.matches(formattedString)) {
            Map matchMap = PROJECT_CASE_COMMENT.match(formattedString);
            return CommentName.ofProjectCaseCommentName((String)matchMap.get("project"), (String)matchMap.get("case"), (String)matchMap.get("comment"));
        }
        throw new ValidationException("CommentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CommentName> parseList(List<String> formattedStrings) {
        ArrayList<CommentName> list = new ArrayList<CommentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CommentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CommentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CommentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_CASE_COMMENT.matches(formattedString) || PROJECT_CASE_COMMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CommentName commentName = this;
            synchronized (commentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.case_ != null) {
                        fieldMapBuilder.put((Object)"case", (Object)this.case_);
                    }
                    if (this.comment != null) {
                        fieldMapBuilder.put((Object)"comment", (Object)this.comment);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CommentName that = (CommentName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.case_, that.case_) && Objects.equals(this.comment, that.comment) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.case_);
        h *= 1000003;
        h ^= Objects.hashCode(this.comment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectCaseCommentBuilder {
        private String project;
        private String case_;
        private String comment;

        protected ProjectCaseCommentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getCase() {
            return this.case_;
        }

        public String getComment() {
            return this.comment;
        }

        public ProjectCaseCommentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectCaseCommentBuilder setCase(String case_) {
            this.case_ = case_;
            return this;
        }

        public ProjectCaseCommentBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public CommentName build() {
            return new CommentName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String case_;
        private String comment;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getCase() {
            return this.case_;
        }

        public String getComment() {
            return this.comment;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setCase(String case_) {
            this.case_ = case_;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        private Builder(CommentName commentName) {
            Preconditions.checkArgument((boolean)Objects.equals(commentName.pathTemplate, ORGANIZATION_CASE_COMMENT), (Object)"toBuilder is only supported when CommentName has the pattern of organizations/{organization}/cases/{case}/comments/{comment}");
            this.organization = commentName.organization;
            this.case_ = commentName.case_;
            this.comment = commentName.comment;
        }

        public CommentName build() {
            return new CommentName(this);
        }
    }
}

