/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CaseName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_CASE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/cases/{case}");
    private static final PathTemplate PROJECT_CASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/cases/{case}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String case_;
    private final String project;

    @Deprecated
    protected CaseName() {
        this.organization = null;
        this.case_ = null;
        this.project = null;
    }

    private CaseName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.case_ = (String)Preconditions.checkNotNull((Object)builder.getCase());
        this.project = null;
        this.pathTemplate = ORGANIZATION_CASE;
    }

    private CaseName(ProjectCaseBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.case_ = (String)Preconditions.checkNotNull((Object)builder.getCase());
        this.organization = null;
        this.pathTemplate = PROJECT_CASE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCase() {
        return this.case_;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationCaseBuilder() {
        return new Builder();
    }

    public static ProjectCaseBuilder newProjectCaseBuilder() {
        return new ProjectCaseBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CaseName of(String organization, String case_) {
        return CaseName.newBuilder().setOrganization(organization).setCase(case_).build();
    }

    public static CaseName ofOrganizationCaseName(String organization, String case_) {
        return CaseName.newBuilder().setOrganization(organization).setCase(case_).build();
    }

    public static CaseName ofProjectCaseName(String project, String case_) {
        return CaseName.newProjectCaseBuilder().setProject(project).setCase(case_).build();
    }

    public static String format(String organization, String case_) {
        return CaseName.newBuilder().setOrganization(organization).setCase(case_).build().toString();
    }

    public static String formatOrganizationCaseName(String organization, String case_) {
        return CaseName.newBuilder().setOrganization(organization).setCase(case_).build().toString();
    }

    public static String formatProjectCaseName(String project, String case_) {
        return CaseName.newProjectCaseBuilder().setProject(project).setCase(case_).build().toString();
    }

    public static CaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_CASE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CASE.match(formattedString);
            return CaseName.ofOrganizationCaseName((String)matchMap.get("organization"), (String)matchMap.get("case"));
        }
        if (PROJECT_CASE.matches(formattedString)) {
            Map matchMap = PROJECT_CASE.match(formattedString);
            return CaseName.ofProjectCaseName((String)matchMap.get("project"), (String)matchMap.get("case"));
        }
        throw new ValidationException("CaseName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CaseName> parseList(List<String> formattedStrings) {
        ArrayList<CaseName> list = new ArrayList<CaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_CASE.matches(formattedString) || PROJECT_CASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CaseName caseName = this;
            synchronized (caseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.case_ != null) {
                        fieldMapBuilder.put((Object)"case", (Object)this.case_);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CaseName that = (CaseName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.case_, that.case_) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.case_);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectCaseBuilder {
        private String project;
        private String case_;

        protected ProjectCaseBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getCase() {
            return this.case_;
        }

        public ProjectCaseBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectCaseBuilder setCase(String case_) {
            this.case_ = case_;
            return this;
        }

        public CaseName build() {
            return new CaseName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String case_;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getCase() {
            return this.case_;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setCase(String case_) {
            this.case_ = case_;
            return this;
        }

        private Builder(CaseName caseName) {
            Preconditions.checkArgument((boolean)Objects.equals(caseName.pathTemplate, ORGANIZATION_CASE), (Object)"toBuilder is only supported when CaseName has the pattern of organizations/{organization}/cases/{case}");
            this.organization = caseName.organization;
            this.case_ = caseName.case_;
        }

        public CaseName build() {
            return new CaseName(this);
        }
    }
}

