/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.bigtable.admin.v2;

public interface CopyBackupRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.CopyBackupRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the destination cluster that will contain the backup
   * copy. The cluster must already exist. Values are of the form:
   * `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The name of the destination cluster that will contain the backup
   * copy. The cluster must already exist. Values are of the form:
   * `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The id of the new backup. The `backup_id` along with `parent`
   * are combined as {parent}/backups/{backup_id} to create the full backup
   * name, of the form:
   * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
   * This string must be between 1 and 50 characters in length and match the
   * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
   * </pre>
   *
   * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The backupId.
   */
  java.lang.String getBackupId();
  /**
   *
   *
   * <pre>
   * Required. The id of the new backup. The `backup_id` along with `parent`
   * are combined as {parent}/backups/{backup_id} to create the full backup
   * name, of the form:
   * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
   * This string must be between 1 and 50 characters in length and match the
   * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
   * </pre>
   *
   * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for backupId.
   */
  com.google.protobuf.ByteString getBackupIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The source backup to be copied from.
   * The source backup needs to be in READY state for it to be copied.
   * Copying a copied backup is not allowed.
   * Once CopyBackup is in progress, the source backup cannot be deleted or
   * cleaned up on expiration until CopyBackup is finished.
   * Values are of the form:
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/&lt;cluster&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>
   * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The sourceBackup.
   */
  java.lang.String getSourceBackup();
  /**
   *
   *
   * <pre>
   * Required. The source backup to be copied from.
   * The source backup needs to be in READY state for it to be copied.
   * Copying a copied backup is not allowed.
   * Once CopyBackup is in progress, the source backup cannot be deleted or
   * cleaned up on expiration until CopyBackup is finished.
   * Values are of the form:
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/&lt;cluster&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>
   * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for sourceBackup.
   */
  com.google.protobuf.ByteString getSourceBackupBytes();

  /**
   *
   *
   * <pre>
   * Required. Required. The expiration time of the copied backup with
   * microsecond granularity that must be at least 6 hours and at most 30 days
   * from the time the request is received. Once the `expire_time` has
   * passed, Cloud Bigtable will delete the backup and free the resources used
   * by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Required. Required. The expiration time of the copied backup with
   * microsecond granularity that must be at least 6 hours and at most 30 days
   * from the time the request is received. Once the `expire_time` has
   * passed, Cloud Bigtable will delete the backup and free the resources used
   * by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Required. Required. The expiration time of the copied backup with
   * microsecond granularity that must be at least 6 hours and at most 30 days
   * from the time the request is received. Once the `expire_time` has
   * passed, Cloud Bigtable will delete the backup and free the resources used
   * by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();
}
