/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Request message for BigtableInstanceAdmin.CreateInstance.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.CreateInstanceRequest}
 */
public final class CreateInstanceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.CreateInstanceRequest)
    CreateInstanceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateInstanceRequest.newBuilder() to construct.
  private CreateInstanceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateInstanceRequest() {
    parent_ = "";
    instanceId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateInstanceRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
        .internal_static_google_bigtable_admin_v2_CreateInstanceRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetClusters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
        .internal_static_google_bigtable_admin_v2_CreateInstanceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.CreateInstanceRequest.class,
            com.google.bigtable.admin.v2.CreateInstanceRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique name of the project in which to create the new instance.
   * Values are of the form `projects/{project}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the project in which to create the new instance.
   * Values are of the form `projects/{project}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID to be used when referring to the new instance within its project,
   * e.g., just `myinstance` rather than
   * `projects/myproject/instances/myinstance`.
   * </pre>
   *
   * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The instanceId.
   */
  @java.lang.Override
  public java.lang.String getInstanceId() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID to be used when referring to the new instance within its project,
   * e.g., just `myinstance` rather than
   * `projects/myproject/instances/myinstance`.
   * </pre>
   *
   * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for instanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceIdBytes() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 3;
  private com.google.bigtable.admin.v2.Instance instance_;
  /**
   *
   *
   * <pre>
   * Required. The instance to create.
   * Fields marked `OutputOnly` must be left blank.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return instance_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The instance to create.
   * Fields marked `OutputOnly` must be left blank.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Instance getInstance() {
    return instance_ == null
        ? com.google.bigtable.admin.v2.Instance.getDefaultInstance()
        : instance_;
  }
  /**
   *
   *
   * <pre>
   * Required. The instance to create.
   * Fields marked `OutputOnly` must be left blank.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.InstanceOrBuilder getInstanceOrBuilder() {
    return instance_ == null
        ? com.google.bigtable.admin.v2.Instance.getDefaultInstance()
        : instance_;
  }

  public static final int CLUSTERS_FIELD_NUMBER = 4;

  private static final class ClustersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.bigtable.admin.v2.Cluster>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.bigtable.admin.v2.Cluster>newDefaultInstance(
                    com.google.bigtable.admin.v2.BigtableInstanceAdminProto
                        .internal_static_google_bigtable_admin_v2_CreateInstanceRequest_ClustersEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.bigtable.admin.v2.Cluster.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.Cluster>
      clusters_;

  private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.Cluster>
      internalGetClusters() {
    if (clusters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ClustersDefaultEntryHolder.defaultEntry);
    }
    return clusters_;
  }

  public int getClustersCount() {
    return internalGetClusters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. The clusters to be created within the instance, mapped by desired
   * cluster ID, e.g., just `mycluster` rather than
   * `projects/myproject/instances/myinstance/clusters/mycluster`.
   * Fields marked `OutputOnly` must be left blank.
   * Currently, at most four clusters can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public boolean containsClusters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetClusters().getMap().containsKey(key);
  }
  /** Use {@link #getClustersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> getClusters() {
    return getClustersMap();
  }
  /**
   *
   *
   * <pre>
   * Required. The clusters to be created within the instance, mapped by desired
   * cluster ID, e.g., just `mycluster` rather than
   * `projects/myproject/instances/myinstance/clusters/mycluster`.
   * Fields marked `OutputOnly` must be left blank.
   * Currently, at most four clusters can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> getClustersMap() {
    return internalGetClusters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. The clusters to be created within the instance, mapped by desired
   * cluster ID, e.g., just `mycluster` rather than
   * `projects/myproject/instances/myinstance/clusters/mycluster`.
   * Fields marked `OutputOnly` must be left blank.
   * Currently, at most four clusters can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.bigtable.admin.v2.Cluster getClustersOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.bigtable.admin.v2.Cluster defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> map =
        internalGetClusters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. The clusters to be created within the instance, mapped by desired
   * cluster ID, e.g., just `mycluster` rather than
   * `projects/myproject/instances/myinstance/clusters/mycluster`.
   * Fields marked `OutputOnly` must be left blank.
   * Currently, at most four clusters can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster getClustersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> map =
        internalGetClusters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceId_);
    }
    if (instance_ != null) {
      output.writeMessage(3, getInstance());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetClusters(), ClustersDefaultEntryHolder.defaultEntry, 4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instanceId_);
    }
    if (instance_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInstance());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.bigtable.admin.v2.Cluster> entry :
        internalGetClusters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.admin.v2.Cluster>
          clusters__ =
              ClustersDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, clusters__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.CreateInstanceRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.CreateInstanceRequest other =
        (com.google.bigtable.admin.v2.CreateInstanceRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getInstanceId().equals(other.getInstanceId())) return false;
    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (!internalGetClusters().equals(other.internalGetClusters())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceId().hashCode();
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    if (!internalGetClusters().getMap().isEmpty()) {
      hash = (37 * hash) + CLUSTERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetClusters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.CreateInstanceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for BigtableInstanceAdmin.CreateInstance.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.CreateInstanceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.CreateInstanceRequest)
      com.google.bigtable.admin.v2.CreateInstanceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateInstanceRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetClusters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableClusters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateInstanceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.CreateInstanceRequest.class,
              com.google.bigtable.admin.v2.CreateInstanceRequest.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      instanceId_ = "";
      instance_ = null;
      if (instanceBuilder_ != null) {
        instanceBuilder_.dispose();
        instanceBuilder_ = null;
      }
      internalGetMutableClusters().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateInstanceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateInstanceRequest getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.CreateInstanceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateInstanceRequest build() {
      com.google.bigtable.admin.v2.CreateInstanceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateInstanceRequest buildPartial() {
      com.google.bigtable.admin.v2.CreateInstanceRequest result =
          new com.google.bigtable.admin.v2.CreateInstanceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.CreateInstanceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceId_ = instanceId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.instance_ = instanceBuilder_ == null ? instance_ : instanceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.clusters_ = internalGetClusters();
        result.clusters_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.CreateInstanceRequest) {
        return mergeFrom((com.google.bigtable.admin.v2.CreateInstanceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.CreateInstanceRequest other) {
      if (other == com.google.bigtable.admin.v2.CreateInstanceRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInstanceId().isEmpty()) {
        instanceId_ = other.instanceId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInstance()) {
        mergeInstance(other.getInstance());
      }
      internalGetMutableClusters().mergeFrom(other.internalGetClusters());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                instanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInstanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.admin.v2.Cluster>
                    clusters__ =
                        input.readMessage(
                            ClustersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableClusters()
                    .getMutableMap()
                    .put(clusters__.getKey(), clusters__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the project in which to create the new instance.
     * Values are of the form `projects/{project}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the project in which to create the new instance.
     * Values are of the form `projects/{project}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the project in which to create the new instance.
     * Values are of the form `projects/{project}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the project in which to create the new instance.
     * Values are of the form `projects/{project}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the project in which to create the new instance.
     * Values are of the form `projects/{project}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instanceId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID to be used when referring to the new instance within its project,
     * e.g., just `myinstance` rather than
     * `projects/myproject/instances/myinstance`.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instanceId.
     */
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to be used when referring to the new instance within its project,
     * e.g., just `myinstance` rather than
     * `projects/myproject/instances/myinstance`.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instanceId.
     */
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to be used when referring to the new instance within its project,
     * e.g., just `myinstance` rather than
     * `projects/myproject/instances/myinstance`.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to be used when referring to the new instance within its project,
     * e.g., just `myinstance` rather than
     * `projects/myproject/instances/myinstance`.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceId() {
      instanceId_ = getDefaultInstance().getInstanceId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to be used when referring to the new instance within its project,
     * e.g., just `myinstance` rather than
     * `projects/myproject/instances/myinstance`.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.bigtable.admin.v2.Instance instance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Instance,
            com.google.bigtable.admin.v2.Instance.Builder,
            com.google.bigtable.admin.v2.InstanceOrBuilder>
        instanceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instance field is set.
     */
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instance.
     */
    public com.google.bigtable.admin.v2.Instance getInstance() {
      if (instanceBuilder_ == null) {
        return instance_ == null
            ? com.google.bigtable.admin.v2.Instance.getDefaultInstance()
            : instance_;
      } else {
        return instanceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstance(com.google.bigtable.admin.v2.Instance value) {
      if (instanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instance_ = value;
      } else {
        instanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstance(com.google.bigtable.admin.v2.Instance.Builder builderForValue) {
      if (instanceBuilder_ == null) {
        instance_ = builderForValue.build();
      } else {
        instanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInstance(com.google.bigtable.admin.v2.Instance value) {
      if (instanceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && instance_ != null
            && instance_ != com.google.bigtable.admin.v2.Instance.getDefaultInstance()) {
          getInstanceBuilder().mergeFrom(value);
        } else {
          instance_ = value;
        }
      } else {
        instanceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInstance() {
      bitField0_ = (bitField0_ & ~0x00000004);
      instance_ = null;
      if (instanceBuilder_ != null) {
        instanceBuilder_.dispose();
        instanceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.Instance.Builder getInstanceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.InstanceOrBuilder getInstanceOrBuilder() {
      if (instanceBuilder_ != null) {
        return instanceBuilder_.getMessageOrBuilder();
      } else {
        return instance_ == null
            ? com.google.bigtable.admin.v2.Instance.getDefaultInstance()
            : instance_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instance to create.
     * Fields marked `OutputOnly` must be left blank.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Instance,
            com.google.bigtable.admin.v2.Instance.Builder,
            com.google.bigtable.admin.v2.InstanceOrBuilder>
        getInstanceFieldBuilder() {
      if (instanceBuilder_ == null) {
        instanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Instance,
                com.google.bigtable.admin.v2.Instance.Builder,
                com.google.bigtable.admin.v2.InstanceOrBuilder>(
                getInstance(), getParentForChildren(), isClean());
        instance_ = null;
      }
      return instanceBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.Cluster>
        clusters_;

    private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.Cluster>
        internalGetClusters() {
      if (clusters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ClustersDefaultEntryHolder.defaultEntry);
      }
      return clusters_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.Cluster>
        internalGetMutableClusters() {
      if (clusters_ == null) {
        clusters_ =
            com.google.protobuf.MapField.newMapField(ClustersDefaultEntryHolder.defaultEntry);
      }
      if (!clusters_.isMutable()) {
        clusters_ = clusters_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return clusters_;
    }

    public int getClustersCount() {
      return internalGetClusters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public boolean containsClusters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetClusters().getMap().containsKey(key);
    }
    /** Use {@link #getClustersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> getClusters() {
      return getClustersMap();
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> getClustersMap() {
      return internalGetClusters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.bigtable.admin.v2.Cluster getClustersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.bigtable.admin.v2.Cluster defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> map =
          internalGetClusters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster getClustersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> map =
          internalGetClusters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearClusters() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableClusters().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeClusters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableClusters().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster>
        getMutableClusters() {
      bitField0_ |= 0x00000008;
      return internalGetMutableClusters().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putClusters(java.lang.String key, com.google.bigtable.admin.v2.Cluster value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableClusters().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The clusters to be created within the instance, mapped by desired
     * cluster ID, e.g., just `mycluster` rather than
     * `projects/myproject/instances/myinstance/clusters/mycluster`.
     * Fields marked `OutputOnly` must be left blank.
     * Currently, at most four clusters can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Cluster&gt; clusters = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllClusters(
        java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Cluster> values) {
      internalGetMutableClusters().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.CreateInstanceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.CreateInstanceRequest)
  private static final com.google.bigtable.admin.v2.CreateInstanceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.CreateInstanceRequest();
  }

  public static com.google.bigtable.admin.v2.CreateInstanceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateInstanceRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateInstanceRequest>() {
        @java.lang.Override
        public CreateInstanceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateInstanceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateInstanceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.CreateInstanceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
