/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_JOB_TASK_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/jobs/{job}/taskGroups/{task_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String job;
    private final String taskGroup;

    @Deprecated
    protected TaskGroupName() {
        this.project = null;
        this.location = null;
        this.job = null;
        this.taskGroup = null;
    }

    private TaskGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
        this.taskGroup = (String)Preconditions.checkNotNull((Object)builder.getTaskGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getJob() {
        return this.job;
    }

    public String getTaskGroup() {
        return this.taskGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TaskGroupName of(String project, String location, String job, String taskGroup) {
        return TaskGroupName.newBuilder().setProject(project).setLocation(location).setJob(job).setTaskGroup(taskGroup).build();
    }

    public static String format(String project, String location, String job, String taskGroup) {
        return TaskGroupName.newBuilder().setProject(project).setLocation(location).setJob(job).setTaskGroup(taskGroup).build().toString();
    }

    public static TaskGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_JOB_TASK_GROUP.validatedMatch(formattedString, "TaskGroupName.parse: formattedString not in valid format");
        return TaskGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("job"), (String)matchMap.get("task_group"));
    }

    public static List<TaskGroupName> parseList(List<String> formattedStrings) {
        ArrayList<TaskGroupName> list = new ArrayList<TaskGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaskGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaskGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaskGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_JOB_TASK_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaskGroupName taskGroupName = this;
            synchronized (taskGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    if (this.taskGroup != null) {
                        fieldMapBuilder.put((Object)"task_group", (Object)this.taskGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_JOB_TASK_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "job", this.job, "task_group", this.taskGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TaskGroupName that = (TaskGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.job, that.job) && Objects.equals(this.taskGroup, that.taskGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.job);
        h *= 1000003;
        return h ^= Objects.hashCode(this.taskGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String job;
        private String taskGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getJob() {
            return this.job;
        }

        public String getTaskGroup() {
            return this.taskGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        public Builder setTaskGroup(String taskGroup) {
            this.taskGroup = taskGroup;
            return this;
        }

        private Builder(TaskGroupName taskGroupName) {
            this.project = taskGroupName.project;
            this.location = taskGroupName.location;
            this.job = taskGroupName.job;
            this.taskGroup = taskGroupName.taskGroup;
        }

        public TaskGroupName build() {
            return new TaskGroupName(this);
        }
    }
}

