/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_API_API_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/apis/{api}/configs/{api_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String api;
    private final String apiConfig;

    @Deprecated
    protected ApiConfigName() {
        this.project = null;
        this.api = null;
        this.apiConfig = null;
    }

    private ApiConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.apiConfig = (String)Preconditions.checkNotNull((Object)builder.getApiConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getApi() {
        return this.api;
    }

    public String getApiConfig() {
        return this.apiConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApiConfigName of(String project, String api, String apiConfig) {
        return ApiConfigName.newBuilder().setProject(project).setApi(api).setApiConfig(apiConfig).build();
    }

    public static String format(String project, String api, String apiConfig) {
        return ApiConfigName.newBuilder().setProject(project).setApi(api).setApiConfig(apiConfig).build().toString();
    }

    public static ApiConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_API_API_CONFIG.validatedMatch(formattedString, "ApiConfigName.parse: formattedString not in valid format");
        return ApiConfigName.of((String)matchMap.get("project"), (String)matchMap.get("api"), (String)matchMap.get("api_config"));
    }

    public static List<ApiConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ApiConfigName> list = new ArrayList<ApiConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApiConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApiConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApiConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_API_API_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApiConfigName apiConfigName = this;
            synchronized (apiConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.api != null) {
                        fieldMapBuilder.put((Object)"api", (Object)this.api);
                    }
                    if (this.apiConfig != null) {
                        fieldMapBuilder.put((Object)"api_config", (Object)this.apiConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_API_API_CONFIG.instantiate(new String[]{"project", this.project, "api", this.api, "api_config", this.apiConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ApiConfigName that = (ApiConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.api, that.api) && Objects.equals(this.apiConfig, that.apiConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.api);
        h *= 1000003;
        return h ^= Objects.hashCode(this.apiConfig);
    }

    public static class Builder {
        private String project;
        private String api;
        private String apiConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getApi() {
            return this.api;
        }

        public String getApiConfig() {
            return this.apiConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setApi(String api) {
            this.api = api;
            return this;
        }

        public Builder setApiConfig(String apiConfig) {
            this.apiConfig = apiConfig;
            return this;
        }

        private Builder(ApiConfigName apiConfigName) {
            this.project = apiConfigName.project;
            this.api = apiConfigName.api;
            this.apiConfig = apiConfigName.apiConfig;
        }

        public ApiConfigName build() {
            return new ApiConfigName(this);
        }
    }
}

