/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiName
implements ResourceName {
    private static final PathTemplate PROJECT_API = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/apis/{api}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String api;

    @Deprecated
    protected ApiName() {
        this.project = null;
        this.api = null;
    }

    private ApiName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
    }

    public String getProject() {
        return this.project;
    }

    public String getApi() {
        return this.api;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApiName of(String project, String api) {
        return ApiName.newBuilder().setProject(project).setApi(api).build();
    }

    public static String format(String project, String api) {
        return ApiName.newBuilder().setProject(project).setApi(api).build().toString();
    }

    public static ApiName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_API.validatedMatch(formattedString, "ApiName.parse: formattedString not in valid format");
        return ApiName.of((String)matchMap.get("project"), (String)matchMap.get("api"));
    }

    public static List<ApiName> parseList(List<String> formattedStrings) {
        ArrayList<ApiName> list = new ArrayList<ApiName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApiName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApiName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApiName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_API.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApiName apiName = this;
            synchronized (apiName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.api != null) {
                        fieldMapBuilder.put((Object)"api", (Object)this.api);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_API.instantiate(new String[]{"project", this.project, "api", this.api});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ApiName that = (ApiName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.api, that.api);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.api);
    }

    public static class Builder {
        private String project;
        private String api;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getApi() {
            return this.api;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setApi(String api) {
            this.api = api;
            return this;
        }

        private Builder(ApiName apiName) {
            this.project = apiName.project;
            this.api = apiName.api;
        }

        public ApiName build() {
            return new ApiName(this);
        }
    }
}

