/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/data.proto

package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * Defines a cohort selection criteria. A cohort is a group of users who share
 * a common characteristic. For example, users with the same `firstSessionDate`
 * belong to the same cohort.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.Cohort}
 */
public final class Cohort extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.Cohort)
    CohortOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cohort.newBuilder() to construct.
  private Cohort(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cohort() {
    name_ = "";
    dimension_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cohort();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_Cohort_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_Cohort_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.Cohort.class,
            com.google.analytics.data.v1beta.Cohort.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Assigns a name to this cohort. The dimension `cohort` is valued to this
   * name in a report response. If set, cannot begin with `cohort_` or
   * `RESERVED_`. If not set, cohorts are named by their zero based index
   * `cohort_0`, `cohort_1`, etc.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Assigns a name to this cohort. The dimension `cohort` is valued to this
   * name in a report response. If set, cannot begin with `cohort_` or
   * `RESERVED_`. If not set, cohorts are named by their zero based index
   * `cohort_0`, `cohort_1`, etc.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dimension_ = "";
  /**
   *
   *
   * <pre>
   * Dimension used by the cohort. Required and only supports
   * `firstSessionDate`.
   * </pre>
   *
   * <code>string dimension = 2;</code>
   *
   * @return The dimension.
   */
  @java.lang.Override
  public java.lang.String getDimension() {
    java.lang.Object ref = dimension_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dimension_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Dimension used by the cohort. Required and only supports
   * `firstSessionDate`.
   * </pre>
   *
   * <code>string dimension = 2;</code>
   *
   * @return The bytes for dimension.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDimensionBytes() {
    java.lang.Object ref = dimension_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dimension_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATE_RANGE_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1beta.DateRange dateRange_;
  /**
   *
   *
   * <pre>
   * The cohort selects users whose first touch date is between start date and
   * end date defined in the `dateRange`. This `dateRange` does not specify the
   * full date range of event data that is present in a cohort report. In a
   * cohort report, this `dateRange` is extended by the granularity and offset
   * present in the `cohortsRange`; event data for the extended reporting date
   * range is present in a cohort report.
   *
   * In a cohort request, this `dateRange` is required and the `dateRanges` in
   * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
   *
   * This `dateRange` should generally be aligned with the cohort's granularity.
   * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
   * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
   * aligned to a week boundary, starting at Sunday and ending Saturday. If
   * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
   * a month, starting at the first and ending on the last day of the month.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
   *
   * @return Whether the dateRange field is set.
   */
  @java.lang.Override
  public boolean hasDateRange() {
    return dateRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * The cohort selects users whose first touch date is between start date and
   * end date defined in the `dateRange`. This `dateRange` does not specify the
   * full date range of event data that is present in a cohort report. In a
   * cohort report, this `dateRange` is extended by the granularity and offset
   * present in the `cohortsRange`; event data for the extended reporting date
   * range is present in a cohort report.
   *
   * In a cohort request, this `dateRange` is required and the `dateRanges` in
   * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
   *
   * This `dateRange` should generally be aligned with the cohort's granularity.
   * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
   * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
   * aligned to a week boundary, starting at Sunday and ending Saturday. If
   * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
   * a month, starting at the first and ending on the last day of the month.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
   *
   * @return The dateRange.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.DateRange getDateRange() {
    return dateRange_ == null
        ? com.google.analytics.data.v1beta.DateRange.getDefaultInstance()
        : dateRange_;
  }
  /**
   *
   *
   * <pre>
   * The cohort selects users whose first touch date is between start date and
   * end date defined in the `dateRange`. This `dateRange` does not specify the
   * full date range of event data that is present in a cohort report. In a
   * cohort report, this `dateRange` is extended by the granularity and offset
   * present in the `cohortsRange`; event data for the extended reporting date
   * range is present in a cohort report.
   *
   * In a cohort request, this `dateRange` is required and the `dateRanges` in
   * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
   *
   * This `dateRange` should generally be aligned with the cohort's granularity.
   * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
   * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
   * aligned to a week boundary, starting at Sunday and ending Saturday. If
   * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
   * a month, starting at the first and ending on the last day of the month.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.DateRangeOrBuilder getDateRangeOrBuilder() {
    return dateRange_ == null
        ? com.google.analytics.data.v1beta.DateRange.getDefaultInstance()
        : dateRange_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dimension_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dimension_);
    }
    if (dateRange_ != null) {
      output.writeMessage(3, getDateRange());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dimension_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dimension_);
    }
    if (dateRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDateRange());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.Cohort)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.Cohort other = (com.google.analytics.data.v1beta.Cohort) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDimension().equals(other.getDimension())) return false;
    if (hasDateRange() != other.hasDateRange()) return false;
    if (hasDateRange()) {
      if (!getDateRange().equals(other.getDateRange())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DIMENSION_FIELD_NUMBER;
    hash = (53 * hash) + getDimension().hashCode();
    if (hasDateRange()) {
      hash = (37 * hash) + DATE_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getDateRange().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Cohort parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.Cohort parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.Cohort parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1beta.Cohort prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a cohort selection criteria. A cohort is a group of users who share
   * a common characteristic. For example, users with the same `firstSessionDate`
   * belong to the same cohort.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.Cohort}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.Cohort)
      com.google.analytics.data.v1beta.CohortOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_Cohort_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_Cohort_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.Cohort.class,
              com.google.analytics.data.v1beta.Cohort.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.Cohort.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      dimension_ = "";
      dateRange_ = null;
      if (dateRangeBuilder_ != null) {
        dateRangeBuilder_.dispose();
        dateRangeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_Cohort_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.Cohort getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.Cohort.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.Cohort build() {
      com.google.analytics.data.v1beta.Cohort result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.Cohort buildPartial() {
      com.google.analytics.data.v1beta.Cohort result =
          new com.google.analytics.data.v1beta.Cohort(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1beta.Cohort result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dimension_ = dimension_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dateRange_ = dateRangeBuilder_ == null ? dateRange_ : dateRangeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.Cohort) {
        return mergeFrom((com.google.analytics.data.v1beta.Cohort) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.Cohort other) {
      if (other == com.google.analytics.data.v1beta.Cohort.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDimension().isEmpty()) {
        dimension_ = other.dimension_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDateRange()) {
        mergeDateRange(other.getDateRange());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dimension_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDateRangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Assigns a name to this cohort. The dimension `cohort` is valued to this
     * name in a report response. If set, cannot begin with `cohort_` or
     * `RESERVED_`. If not set, cohorts are named by their zero based index
     * `cohort_0`, `cohort_1`, etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Assigns a name to this cohort. The dimension `cohort` is valued to this
     * name in a report response. If set, cannot begin with `cohort_` or
     * `RESERVED_`. If not set, cohorts are named by their zero based index
     * `cohort_0`, `cohort_1`, etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Assigns a name to this cohort. The dimension `cohort` is valued to this
     * name in a report response. If set, cannot begin with `cohort_` or
     * `RESERVED_`. If not set, cohorts are named by their zero based index
     * `cohort_0`, `cohort_1`, etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assigns a name to this cohort. The dimension `cohort` is valued to this
     * name in a report response. If set, cannot begin with `cohort_` or
     * `RESERVED_`. If not set, cohorts are named by their zero based index
     * `cohort_0`, `cohort_1`, etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assigns a name to this cohort. The dimension `cohort` is valued to this
     * name in a report response. If set, cannot begin with `cohort_` or
     * `RESERVED_`. If not set, cohorts are named by their zero based index
     * `cohort_0`, `cohort_1`, etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dimension_ = "";
    /**
     *
     *
     * <pre>
     * Dimension used by the cohort. Required and only supports
     * `firstSessionDate`.
     * </pre>
     *
     * <code>string dimension = 2;</code>
     *
     * @return The dimension.
     */
    public java.lang.String getDimension() {
      java.lang.Object ref = dimension_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dimension_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Dimension used by the cohort. Required and only supports
     * `firstSessionDate`.
     * </pre>
     *
     * <code>string dimension = 2;</code>
     *
     * @return The bytes for dimension.
     */
    public com.google.protobuf.ByteString getDimensionBytes() {
      java.lang.Object ref = dimension_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dimension_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Dimension used by the cohort. Required and only supports
     * `firstSessionDate`.
     * </pre>
     *
     * <code>string dimension = 2;</code>
     *
     * @param value The dimension to set.
     * @return This builder for chaining.
     */
    public Builder setDimension(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dimension_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dimension used by the cohort. Required and only supports
     * `firstSessionDate`.
     * </pre>
     *
     * <code>string dimension = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDimension() {
      dimension_ = getDefaultInstance().getDimension();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dimension used by the cohort. Required and only supports
     * `firstSessionDate`.
     * </pre>
     *
     * <code>string dimension = 2;</code>
     *
     * @param value The bytes for dimension to set.
     * @return This builder for chaining.
     */
    public Builder setDimensionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dimension_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1beta.DateRange dateRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.DateRange,
            com.google.analytics.data.v1beta.DateRange.Builder,
            com.google.analytics.data.v1beta.DateRangeOrBuilder>
        dateRangeBuilder_;
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     *
     * @return Whether the dateRange field is set.
     */
    public boolean hasDateRange() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     *
     * @return The dateRange.
     */
    public com.google.analytics.data.v1beta.DateRange getDateRange() {
      if (dateRangeBuilder_ == null) {
        return dateRange_ == null
            ? com.google.analytics.data.v1beta.DateRange.getDefaultInstance()
            : dateRange_;
      } else {
        return dateRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    public Builder setDateRange(com.google.analytics.data.v1beta.DateRange value) {
      if (dateRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dateRange_ = value;
      } else {
        dateRangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    public Builder setDateRange(
        com.google.analytics.data.v1beta.DateRange.Builder builderForValue) {
      if (dateRangeBuilder_ == null) {
        dateRange_ = builderForValue.build();
      } else {
        dateRangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    public Builder mergeDateRange(com.google.analytics.data.v1beta.DateRange value) {
      if (dateRangeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && dateRange_ != null
            && dateRange_ != com.google.analytics.data.v1beta.DateRange.getDefaultInstance()) {
          getDateRangeBuilder().mergeFrom(value);
        } else {
          dateRange_ = value;
        }
      } else {
        dateRangeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    public Builder clearDateRange() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dateRange_ = null;
      if (dateRangeBuilder_ != null) {
        dateRangeBuilder_.dispose();
        dateRangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    public com.google.analytics.data.v1beta.DateRange.Builder getDateRangeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDateRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    public com.google.analytics.data.v1beta.DateRangeOrBuilder getDateRangeOrBuilder() {
      if (dateRangeBuilder_ != null) {
        return dateRangeBuilder_.getMessageOrBuilder();
      } else {
        return dateRange_ == null
            ? com.google.analytics.data.v1beta.DateRange.getDefaultInstance()
            : dateRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * The cohort selects users whose first touch date is between start date and
     * end date defined in the `dateRange`. This `dateRange` does not specify the
     * full date range of event data that is present in a cohort report. In a
     * cohort report, this `dateRange` is extended by the granularity and offset
     * present in the `cohortsRange`; event data for the extended reporting date
     * range is present in a cohort report.
     *
     * In a cohort request, this `dateRange` is required and the `dateRanges` in
     * the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
     *
     * This `dateRange` should generally be aligned with the cohort's granularity.
     * If `CohortsRange` uses daily granularity, this `dateRange` can be a single
     * day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
     * aligned to a week boundary, starting at Sunday and ending Saturday. If
     * `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
     * a month, starting at the first and ending on the last day of the month.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.DateRange date_range = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.DateRange,
            com.google.analytics.data.v1beta.DateRange.Builder,
            com.google.analytics.data.v1beta.DateRangeOrBuilder>
        getDateRangeFieldBuilder() {
      if (dateRangeBuilder_ == null) {
        dateRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.DateRange,
                com.google.analytics.data.v1beta.DateRange.Builder,
                com.google.analytics.data.v1beta.DateRangeOrBuilder>(
                getDateRange(), getParentForChildren(), isClean());
        dateRange_ = null;
      }
      return dateRangeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.Cohort)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.Cohort)
  private static final com.google.analytics.data.v1beta.Cohort DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.Cohort();
  }

  public static com.google.analytics.data.v1beta.Cohort getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cohort> PARSER =
      new com.google.protobuf.AbstractParser<Cohort>() {
        @java.lang.Override
        public Cohort parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cohort> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cohort> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.Cohort getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
