/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/data.proto

package com.google.analytics.data.v1beta;

public interface CohortsRangeOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.analytics.data.v1beta.CohortsRange)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The granularity used to interpret the `startOffset` and
   * `endOffset` for the extended reporting date range for a cohort report.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortsRange.Granularity granularity = 1;</code>
   *
   * @return The enum numeric value on the wire for granularity.
   */
  int getGranularityValue();
  /**
   *
   *
   * <pre>
   * Required. The granularity used to interpret the `startOffset` and
   * `endOffset` for the extended reporting date range for a cohort report.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortsRange.Granularity granularity = 1;</code>
   *
   * @return The granularity.
   */
  com.google.analytics.data.v1beta.CohortsRange.Granularity getGranularity();

  /**
   *
   *
   * <pre>
   * `startOffset` specifies the start date of the extended reporting date range
   * for a cohort report. `startOffset` is commonly set to 0 so that reports
   * contain data from the acquisition of the cohort forward.
   * If `granularity` is `DAILY`, the `startDate` of the extended reporting date
   * range is `startDate` of the cohort plus `startOffset` days.
   * If `granularity` is `WEEKLY`, the `startDate` of the extended reporting
   * date range is `startDate` of the cohort plus `startOffset * 7` days.
   * If `granularity` is `MONTHLY`, the `startDate` of the extended reporting
   * date range is `startDate` of the cohort plus `startOffset * 30` days.
   * </pre>
   *
   * <code>int32 start_offset = 2;</code>
   *
   * @return The startOffset.
   */
  int getStartOffset();

  /**
   *
   *
   * <pre>
   * Required. `endOffset` specifies the end date of the extended reporting date
   * range for a cohort report. `endOffset` can be any positive integer but is
   * commonly set to 5 to 10 so that reports contain data on the cohort for the
   * next several granularity time periods.
   * If `granularity` is `DAILY`, the `endDate` of the extended reporting date
   * range is `endDate` of the cohort plus `endOffset` days.
   * If `granularity` is `WEEKLY`, the `endDate` of the extended reporting date
   * range is `endDate` of the cohort plus `endOffset * 7` days.
   * If `granularity` is `MONTHLY`, the `endDate` of the extended reporting date
   * range is `endDate` of the cohort plus `endOffset * 30` days.
   * </pre>
   *
   * <code>int32 end_offset = 3;</code>
   *
   * @return The endOffset.
   */
  int getEndOffset();
}
