/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.8
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * Configures a long-running operation resource to send a webhook notification
 * from the Google Analytics Data API to your webhook server when the resource
 * updates.
 *
 * Notification configurations contain private values &amp; are only visible to your
 * GCP project. Different GCP projects may attach different webhook
 * notifications to the same long-running operation resource.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.WebhookNotification}
 */
public final class WebhookNotification extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.WebhookNotification)
    WebhookNotificationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WebhookNotification.newBuilder() to construct.
  private WebhookNotification(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebhookNotification() {
    uri_ = "";
    channelToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebhookNotification();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_WebhookNotification_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_WebhookNotification_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.WebhookNotification.class,
            com.google.analytics.data.v1alpha.WebhookNotification.Builder.class);
  }

  private int bitField0_;
  public static final int URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The web address that will receive the webhook notification. This
   * address will receive POST requests as the state of the long running
   * operation resource changes. The POST request will contain both a JSON
   * version of the long running operation resource in the body and a
   * `sentTimestamp` field. The sent timestamp will specify the unix
   * microseconds since the epoch that the request was sent; this lets you
   * identify replayed notifications.
   *
   * An example URI is
   * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
   *
   * The URI must use HTTPS and point to a site with a valid SSL certificate on
   * the web server. The URI must have a maximum string length of 128 characters
   * &amp; use only the allowlisted characters from [RFC
   * 1738](https://www.rfc-editor.org/rfc/rfc1738).
   *
   * When your webhook server receives a notification, it is expected to reply
   * with an HTTP response status code of 200 within 5 seconds.
   *
   * A URI is required to use webhook notifications.
   *
   * Requests to this webhook server will contain an ID token authenticating the
   * service account
   * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
   * more about ID tokens, see
   * https://cloud.google.com/docs/authentication/token-types#id. For Google
   * Cloud Functions, this lets you configure your function to require
   * authentication. In Cloud IAM, you will need to grant the service account
   * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
   * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
   * post request to pass Google Cloud Functions authentication. This API can
   * send webhook notifications to arbitrary URIs; for webhook servers other
   * than Google Cloud Functions, this ID token in the authorization bearer
   * header should be ignored if it is not needed.
   * </pre>
   *
   * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the uri field is set.
   */
  @java.lang.Override
  public boolean hasUri() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The web address that will receive the webhook notification. This
   * address will receive POST requests as the state of the long running
   * operation resource changes. The POST request will contain both a JSON
   * version of the long running operation resource in the body and a
   * `sentTimestamp` field. The sent timestamp will specify the unix
   * microseconds since the epoch that the request was sent; this lets you
   * identify replayed notifications.
   *
   * An example URI is
   * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
   *
   * The URI must use HTTPS and point to a site with a valid SSL certificate on
   * the web server. The URI must have a maximum string length of 128 characters
   * &amp; use only the allowlisted characters from [RFC
   * 1738](https://www.rfc-editor.org/rfc/rfc1738).
   *
   * When your webhook server receives a notification, it is expected to reply
   * with an HTTP response status code of 200 within 5 seconds.
   *
   * A URI is required to use webhook notifications.
   *
   * Requests to this webhook server will contain an ID token authenticating the
   * service account
   * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
   * more about ID tokens, see
   * https://cloud.google.com/docs/authentication/token-types#id. For Google
   * Cloud Functions, this lets you configure your function to require
   * authentication. In Cloud IAM, you will need to grant the service account
   * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
   * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
   * post request to pass Google Cloud Functions authentication. This API can
   * send webhook notifications to arbitrary URIs; for webhook servers other
   * than Google Cloud Functions, this ID token in the authorization bearer
   * header should be ignored if it is not needed.
   * </pre>
   *
   * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The web address that will receive the webhook notification. This
   * address will receive POST requests as the state of the long running
   * operation resource changes. The POST request will contain both a JSON
   * version of the long running operation resource in the body and a
   * `sentTimestamp` field. The sent timestamp will specify the unix
   * microseconds since the epoch that the request was sent; this lets you
   * identify replayed notifications.
   *
   * An example URI is
   * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
   *
   * The URI must use HTTPS and point to a site with a valid SSL certificate on
   * the web server. The URI must have a maximum string length of 128 characters
   * &amp; use only the allowlisted characters from [RFC
   * 1738](https://www.rfc-editor.org/rfc/rfc1738).
   *
   * When your webhook server receives a notification, it is expected to reply
   * with an HTTP response status code of 200 within 5 seconds.
   *
   * A URI is required to use webhook notifications.
   *
   * Requests to this webhook server will contain an ID token authenticating the
   * service account
   * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
   * more about ID tokens, see
   * https://cloud.google.com/docs/authentication/token-types#id. For Google
   * Cloud Functions, this lets you configure your function to require
   * authentication. In Cloud IAM, you will need to grant the service account
   * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
   * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
   * post request to pass Google Cloud Functions authentication. This API can
   * send webhook notifications to arbitrary URIs; for webhook servers other
   * than Google Cloud Functions, this ID token in the authorization bearer
   * header should be ignored if it is not needed.
   * </pre>
   *
   * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANNEL_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object channelToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The channel token is an arbitrary string value and must have a
   * maximum string length of 64 characters. Channel tokens allow you to verify
   * the source of a webhook notification. This guards against the message being
   * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
   * HTTP header of the webhook POST request.
   *
   * A channel token is not required to use webhook notifications.
   * </pre>
   *
   * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the channelToken field is set.
   */
  @java.lang.Override
  public boolean hasChannelToken() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The channel token is an arbitrary string value and must have a
   * maximum string length of 64 characters. Channel tokens allow you to verify
   * the source of a webhook notification. This guards against the message being
   * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
   * HTTP header of the webhook POST request.
   *
   * A channel token is not required to use webhook notifications.
   * </pre>
   *
   * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The channelToken.
   */
  @java.lang.Override
  public java.lang.String getChannelToken() {
    java.lang.Object ref = channelToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      channelToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The channel token is an arbitrary string value and must have a
   * maximum string length of 64 characters. Channel tokens allow you to verify
   * the source of a webhook notification. This guards against the message being
   * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
   * HTTP header of the webhook POST request.
   *
   * A channel token is not required to use webhook notifications.
   * </pre>
   *
   * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for channelToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChannelTokenBytes() {
    java.lang.Object ref = channelToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      channelToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, channelToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, channelToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.WebhookNotification)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.WebhookNotification other =
        (com.google.analytics.data.v1alpha.WebhookNotification) obj;

    if (hasUri() != other.hasUri()) return false;
    if (hasUri()) {
      if (!getUri().equals(other.getUri())) return false;
    }
    if (hasChannelToken() != other.hasChannelToken()) return false;
    if (hasChannelToken()) {
      if (!getChannelToken().equals(other.getChannelToken())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasUri()) {
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
    }
    if (hasChannelToken()) {
      hash = (37 * hash) + CHANNEL_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getChannelToken().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1alpha.WebhookNotification prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configures a long-running operation resource to send a webhook notification
   * from the Google Analytics Data API to your webhook server when the resource
   * updates.
   *
   * Notification configurations contain private values &amp; are only visible to your
   * GCP project. Different GCP projects may attach different webhook
   * notifications to the same long-running operation resource.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.WebhookNotification}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.WebhookNotification)
      com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_WebhookNotification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_WebhookNotification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.WebhookNotification.class,
              com.google.analytics.data.v1alpha.WebhookNotification.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.WebhookNotification.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      uri_ = "";
      channelToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_WebhookNotification_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.WebhookNotification getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.WebhookNotification build() {
      com.google.analytics.data.v1alpha.WebhookNotification result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.WebhookNotification buildPartial() {
      com.google.analytics.data.v1alpha.WebhookNotification result =
          new com.google.analytics.data.v1alpha.WebhookNotification(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.WebhookNotification result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.uri_ = uri_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.channelToken_ = channelToken_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.WebhookNotification) {
        return mergeFrom((com.google.analytics.data.v1alpha.WebhookNotification) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.WebhookNotification other) {
      if (other == com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance())
        return this;
      if (other.hasUri()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasChannelToken()) {
        channelToken_ = other.channelToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                channelToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object uri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     *
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * &amp; use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     *
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     *
     * A URI is required to use webhook notifications.
     *
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     * </pre>
     *
     * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the uri field is set.
     */
    public boolean hasUri() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     *
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * &amp; use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     *
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     *
     * A URI is required to use webhook notifications.
     *
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     * </pre>
     *
     * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     *
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * &amp; use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     *
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     *
     * A URI is required to use webhook notifications.
     *
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     * </pre>
     *
     * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     *
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * &amp; use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     *
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     *
     * A URI is required to use webhook notifications.
     *
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     * </pre>
     *
     * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     *
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * &amp; use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     *
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     *
     * A URI is required to use webhook notifications.
     *
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     * </pre>
     *
     * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     *
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * &amp; use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     *
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     *
     * A URI is required to use webhook notifications.
     *
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     * </pre>
     *
     * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object channelToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     *
     * A channel token is not required to use webhook notifications.
     * </pre>
     *
     * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the channelToken field is set.
     */
    public boolean hasChannelToken() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     *
     * A channel token is not required to use webhook notifications.
     * </pre>
     *
     * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The channelToken.
     */
    public java.lang.String getChannelToken() {
      java.lang.Object ref = channelToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        channelToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     *
     * A channel token is not required to use webhook notifications.
     * </pre>
     *
     * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for channelToken.
     */
    public com.google.protobuf.ByteString getChannelTokenBytes() {
      java.lang.Object ref = channelToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        channelToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     *
     * A channel token is not required to use webhook notifications.
     * </pre>
     *
     * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The channelToken to set.
     * @return This builder for chaining.
     */
    public Builder setChannelToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      channelToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     *
     * A channel token is not required to use webhook notifications.
     * </pre>
     *
     * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannelToken() {
      channelToken_ = getDefaultInstance().getChannelToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     *
     * A channel token is not required to use webhook notifications.
     * </pre>
     *
     * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for channelToken to set.
     * @return This builder for chaining.
     */
    public Builder setChannelTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      channelToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.WebhookNotification)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.WebhookNotification)
  private static final com.google.analytics.data.v1alpha.WebhookNotification DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.WebhookNotification();
  }

  public static com.google.analytics.data.v1alpha.WebhookNotification getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebhookNotification> PARSER =
      new com.google.protobuf.AbstractParser<WebhookNotification>() {
        @java.lang.Override
        public WebhookNotification parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WebhookNotification> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebhookNotification> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.WebhookNotification getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
