/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.8
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * The created Google Sheet with the list of users in an audience list.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.SheetExportAudienceListResponse}
 */
public final class SheetExportAudienceListResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.SheetExportAudienceListResponse)
    SheetExportAudienceListResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SheetExportAudienceListResponse.newBuilder() to construct.
  private SheetExportAudienceListResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SheetExportAudienceListResponse() {
    spreadsheetUri_ = "";
    spreadsheetId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SheetExportAudienceListResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_SheetExportAudienceListResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_SheetExportAudienceListResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.class,
            com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.Builder.class);
  }

  private int bitField0_;
  public static final int SPREADSHEET_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object spreadsheetUri_ = "";

  /**
   *
   *
   * <pre>
   * A uri for you to visit in your browser to view the Google Sheet.
   * </pre>
   *
   * <code>optional string spreadsheet_uri = 1;</code>
   *
   * @return Whether the spreadsheetUri field is set.
   */
  @java.lang.Override
  public boolean hasSpreadsheetUri() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * A uri for you to visit in your browser to view the Google Sheet.
   * </pre>
   *
   * <code>optional string spreadsheet_uri = 1;</code>
   *
   * @return The spreadsheetUri.
   */
  @java.lang.Override
  public java.lang.String getSpreadsheetUri() {
    java.lang.Object ref = spreadsheetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      spreadsheetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A uri for you to visit in your browser to view the Google Sheet.
   * </pre>
   *
   * <code>optional string spreadsheet_uri = 1;</code>
   *
   * @return The bytes for spreadsheetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpreadsheetUriBytes() {
    java.lang.Object ref = spreadsheetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      spreadsheetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPREADSHEET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object spreadsheetId_ = "";

  /**
   *
   *
   * <pre>
   * An ID that identifies the created Google Sheet resource.
   * </pre>
   *
   * <code>optional string spreadsheet_id = 2;</code>
   *
   * @return Whether the spreadsheetId field is set.
   */
  @java.lang.Override
  public boolean hasSpreadsheetId() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An ID that identifies the created Google Sheet resource.
   * </pre>
   *
   * <code>optional string spreadsheet_id = 2;</code>
   *
   * @return The spreadsheetId.
   */
  @java.lang.Override
  public java.lang.String getSpreadsheetId() {
    java.lang.Object ref = spreadsheetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      spreadsheetId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An ID that identifies the created Google Sheet resource.
   * </pre>
   *
   * <code>optional string spreadsheet_id = 2;</code>
   *
   * @return The bytes for spreadsheetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpreadsheetIdBytes() {
    java.lang.Object ref = spreadsheetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      spreadsheetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 3;
  private int rowCount_ = 0;

  /**
   *
   *
   * <pre>
   * The total number of rows in the AudienceList result. `rowCount` is
   * independent of the number of rows returned in the response, the `limit`
   * request parameter, and the `offset` request parameter. For example if a
   * query returns 175 rows and includes `limit` of 50 in the API request, the
   * response will contain `rowCount` of 175 but only 50 rows.
   *
   * To learn more about this pagination parameter, see
   * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
   * </pre>
   *
   * <code>optional int32 row_count = 3;</code>
   *
   * @return Whether the rowCount field is set.
   */
  @java.lang.Override
  public boolean hasRowCount() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The total number of rows in the AudienceList result. `rowCount` is
   * independent of the number of rows returned in the response, the `limit`
   * request parameter, and the `offset` request parameter. For example if a
   * query returns 175 rows and includes `limit` of 50 in the API request, the
   * response will contain `rowCount` of 175 but only 50 rows.
   *
   * To learn more about this pagination parameter, see
   * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
   * </pre>
   *
   * <code>optional int32 row_count = 3;</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public int getRowCount() {
    return rowCount_;
  }

  public static final int AUDIENCE_LIST_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1alpha.AudienceList audienceList_;

  /**
   *
   *
   * <pre>
   * Configuration data about AudienceList being exported. Returned to help
   * interpret the AudienceList in the Google Sheet of this response.
   *
   * For example, the AudienceList may have more rows than are present in the
   * Google Sheet, and in that case, you may want to send an additional sheet
   * export request with a different `offset` value to retrieve the next page of
   * rows in an additional Google Sheet.
   * </pre>
   *
   * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
   *
   * @return Whether the audienceList field is set.
   */
  @java.lang.Override
  public boolean hasAudienceList() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Configuration data about AudienceList being exported. Returned to help
   * interpret the AudienceList in the Google Sheet of this response.
   *
   * For example, the AudienceList may have more rows than are present in the
   * Google Sheet, and in that case, you may want to send an additional sheet
   * export request with a different `offset` value to retrieve the next page of
   * rows in an additional Google Sheet.
   * </pre>
   *
   * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
   *
   * @return The audienceList.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceList getAudienceList() {
    return audienceList_ == null
        ? com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance()
        : audienceList_;
  }

  /**
   *
   *
   * <pre>
   * Configuration data about AudienceList being exported. Returned to help
   * interpret the AudienceList in the Google Sheet of this response.
   *
   * For example, the AudienceList may have more rows than are present in the
   * Google Sheet, and in that case, you may want to send an additional sheet
   * export request with a different `offset` value to retrieve the next page of
   * rows in an additional Google Sheet.
   * </pre>
   *
   * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceListOrBuilder getAudienceListOrBuilder() {
    return audienceList_ == null
        ? com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance()
        : audienceList_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, spreadsheetUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, spreadsheetId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(3, rowCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getAudienceList());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, spreadsheetUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, spreadsheetId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, rowCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAudienceList());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.SheetExportAudienceListResponse)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.SheetExportAudienceListResponse other =
        (com.google.analytics.data.v1alpha.SheetExportAudienceListResponse) obj;

    if (hasSpreadsheetUri() != other.hasSpreadsheetUri()) return false;
    if (hasSpreadsheetUri()) {
      if (!getSpreadsheetUri().equals(other.getSpreadsheetUri())) return false;
    }
    if (hasSpreadsheetId() != other.hasSpreadsheetId()) return false;
    if (hasSpreadsheetId()) {
      if (!getSpreadsheetId().equals(other.getSpreadsheetId())) return false;
    }
    if (hasRowCount() != other.hasRowCount()) return false;
    if (hasRowCount()) {
      if (getRowCount() != other.getRowCount()) return false;
    }
    if (hasAudienceList() != other.hasAudienceList()) return false;
    if (hasAudienceList()) {
      if (!getAudienceList().equals(other.getAudienceList())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSpreadsheetUri()) {
      hash = (37 * hash) + SPREADSHEET_URI_FIELD_NUMBER;
      hash = (53 * hash) + getSpreadsheetUri().hashCode();
    }
    if (hasSpreadsheetId()) {
      hash = (37 * hash) + SPREADSHEET_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSpreadsheetId().hashCode();
    }
    if (hasRowCount()) {
      hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRowCount();
    }
    if (hasAudienceList()) {
      hash = (37 * hash) + AUDIENCE_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getAudienceList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1alpha.SheetExportAudienceListResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The created Google Sheet with the list of users in an audience list.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.SheetExportAudienceListResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.SheetExportAudienceListResponse)
      com.google.analytics.data.v1alpha.SheetExportAudienceListResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_SheetExportAudienceListResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_SheetExportAudienceListResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.class,
              com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.Builder.class);
    }

    // Construct using
    // com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAudienceListFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      spreadsheetUri_ = "";
      spreadsheetId_ = "";
      rowCount_ = 0;
      audienceList_ = null;
      if (audienceListBuilder_ != null) {
        audienceListBuilder_.dispose();
        audienceListBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_SheetExportAudienceListResponse_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.SheetExportAudienceListResponse
        getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.SheetExportAudienceListResponse build() {
      com.google.analytics.data.v1alpha.SheetExportAudienceListResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.SheetExportAudienceListResponse buildPartial() {
      com.google.analytics.data.v1alpha.SheetExportAudienceListResponse result =
          new com.google.analytics.data.v1alpha.SheetExportAudienceListResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.analytics.data.v1alpha.SheetExportAudienceListResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.spreadsheetUri_ = spreadsheetUri_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.spreadsheetId_ = spreadsheetId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rowCount_ = rowCount_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.audienceList_ =
            audienceListBuilder_ == null ? audienceList_ : audienceListBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.SheetExportAudienceListResponse) {
        return mergeFrom((com.google.analytics.data.v1alpha.SheetExportAudienceListResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.analytics.data.v1alpha.SheetExportAudienceListResponse other) {
      if (other
          == com.google.analytics.data.v1alpha.SheetExportAudienceListResponse.getDefaultInstance())
        return this;
      if (other.hasSpreadsheetUri()) {
        spreadsheetUri_ = other.spreadsheetUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSpreadsheetId()) {
        spreadsheetId_ = other.spreadsheetId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasRowCount()) {
        setRowCount(other.getRowCount());
      }
      if (other.hasAudienceList()) {
        mergeAudienceList(other.getAudienceList());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                spreadsheetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                spreadsheetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                rowCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getAudienceListFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object spreadsheetUri_ = "";

    /**
     *
     *
     * <pre>
     * A uri for you to visit in your browser to view the Google Sheet.
     * </pre>
     *
     * <code>optional string spreadsheet_uri = 1;</code>
     *
     * @return Whether the spreadsheetUri field is set.
     */
    public boolean hasSpreadsheetUri() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * A uri for you to visit in your browser to view the Google Sheet.
     * </pre>
     *
     * <code>optional string spreadsheet_uri = 1;</code>
     *
     * @return The spreadsheetUri.
     */
    public java.lang.String getSpreadsheetUri() {
      java.lang.Object ref = spreadsheetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        spreadsheetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A uri for you to visit in your browser to view the Google Sheet.
     * </pre>
     *
     * <code>optional string spreadsheet_uri = 1;</code>
     *
     * @return The bytes for spreadsheetUri.
     */
    public com.google.protobuf.ByteString getSpreadsheetUriBytes() {
      java.lang.Object ref = spreadsheetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        spreadsheetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A uri for you to visit in your browser to view the Google Sheet.
     * </pre>
     *
     * <code>optional string spreadsheet_uri = 1;</code>
     *
     * @param value The spreadsheetUri to set.
     * @return This builder for chaining.
     */
    public Builder setSpreadsheetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      spreadsheetUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A uri for you to visit in your browser to view the Google Sheet.
     * </pre>
     *
     * <code>optional string spreadsheet_uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpreadsheetUri() {
      spreadsheetUri_ = getDefaultInstance().getSpreadsheetUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A uri for you to visit in your browser to view the Google Sheet.
     * </pre>
     *
     * <code>optional string spreadsheet_uri = 1;</code>
     *
     * @param value The bytes for spreadsheetUri to set.
     * @return This builder for chaining.
     */
    public Builder setSpreadsheetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      spreadsheetUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object spreadsheetId_ = "";

    /**
     *
     *
     * <pre>
     * An ID that identifies the created Google Sheet resource.
     * </pre>
     *
     * <code>optional string spreadsheet_id = 2;</code>
     *
     * @return Whether the spreadsheetId field is set.
     */
    public boolean hasSpreadsheetId() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An ID that identifies the created Google Sheet resource.
     * </pre>
     *
     * <code>optional string spreadsheet_id = 2;</code>
     *
     * @return The spreadsheetId.
     */
    public java.lang.String getSpreadsheetId() {
      java.lang.Object ref = spreadsheetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        spreadsheetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An ID that identifies the created Google Sheet resource.
     * </pre>
     *
     * <code>optional string spreadsheet_id = 2;</code>
     *
     * @return The bytes for spreadsheetId.
     */
    public com.google.protobuf.ByteString getSpreadsheetIdBytes() {
      java.lang.Object ref = spreadsheetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        spreadsheetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An ID that identifies the created Google Sheet resource.
     * </pre>
     *
     * <code>optional string spreadsheet_id = 2;</code>
     *
     * @param value The spreadsheetId to set.
     * @return This builder for chaining.
     */
    public Builder setSpreadsheetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      spreadsheetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ID that identifies the created Google Sheet resource.
     * </pre>
     *
     * <code>optional string spreadsheet_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpreadsheetId() {
      spreadsheetId_ = getDefaultInstance().getSpreadsheetId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ID that identifies the created Google Sheet resource.
     * </pre>
     *
     * <code>optional string spreadsheet_id = 2;</code>
     *
     * @param value The bytes for spreadsheetId to set.
     * @return This builder for chaining.
     */
    public Builder setSpreadsheetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      spreadsheetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int rowCount_;

    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceList result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @return Whether the rowCount field is set.
     */
    @java.lang.Override
    public boolean hasRowCount() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceList result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public int getRowCount() {
      return rowCount_;
    }

    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceList result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(int value) {

      rowCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceList result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rowCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.AudienceList audienceList_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.AudienceList,
            com.google.analytics.data.v1alpha.AudienceList.Builder,
            com.google.analytics.data.v1alpha.AudienceListOrBuilder>
        audienceListBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     *
     * @return Whether the audienceList field is set.
     */
    public boolean hasAudienceList() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     *
     * @return The audienceList.
     */
    public com.google.analytics.data.v1alpha.AudienceList getAudienceList() {
      if (audienceListBuilder_ == null) {
        return audienceList_ == null
            ? com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance()
            : audienceList_;
      } else {
        return audienceListBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    public Builder setAudienceList(com.google.analytics.data.v1alpha.AudienceList value) {
      if (audienceListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audienceList_ = value;
      } else {
        audienceListBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    public Builder setAudienceList(
        com.google.analytics.data.v1alpha.AudienceList.Builder builderForValue) {
      if (audienceListBuilder_ == null) {
        audienceList_ = builderForValue.build();
      } else {
        audienceListBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    public Builder mergeAudienceList(com.google.analytics.data.v1alpha.AudienceList value) {
      if (audienceListBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && audienceList_ != null
            && audienceList_
                != com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance()) {
          getAudienceListBuilder().mergeFrom(value);
        } else {
          audienceList_ = value;
        }
      } else {
        audienceListBuilder_.mergeFrom(value);
      }
      if (audienceList_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    public Builder clearAudienceList() {
      bitField0_ = (bitField0_ & ~0x00000008);
      audienceList_ = null;
      if (audienceListBuilder_ != null) {
        audienceListBuilder_.dispose();
        audienceListBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    public com.google.analytics.data.v1alpha.AudienceList.Builder getAudienceListBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAudienceListFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    public com.google.analytics.data.v1alpha.AudienceListOrBuilder getAudienceListOrBuilder() {
      if (audienceListBuilder_ != null) {
        return audienceListBuilder_.getMessageOrBuilder();
      } else {
        return audienceList_ == null
            ? com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance()
            : audienceList_;
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration data about AudienceList being exported. Returned to help
     * interpret the AudienceList in the Google Sheet of this response.
     *
     * For example, the AudienceList may have more rows than are present in the
     * Google Sheet, and in that case, you may want to send an additional sheet
     * export request with a different `offset` value to retrieve the next page of
     * rows in an additional Google Sheet.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1alpha.AudienceList audience_list = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.AudienceList,
            com.google.analytics.data.v1alpha.AudienceList.Builder,
            com.google.analytics.data.v1alpha.AudienceListOrBuilder>
        getAudienceListFieldBuilder() {
      if (audienceListBuilder_ == null) {
        audienceListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.AudienceList,
                com.google.analytics.data.v1alpha.AudienceList.Builder,
                com.google.analytics.data.v1alpha.AudienceListOrBuilder>(
                getAudienceList(), getParentForChildren(), isClean());
        audienceList_ = null;
      }
      return audienceListBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.SheetExportAudienceListResponse)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.SheetExportAudienceListResponse)
  private static final com.google.analytics.data.v1alpha.SheetExportAudienceListResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.SheetExportAudienceListResponse();
  }

  public static com.google.analytics.data.v1alpha.SheetExportAudienceListResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SheetExportAudienceListResponse> PARSER =
      new com.google.protobuf.AbstractParser<SheetExportAudienceListResponse>() {
        @java.lang.Override
        public SheetExportAudienceListResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SheetExportAudienceListResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SheetExportAudienceListResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.SheetExportAudienceListResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
