/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

// Protobuf Java Version: 3.25.5
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * Response's metadata carrying additional information about the report content.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.ResponseMetaData}
 */
public final class ResponseMetaData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.ResponseMetaData)
    ResponseMetaDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResponseMetaData.newBuilder() to construct.
  private ResponseMetaData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResponseMetaData() {
    currencyCode_ = "";
    timeZone_ = "";
    emptyReason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResponseMetaData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_ResponseMetaData_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_ResponseMetaData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.ResponseMetaData.class,
            com.google.analytics.data.v1alpha.ResponseMetaData.Builder.class);
  }

  public interface SchemaRestrictionResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    java.util.List<
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction>
        getActiveMetricRestrictionsList();
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .ActiveMetricRestriction
        getActiveMetricRestrictions(int index);
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    int getActiveMetricRestrictionsCount();
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestrictionOrBuilder>
        getActiveMetricRestrictionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .ActiveMetricRestrictionOrBuilder
        getActiveMetricRestrictionsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The schema restrictions actively enforced in creating this report. To learn
   * more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse}
   */
  public static final class SchemaRestrictionResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse)
      SchemaRestrictionResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SchemaRestrictionResponse.newBuilder() to construct.
    private SchemaRestrictionResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SchemaRestrictionResponse() {
      activeMetricRestrictions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SchemaRestrictionResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.class,
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.Builder
                  .class);
    }

    public interface ActiveMetricRestrictionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the restricted metric.
       * </pre>
       *
       * <code>optional string metric_name = 1;</code>
       *
       * @return Whether the metricName field is set.
       */
      boolean hasMetricName();
      /**
       *
       *
       * <pre>
       * The name of the restricted metric.
       * </pre>
       *
       * <code>optional string metric_name = 1;</code>
       *
       * @return The metricName.
       */
      java.lang.String getMetricName();
      /**
       *
       *
       * <pre>
       * The name of the restricted metric.
       * </pre>
       *
       * <code>optional string metric_name = 1;</code>
       *
       * @return The bytes for metricName.
       */
      com.google.protobuf.ByteString getMetricNameBytes();

      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @return A list containing the restrictedMetricTypes.
       */
      java.util.List<com.google.analytics.data.v1alpha.RestrictedMetricType>
          getRestrictedMetricTypesList();
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @return The count of restrictedMetricTypes.
       */
      int getRestrictedMetricTypesCount();
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The restrictedMetricTypes at the given index.
       */
      com.google.analytics.data.v1alpha.RestrictedMetricType getRestrictedMetricTypes(int index);
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for restrictedMetricTypes.
       */
      java.util.List<java.lang.Integer> getRestrictedMetricTypesValueList();
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of restrictedMetricTypes at the given index.
       */
      int getRestrictedMetricTypesValue(int index);
    }
    /**
     *
     *
     * <pre>
     * A metric actively restricted in creating the report.
     * </pre>
     *
     * Protobuf type {@code
     * google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction}
     */
    public static final class ActiveMetricRestriction extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction)
        ActiveMetricRestrictionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ActiveMetricRestriction.newBuilder() to construct.
      private ActiveMetricRestriction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActiveMetricRestriction() {
        metricName_ = "";
        restrictedMetricTypes_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActiveMetricRestriction();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.analytics.data.v1alpha.ReportingApiProto
            .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.analytics.data.v1alpha.ReportingApiProto
            .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction.class,
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction.Builder.class);
      }

      private int bitField0_;
      public static final int METRIC_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object metricName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the restricted metric.
       * </pre>
       *
       * <code>optional string metric_name = 1;</code>
       *
       * @return Whether the metricName field is set.
       */
      @java.lang.Override
      public boolean hasMetricName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The name of the restricted metric.
       * </pre>
       *
       * <code>optional string metric_name = 1;</code>
       *
       * @return The metricName.
       */
      @java.lang.Override
      public java.lang.String getMetricName() {
        java.lang.Object ref = metricName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metricName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the restricted metric.
       * </pre>
       *
       * <code>optional string metric_name = 1;</code>
       *
       * @return The bytes for metricName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getMetricNameBytes() {
        java.lang.Object ref = metricName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metricName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RESTRICTED_METRIC_TYPES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<java.lang.Integer> restrictedMetricTypes_;

      private static final com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.analytics.data.v1alpha.RestrictedMetricType>
          restrictedMetricTypes_converter_ =
              new com.google.protobuf.Internal.ListAdapter.Converter<
                  java.lang.Integer, com.google.analytics.data.v1alpha.RestrictedMetricType>() {
                public com.google.analytics.data.v1alpha.RestrictedMetricType convert(
                    java.lang.Integer from) {
                  com.google.analytics.data.v1alpha.RestrictedMetricType result =
                      com.google.analytics.data.v1alpha.RestrictedMetricType.forNumber(from);
                  return result == null
                      ? com.google.analytics.data.v1alpha.RestrictedMetricType.UNRECOGNIZED
                      : result;
                }
              };
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @return A list containing the restrictedMetricTypes.
       */
      @java.lang.Override
      public java.util.List<com.google.analytics.data.v1alpha.RestrictedMetricType>
          getRestrictedMetricTypesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.analytics.data.v1alpha.RestrictedMetricType>(
            restrictedMetricTypes_, restrictedMetricTypes_converter_);
      }
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @return The count of restrictedMetricTypes.
       */
      @java.lang.Override
      public int getRestrictedMetricTypesCount() {
        return restrictedMetricTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The restrictedMetricTypes at the given index.
       */
      @java.lang.Override
      public com.google.analytics.data.v1alpha.RestrictedMetricType getRestrictedMetricTypes(
          int index) {
        return restrictedMetricTypes_converter_.convert(restrictedMetricTypes_.get(index));
      }
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for restrictedMetricTypes.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer> getRestrictedMetricTypesValueList() {
        return restrictedMetricTypes_;
      }
      /**
       *
       *
       * <pre>
       * The reason for this metric's restriction.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of restrictedMetricTypes at the given index.
       */
      @java.lang.Override
      public int getRestrictedMetricTypesValue(int index) {
        return restrictedMetricTypes_.get(index);
      }

      private int restrictedMetricTypesMemoizedSerializedSize;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metricName_);
        }
        if (getRestrictedMetricTypesList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(restrictedMetricTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < restrictedMetricTypes_.size(); i++) {
          output.writeEnumNoTag(restrictedMetricTypes_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metricName_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < restrictedMetricTypes_.size(); i++) {
            dataSize +=
                com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                    restrictedMetricTypes_.get(i));
          }
          size += dataSize;
          if (!getRestrictedMetricTypesList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
          }
          restrictedMetricTypesMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction)) {
          return super.equals(obj);
        }
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction
            other =
                (com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                        .ActiveMetricRestriction)
                    obj;

        if (hasMetricName() != other.hasMetricName()) return false;
        if (hasMetricName()) {
          if (!getMetricName().equals(other.getMetricName())) return false;
        }
        if (!restrictedMetricTypes_.equals(other.restrictedMetricTypes_)) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasMetricName()) {
          hash = (37 * hash) + METRIC_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getMetricName().hashCode();
        }
        if (getRestrictedMetricTypesCount() > 0) {
          hash = (37 * hash) + RESTRICTED_METRIC_TYPES_FIELD_NUMBER;
          hash = (53 * hash) + restrictedMetricTypes_.hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A metric actively restricted in creating the report.
       * </pre>
       *
       * Protobuf type {@code
       * google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction)
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestrictionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.analytics.data.v1alpha.ReportingApiProto
              .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.analytics.data.v1alpha.ReportingApiProto
              .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestriction.class,
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestriction.Builder.class);
        }

        // Construct using
        // com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          metricName_ = "";
          restrictedMetricTypes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.analytics.data.v1alpha.ReportingApiProto
              .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction_descriptor;
        }

        @java.lang.Override
        public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction
            getDefaultInstanceForType() {
          return com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction
            build() {
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction
            buildPartial() {
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction
              result =
                  new com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestriction(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction
                result) {
          if (((bitField0_ & 0x00000002) != 0)) {
            restrictedMetricTypes_ = java.util.Collections.unmodifiableList(restrictedMetricTypes_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.restrictedMetricTypes_ = restrictedMetricTypes_;
        }

        private void buildPartial0(
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.metricName_ = metricName_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction) {
            return mergeFrom(
                (com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                        .ActiveMetricRestriction)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction
                other) {
          if (other
              == com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.getDefaultInstance()) return this;
          if (other.hasMetricName()) {
            metricName_ = other.metricName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.restrictedMetricTypes_.isEmpty()) {
            if (restrictedMetricTypes_.isEmpty()) {
              restrictedMetricTypes_ = other.restrictedMetricTypes_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureRestrictedMetricTypesIsMutable();
              restrictedMetricTypes_.addAll(other.restrictedMetricTypes_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    metricName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    int tmpRaw = input.readEnum();
                    ensureRestrictedMetricTypesIsMutable();
                    restrictedMetricTypes_.add(tmpRaw);
                    break;
                  } // case 16
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    while (input.getBytesUntilLimit() > 0) {
                      int tmpRaw = input.readEnum();
                      ensureRestrictedMetricTypesIsMutable();
                      restrictedMetricTypes_.add(tmpRaw);
                    }
                    input.popLimit(oldLimit);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object metricName_ = "";
        /**
         *
         *
         * <pre>
         * The name of the restricted metric.
         * </pre>
         *
         * <code>optional string metric_name = 1;</code>
         *
         * @return Whether the metricName field is set.
         */
        public boolean hasMetricName() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The name of the restricted metric.
         * </pre>
         *
         * <code>optional string metric_name = 1;</code>
         *
         * @return The metricName.
         */
        public java.lang.String getMetricName() {
          java.lang.Object ref = metricName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            metricName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the restricted metric.
         * </pre>
         *
         * <code>optional string metric_name = 1;</code>
         *
         * @return The bytes for metricName.
         */
        public com.google.protobuf.ByteString getMetricNameBytes() {
          java.lang.Object ref = metricName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            metricName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the restricted metric.
         * </pre>
         *
         * <code>optional string metric_name = 1;</code>
         *
         * @param value The metricName to set.
         * @return This builder for chaining.
         */
        public Builder setMetricName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          metricName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the restricted metric.
         * </pre>
         *
         * <code>optional string metric_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMetricName() {
          metricName_ = getDefaultInstance().getMetricName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the restricted metric.
         * </pre>
         *
         * <code>optional string metric_name = 1;</code>
         *
         * @param value The bytes for metricName to set.
         * @return This builder for chaining.
         */
        public Builder setMetricNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          metricName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<java.lang.Integer> restrictedMetricTypes_ =
            java.util.Collections.emptyList();

        private void ensureRestrictedMetricTypesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            restrictedMetricTypes_ =
                new java.util.ArrayList<java.lang.Integer>(restrictedMetricTypes_);
            bitField0_ |= 0x00000002;
          }
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @return A list containing the restrictedMetricTypes.
         */
        public java.util.List<com.google.analytics.data.v1alpha.RestrictedMetricType>
            getRestrictedMetricTypesList() {
          return new com.google.protobuf.Internal.ListAdapter<
              java.lang.Integer, com.google.analytics.data.v1alpha.RestrictedMetricType>(
              restrictedMetricTypes_, restrictedMetricTypes_converter_);
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @return The count of restrictedMetricTypes.
         */
        public int getRestrictedMetricTypesCount() {
          return restrictedMetricTypes_.size();
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param index The index of the element to return.
         * @return The restrictedMetricTypes at the given index.
         */
        public com.google.analytics.data.v1alpha.RestrictedMetricType getRestrictedMetricTypes(
            int index) {
          return restrictedMetricTypes_converter_.convert(restrictedMetricTypes_.get(index));
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The restrictedMetricTypes to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictedMetricTypes(
            int index, com.google.analytics.data.v1alpha.RestrictedMetricType value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRestrictedMetricTypesIsMutable();
          restrictedMetricTypes_.set(index, value.getNumber());
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param value The restrictedMetricTypes to add.
         * @return This builder for chaining.
         */
        public Builder addRestrictedMetricTypes(
            com.google.analytics.data.v1alpha.RestrictedMetricType value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRestrictedMetricTypesIsMutable();
          restrictedMetricTypes_.add(value.getNumber());
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param values The restrictedMetricTypes to add.
         * @return This builder for chaining.
         */
        public Builder addAllRestrictedMetricTypes(
            java.lang.Iterable<? extends com.google.analytics.data.v1alpha.RestrictedMetricType>
                values) {
          ensureRestrictedMetricTypesIsMutable();
          for (com.google.analytics.data.v1alpha.RestrictedMetricType value : values) {
            restrictedMetricTypes_.add(value.getNumber());
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRestrictedMetricTypes() {
          restrictedMetricTypes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @return A list containing the enum numeric values on the wire for restrictedMetricTypes.
         */
        public java.util.List<java.lang.Integer> getRestrictedMetricTypesValueList() {
          return java.util.Collections.unmodifiableList(restrictedMetricTypes_);
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param index The index of the value to return.
         * @return The enum numeric value on the wire of restrictedMetricTypes at the given index.
         */
        public int getRestrictedMetricTypesValue(int index) {
          return restrictedMetricTypes_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The enum numeric value on the wire for restrictedMetricTypes to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictedMetricTypesValue(int index, int value) {
          ensureRestrictedMetricTypesIsMutable();
          restrictedMetricTypes_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param value The enum numeric value on the wire for restrictedMetricTypes to add.
         * @return This builder for chaining.
         */
        public Builder addRestrictedMetricTypesValue(int value) {
          ensureRestrictedMetricTypesIsMutable();
          restrictedMetricTypes_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The reason for this metric's restriction.
         * </pre>
         *
         * <code>
         * repeated .google.analytics.data.v1alpha.RestrictedMetricType restricted_metric_types = 2;
         * </code>
         *
         * @param values The enum numeric values on the wire for restrictedMetricTypes to add.
         * @return This builder for chaining.
         */
        public Builder addAllRestrictedMetricTypesValue(
            java.lang.Iterable<java.lang.Integer> values) {
          ensureRestrictedMetricTypesIsMutable();
          for (int value : values) {
            restrictedMetricTypes_.add(value);
          }
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction)
      }

      // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction)
      private static final com.google.analytics.data.v1alpha.ResponseMetaData
              .SchemaRestrictionResponse.ActiveMetricRestriction
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction();
      }

      public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActiveMetricRestriction> PARSER =
          new com.google.protobuf.AbstractParser<ActiveMetricRestriction>() {
            @java.lang.Override
            public ActiveMetricRestriction parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActiveMetricRestriction> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActiveMetricRestriction> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ACTIVE_METRIC_RESTRICTIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction>
        activeMetricRestrictions_;
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .ActiveMetricRestriction>
        getActiveMetricRestrictionsList() {
      return activeMetricRestrictions_;
    }
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestrictionOrBuilder>
        getActiveMetricRestrictionsOrBuilderList() {
      return activeMetricRestrictions_;
    }
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    @java.lang.Override
    public int getActiveMetricRestrictionsCount() {
      return activeMetricRestrictions_.size();
    }
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .ActiveMetricRestriction
        getActiveMetricRestrictions(int index) {
      return activeMetricRestrictions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All restrictions actively enforced in creating the report. For example,
     * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
     * However, this active response restriction is only populated if the user's
     * custom role disallows access to `REVENUE_DATA`.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .ActiveMetricRestrictionOrBuilder
        getActiveMetricRestrictionsOrBuilder(int index) {
      return activeMetricRestrictions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < activeMetricRestrictions_.size(); i++) {
        output.writeMessage(1, activeMetricRestrictions_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < activeMetricRestrictions_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, activeMetricRestrictions_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse)) {
        return super.equals(obj);
      }
      com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse other =
          (com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse) obj;

      if (!getActiveMetricRestrictionsList().equals(other.getActiveMetricRestrictionsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getActiveMetricRestrictionsCount() > 0) {
        hash = (37 * hash) + ACTIVE_METRIC_RESTRICTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getActiveMetricRestrictionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The schema restrictions actively enforced in creating this report. To learn
     * more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * Protobuf type {@code
     * google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse)
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.analytics.data.v1alpha.ReportingApiProto
            .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.analytics.data.v1alpha.ReportingApiProto
            .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.class,
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (activeMetricRestrictionsBuilder_ == null) {
          activeMetricRestrictions_ = java.util.Collections.emptyList();
        } else {
          activeMetricRestrictions_ = null;
          activeMetricRestrictionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.analytics.data.v1alpha.ReportingApiProto
            .internal_static_google_analytics_data_v1alpha_ResponseMetaData_SchemaRestrictionResponse_descriptor;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
          getDefaultInstanceForType() {
        return com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse build() {
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
          buildPartial() {
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse result =
            new com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse result) {
        if (activeMetricRestrictionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            activeMetricRestrictions_ =
                java.util.Collections.unmodifiableList(activeMetricRestrictions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.activeMetricRestrictions_ = activeMetricRestrictions_;
        } else {
          result.activeMetricRestrictions_ = activeMetricRestrictionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse) {
          return mergeFrom(
              (com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse other) {
        if (other
            == com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .getDefaultInstance()) return this;
        if (activeMetricRestrictionsBuilder_ == null) {
          if (!other.activeMetricRestrictions_.isEmpty()) {
            if (activeMetricRestrictions_.isEmpty()) {
              activeMetricRestrictions_ = other.activeMetricRestrictions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureActiveMetricRestrictionsIsMutable();
              activeMetricRestrictions_.addAll(other.activeMetricRestrictions_);
            }
            onChanged();
          }
        } else {
          if (!other.activeMetricRestrictions_.isEmpty()) {
            if (activeMetricRestrictionsBuilder_.isEmpty()) {
              activeMetricRestrictionsBuilder_.dispose();
              activeMetricRestrictionsBuilder_ = null;
              activeMetricRestrictions_ = other.activeMetricRestrictions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              activeMetricRestrictionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getActiveMetricRestrictionsFieldBuilder()
                      : null;
            } else {
              activeMetricRestrictionsBuilder_.addAllMessages(other.activeMetricRestrictions_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                          .ActiveMetricRestriction
                      m =
                          input.readMessage(
                              com.google.analytics.data.v1alpha.ResponseMetaData
                                  .SchemaRestrictionResponse.ActiveMetricRestriction.parser(),
                              extensionRegistry);
                  if (activeMetricRestrictionsBuilder_ == null) {
                    ensureActiveMetricRestrictionsIsMutable();
                    activeMetricRestrictions_.add(m);
                  } else {
                    activeMetricRestrictionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction>
          activeMetricRestrictions_ = java.util.Collections.emptyList();

      private void ensureActiveMetricRestrictionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          activeMetricRestrictions_ =
              new java.util.ArrayList<
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestriction>(activeMetricRestrictions_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction,
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.Builder,
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestrictionOrBuilder>
          activeMetricRestrictionsBuilder_;

      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public java.util.List<
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction>
          getActiveMetricRestrictionsList() {
        if (activeMetricRestrictionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(activeMetricRestrictions_);
        } else {
          return activeMetricRestrictionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public int getActiveMetricRestrictionsCount() {
        if (activeMetricRestrictionsBuilder_ == null) {
          return activeMetricRestrictions_.size();
        } else {
          return activeMetricRestrictionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction
          getActiveMetricRestrictions(int index) {
        if (activeMetricRestrictionsBuilder_ == null) {
          return activeMetricRestrictions_.get(index);
        } else {
          return activeMetricRestrictionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder setActiveMetricRestrictions(
          int index,
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction
              value) {
        if (activeMetricRestrictionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.set(index, value);
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder setActiveMetricRestrictions(
          int index,
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.Builder
              builderForValue) {
        if (activeMetricRestrictionsBuilder_ == null) {
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.set(index, builderForValue.build());
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder addActiveMetricRestrictions(
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction
              value) {
        if (activeMetricRestrictionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.add(value);
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder addActiveMetricRestrictions(
          int index,
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction
              value) {
        if (activeMetricRestrictionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.add(index, value);
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder addActiveMetricRestrictions(
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.Builder
              builderForValue) {
        if (activeMetricRestrictionsBuilder_ == null) {
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.add(builderForValue.build());
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder addActiveMetricRestrictions(
          int index,
          com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.Builder
              builderForValue) {
        if (activeMetricRestrictionsBuilder_ == null) {
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.add(index, builderForValue.build());
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder addAllActiveMetricRestrictions(
          java.lang.Iterable<
                  ? extends
                      com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                          .ActiveMetricRestriction>
              values) {
        if (activeMetricRestrictionsBuilder_ == null) {
          ensureActiveMetricRestrictionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, activeMetricRestrictions_);
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder clearActiveMetricRestrictions() {
        if (activeMetricRestrictionsBuilder_ == null) {
          activeMetricRestrictions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public Builder removeActiveMetricRestrictions(int index) {
        if (activeMetricRestrictionsBuilder_ == null) {
          ensureActiveMetricRestrictionsIsMutable();
          activeMetricRestrictions_.remove(index);
          onChanged();
        } else {
          activeMetricRestrictionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction.Builder
          getActiveMetricRestrictionsBuilder(int index) {
        return getActiveMetricRestrictionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestrictionOrBuilder
          getActiveMetricRestrictionsOrBuilder(int index) {
        if (activeMetricRestrictionsBuilder_ == null) {
          return activeMetricRestrictions_.get(index);
        } else {
          return activeMetricRestrictionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestrictionOrBuilder>
          getActiveMetricRestrictionsOrBuilderList() {
        if (activeMetricRestrictionsBuilder_ != null) {
          return activeMetricRestrictionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(activeMetricRestrictions_);
        }
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction.Builder
          addActiveMetricRestrictionsBuilder() {
        return getActiveMetricRestrictionsFieldBuilder()
            .addBuilder(
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
              .ActiveMetricRestriction.Builder
          addActiveMetricRestrictionsBuilder(int index) {
        return getActiveMetricRestrictionsFieldBuilder()
            .addBuilder(
                index,
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .ActiveMetricRestriction.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * All restrictions actively enforced in creating the report. For example,
       * `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
       * However, this active response restriction is only populated if the user's
       * custom role disallows access to `REVENUE_DATA`.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction active_metric_restrictions = 1;
       * </code>
       */
      public java.util.List<
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.Builder>
          getActiveMetricRestrictionsBuilderList() {
        return getActiveMetricRestrictionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction,
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestriction.Builder,
              com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                  .ActiveMetricRestrictionOrBuilder>
          getActiveMetricRestrictionsFieldBuilder() {
        if (activeMetricRestrictionsBuilder_ == null) {
          activeMetricRestrictionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestriction,
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestriction.Builder,
                  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                      .ActiveMetricRestrictionOrBuilder>(
                  activeMetricRestrictions_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          activeMetricRestrictions_ = null;
        }
        return activeMetricRestrictionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse)
    }

    // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse)
    private static final com.google.analytics.data.v1alpha.ResponseMetaData
            .SchemaRestrictionResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse();
    }

    public static com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SchemaRestrictionResponse> PARSER =
        new com.google.protobuf.AbstractParser<SchemaRestrictionResponse>() {
          @java.lang.Override
          public SchemaRestrictionResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SchemaRestrictionResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SchemaRestrictionResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DATA_LOSS_FROM_OTHER_ROW_FIELD_NUMBER = 3;
  private boolean dataLossFromOtherRow_ = false;
  /**
   *
   *
   * <pre>
   * If true, indicates some buckets of dimension combinations are rolled into
   * "(other)" row. This can happen for high cardinality reports.
   *
   * The metadata parameter dataLossFromOtherRow is populated based on the
   * aggregated data table used in the report. The parameter will be accurately
   * populated regardless of the filters and limits in the report.
   *
   * For example, the (other) row could be dropped from the report because the
   * request contains a filter on sessionSource = google. This parameter will
   * still be populated if data loss from other row was present in the input
   * aggregate data used to generate this report.
   *
   * To learn more, see [About the (other) row and data
   * sampling](https://support.google.com/analytics/answer/13208658#reports).
   * </pre>
   *
   * <code>bool data_loss_from_other_row = 3;</code>
   *
   * @return The dataLossFromOtherRow.
   */
  @java.lang.Override
  public boolean getDataLossFromOtherRow() {
    return dataLossFromOtherRow_;
  }

  public static final int SCHEMA_RESTRICTION_RESPONSE_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
      schemaRestrictionResponse_;
  /**
   *
   *
   * <pre>
   * Describes the schema restrictions actively enforced in creating this
   * report. To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
   * </code>
   *
   * @return Whether the schemaRestrictionResponse field is set.
   */
  @java.lang.Override
  public boolean hasSchemaRestrictionResponse() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Describes the schema restrictions actively enforced in creating this
   * report. To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
   * </code>
   *
   * @return The schemaRestrictionResponse.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
      getSchemaRestrictionResponse() {
    return schemaRestrictionResponse_ == null
        ? com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .getDefaultInstance()
        : schemaRestrictionResponse_;
  }
  /**
   *
   *
   * <pre>
   * Describes the schema restrictions actively enforced in creating this
   * report. To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponseOrBuilder
      getSchemaRestrictionResponseOrBuilder() {
    return schemaRestrictionResponse_ == null
        ? com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
            .getDefaultInstance()
        : schemaRestrictionResponse_;
  }

  public static final int CURRENCY_CODE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currencyCode_ = "";
  /**
   *
   *
   * <pre>
   * The currency code used in this report. Intended to be used in formatting
   * currency metrics like `purchaseRevenue` for visualization. If currency_code
   * was specified in the request, this response parameter will echo the request
   * parameter; otherwise, this response parameter is the property's current
   * currency_code.
   *
   * Currency codes are string encodings of currency types from the ISO 4217
   * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
   * "EUR", "JPY". To learn more, see
   * https://support.google.com/analytics/answer/9796179.
   * </pre>
   *
   * <code>optional string currency_code = 5;</code>
   *
   * @return Whether the currencyCode field is set.
   */
  @java.lang.Override
  public boolean hasCurrencyCode() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The currency code used in this report. Intended to be used in formatting
   * currency metrics like `purchaseRevenue` for visualization. If currency_code
   * was specified in the request, this response parameter will echo the request
   * parameter; otherwise, this response parameter is the property's current
   * currency_code.
   *
   * Currency codes are string encodings of currency types from the ISO 4217
   * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
   * "EUR", "JPY". To learn more, see
   * https://support.google.com/analytics/answer/9796179.
   * </pre>
   *
   * <code>optional string currency_code = 5;</code>
   *
   * @return The currencyCode.
   */
  @java.lang.Override
  public java.lang.String getCurrencyCode() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currencyCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The currency code used in this report. Intended to be used in formatting
   * currency metrics like `purchaseRevenue` for visualization. If currency_code
   * was specified in the request, this response parameter will echo the request
   * parameter; otherwise, this response parameter is the property's current
   * currency_code.
   *
   * Currency codes are string encodings of currency types from the ISO 4217
   * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
   * "EUR", "JPY". To learn more, see
   * https://support.google.com/analytics/answer/9796179.
   * </pre>
   *
   * <code>optional string currency_code = 5;</code>
   *
   * @return The bytes for currencyCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrencyCodeBytes() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currencyCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * The property's current timezone. Intended to be used to interpret
   * time-based dimensions like `hour` and `minute`. Formatted as strings from
   * the IANA Time Zone database (https://www.iana.org/time-zones); for example
   * "America/New_York" or "Asia/Tokyo".
   * </pre>
   *
   * <code>optional string time_zone = 6;</code>
   *
   * @return Whether the timeZone field is set.
   */
  @java.lang.Override
  public boolean hasTimeZone() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The property's current timezone. Intended to be used to interpret
   * time-based dimensions like `hour` and `minute`. Formatted as strings from
   * the IANA Time Zone database (https://www.iana.org/time-zones); for example
   * "America/New_York" or "Asia/Tokyo".
   * </pre>
   *
   * <code>optional string time_zone = 6;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The property's current timezone. Intended to be used to interpret
   * time-based dimensions like `hour` and `minute`. Formatted as strings from
   * the IANA Time Zone database (https://www.iana.org/time-zones); for example
   * "America/New_York" or "Asia/Tokyo".
   * </pre>
   *
   * <code>optional string time_zone = 6;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMPTY_REASON_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object emptyReason_ = "";
  /**
   *
   *
   * <pre>
   * If empty reason is specified, the report is empty for this reason.
   * </pre>
   *
   * <code>optional string empty_reason = 7;</code>
   *
   * @return Whether the emptyReason field is set.
   */
  @java.lang.Override
  public boolean hasEmptyReason() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * If empty reason is specified, the report is empty for this reason.
   * </pre>
   *
   * <code>optional string empty_reason = 7;</code>
   *
   * @return The emptyReason.
   */
  @java.lang.Override
  public java.lang.String getEmptyReason() {
    java.lang.Object ref = emptyReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      emptyReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If empty reason is specified, the report is empty for this reason.
   * </pre>
   *
   * <code>optional string empty_reason = 7;</code>
   *
   * @return The bytes for emptyReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEmptyReasonBytes() {
    java.lang.Object ref = emptyReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      emptyReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBJECT_TO_THRESHOLDING_FIELD_NUMBER = 8;
  private boolean subjectToThresholding_ = false;
  /**
   *
   *
   * <pre>
   * If `subjectToThresholding` is true, this report is subject to thresholding
   * and only returns data that meets the minimum aggregation thresholds. It is
   * possible for a request to be subject to thresholding thresholding and no
   * data is absent from the report, and this happens when all data is above the
   * thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About
   * Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * </pre>
   *
   * <code>optional bool subject_to_thresholding = 8;</code>
   *
   * @return Whether the subjectToThresholding field is set.
   */
  @java.lang.Override
  public boolean hasSubjectToThresholding() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * If `subjectToThresholding` is true, this report is subject to thresholding
   * and only returns data that meets the minimum aggregation thresholds. It is
   * possible for a request to be subject to thresholding thresholding and no
   * data is absent from the report, and this happens when all data is above the
   * thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About
   * Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * </pre>
   *
   * <code>optional bool subject_to_thresholding = 8;</code>
   *
   * @return The subjectToThresholding.
   */
  @java.lang.Override
  public boolean getSubjectToThresholding() {
    return subjectToThresholding_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataLossFromOtherRow_ != false) {
      output.writeBool(3, dataLossFromOtherRow_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getSchemaRestrictionResponse());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, currencyCode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, timeZone_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, emptyReason_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(8, subjectToThresholding_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataLossFromOtherRow_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, dataLossFromOtherRow_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getSchemaRestrictionResponse());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, currencyCode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, timeZone_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, emptyReason_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, subjectToThresholding_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.ResponseMetaData)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.ResponseMetaData other =
        (com.google.analytics.data.v1alpha.ResponseMetaData) obj;

    if (getDataLossFromOtherRow() != other.getDataLossFromOtherRow()) return false;
    if (hasSchemaRestrictionResponse() != other.hasSchemaRestrictionResponse()) return false;
    if (hasSchemaRestrictionResponse()) {
      if (!getSchemaRestrictionResponse().equals(other.getSchemaRestrictionResponse()))
        return false;
    }
    if (hasCurrencyCode() != other.hasCurrencyCode()) return false;
    if (hasCurrencyCode()) {
      if (!getCurrencyCode().equals(other.getCurrencyCode())) return false;
    }
    if (hasTimeZone() != other.hasTimeZone()) return false;
    if (hasTimeZone()) {
      if (!getTimeZone().equals(other.getTimeZone())) return false;
    }
    if (hasEmptyReason() != other.hasEmptyReason()) return false;
    if (hasEmptyReason()) {
      if (!getEmptyReason().equals(other.getEmptyReason())) return false;
    }
    if (hasSubjectToThresholding() != other.hasSubjectToThresholding()) return false;
    if (hasSubjectToThresholding()) {
      if (getSubjectToThresholding() != other.getSubjectToThresholding()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_LOSS_FROM_OTHER_ROW_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDataLossFromOtherRow());
    if (hasSchemaRestrictionResponse()) {
      hash = (37 * hash) + SCHEMA_RESTRICTION_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaRestrictionResponse().hashCode();
    }
    if (hasCurrencyCode()) {
      hash = (37 * hash) + CURRENCY_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrencyCode().hashCode();
    }
    if (hasTimeZone()) {
      hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getTimeZone().hashCode();
    }
    if (hasEmptyReason()) {
      hash = (37 * hash) + EMPTY_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getEmptyReason().hashCode();
    }
    if (hasSubjectToThresholding()) {
      hash = (37 * hash) + SUBJECT_TO_THRESHOLDING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSubjectToThresholding());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.ResponseMetaData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response's metadata carrying additional information about the report content.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.ResponseMetaData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.ResponseMetaData)
      com.google.analytics.data.v1alpha.ResponseMetaDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_ResponseMetaData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_ResponseMetaData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.ResponseMetaData.class,
              com.google.analytics.data.v1alpha.ResponseMetaData.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.ResponseMetaData.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSchemaRestrictionResponseFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataLossFromOtherRow_ = false;
      schemaRestrictionResponse_ = null;
      if (schemaRestrictionResponseBuilder_ != null) {
        schemaRestrictionResponseBuilder_.dispose();
        schemaRestrictionResponseBuilder_ = null;
      }
      currencyCode_ = "";
      timeZone_ = "";
      emptyReason_ = "";
      subjectToThresholding_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_ResponseMetaData_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ResponseMetaData getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.ResponseMetaData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ResponseMetaData build() {
      com.google.analytics.data.v1alpha.ResponseMetaData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ResponseMetaData buildPartial() {
      com.google.analytics.data.v1alpha.ResponseMetaData result =
          new com.google.analytics.data.v1alpha.ResponseMetaData(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.ResponseMetaData result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataLossFromOtherRow_ = dataLossFromOtherRow_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.schemaRestrictionResponse_ =
            schemaRestrictionResponseBuilder_ == null
                ? schemaRestrictionResponse_
                : schemaRestrictionResponseBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.currencyCode_ = currencyCode_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeZone_ = timeZone_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.emptyReason_ = emptyReason_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.subjectToThresholding_ = subjectToThresholding_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.ResponseMetaData) {
        return mergeFrom((com.google.analytics.data.v1alpha.ResponseMetaData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.ResponseMetaData other) {
      if (other == com.google.analytics.data.v1alpha.ResponseMetaData.getDefaultInstance())
        return this;
      if (other.getDataLossFromOtherRow() != false) {
        setDataLossFromOtherRow(other.getDataLossFromOtherRow());
      }
      if (other.hasSchemaRestrictionResponse()) {
        mergeSchemaRestrictionResponse(other.getSchemaRestrictionResponse());
      }
      if (other.hasCurrencyCode()) {
        currencyCode_ = other.currencyCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasTimeZone()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEmptyReason()) {
        emptyReason_ = other.emptyReason_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSubjectToThresholding()) {
        setSubjectToThresholding(other.getSubjectToThresholding());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 24:
              {
                dataLossFromOtherRow_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getSchemaRestrictionResponseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                currencyCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                emptyReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 64:
              {
                subjectToThresholding_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean dataLossFromOtherRow_;
    /**
     *
     *
     * <pre>
     * If true, indicates some buckets of dimension combinations are rolled into
     * "(other)" row. This can happen for high cardinality reports.
     *
     * The metadata parameter dataLossFromOtherRow is populated based on the
     * aggregated data table used in the report. The parameter will be accurately
     * populated regardless of the filters and limits in the report.
     *
     * For example, the (other) row could be dropped from the report because the
     * request contains a filter on sessionSource = google. This parameter will
     * still be populated if data loss from other row was present in the input
     * aggregate data used to generate this report.
     *
     * To learn more, see [About the (other) row and data
     * sampling](https://support.google.com/analytics/answer/13208658#reports).
     * </pre>
     *
     * <code>bool data_loss_from_other_row = 3;</code>
     *
     * @return The dataLossFromOtherRow.
     */
    @java.lang.Override
    public boolean getDataLossFromOtherRow() {
      return dataLossFromOtherRow_;
    }
    /**
     *
     *
     * <pre>
     * If true, indicates some buckets of dimension combinations are rolled into
     * "(other)" row. This can happen for high cardinality reports.
     *
     * The metadata parameter dataLossFromOtherRow is populated based on the
     * aggregated data table used in the report. The parameter will be accurately
     * populated regardless of the filters and limits in the report.
     *
     * For example, the (other) row could be dropped from the report because the
     * request contains a filter on sessionSource = google. This parameter will
     * still be populated if data loss from other row was present in the input
     * aggregate data used to generate this report.
     *
     * To learn more, see [About the (other) row and data
     * sampling](https://support.google.com/analytics/answer/13208658#reports).
     * </pre>
     *
     * <code>bool data_loss_from_other_row = 3;</code>
     *
     * @param value The dataLossFromOtherRow to set.
     * @return This builder for chaining.
     */
    public Builder setDataLossFromOtherRow(boolean value) {

      dataLossFromOtherRow_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, indicates some buckets of dimension combinations are rolled into
     * "(other)" row. This can happen for high cardinality reports.
     *
     * The metadata parameter dataLossFromOtherRow is populated based on the
     * aggregated data table used in the report. The parameter will be accurately
     * populated regardless of the filters and limits in the report.
     *
     * For example, the (other) row could be dropped from the report because the
     * request contains a filter on sessionSource = google. This parameter will
     * still be populated if data loss from other row was present in the input
     * aggregate data used to generate this report.
     *
     * To learn more, see [About the (other) row and data
     * sampling](https://support.google.com/analytics/answer/13208658#reports).
     * </pre>
     *
     * <code>bool data_loss_from_other_row = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataLossFromOtherRow() {
      bitField0_ = (bitField0_ & ~0x00000001);
      dataLossFromOtherRow_ = false;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        schemaRestrictionResponse_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse,
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.Builder,
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponseOrBuilder>
        schemaRestrictionResponseBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     *
     * @return Whether the schemaRestrictionResponse field is set.
     */
    public boolean hasSchemaRestrictionResponse() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     *
     * @return The schemaRestrictionResponse.
     */
    public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
        getSchemaRestrictionResponse() {
      if (schemaRestrictionResponseBuilder_ == null) {
        return schemaRestrictionResponse_ == null
            ? com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .getDefaultInstance()
            : schemaRestrictionResponse_;
      } else {
        return schemaRestrictionResponseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    public Builder setSchemaRestrictionResponse(
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse value) {
      if (schemaRestrictionResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaRestrictionResponse_ = value;
      } else {
        schemaRestrictionResponseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    public Builder setSchemaRestrictionResponse(
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.Builder
            builderForValue) {
      if (schemaRestrictionResponseBuilder_ == null) {
        schemaRestrictionResponse_ = builderForValue.build();
      } else {
        schemaRestrictionResponseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    public Builder mergeSchemaRestrictionResponse(
        com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse value) {
      if (schemaRestrictionResponseBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && schemaRestrictionResponse_ != null
            && schemaRestrictionResponse_
                != com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .getDefaultInstance()) {
          getSchemaRestrictionResponseBuilder().mergeFrom(value);
        } else {
          schemaRestrictionResponse_ = value;
        }
      } else {
        schemaRestrictionResponseBuilder_.mergeFrom(value);
      }
      if (schemaRestrictionResponse_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    public Builder clearSchemaRestrictionResponse() {
      bitField0_ = (bitField0_ & ~0x00000002);
      schemaRestrictionResponse_ = null;
      if (schemaRestrictionResponseBuilder_ != null) {
        schemaRestrictionResponseBuilder_.dispose();
        schemaRestrictionResponseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.Builder
        getSchemaRestrictionResponseBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSchemaRestrictionResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    public com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponseOrBuilder
        getSchemaRestrictionResponseOrBuilder() {
      if (schemaRestrictionResponseBuilder_ != null) {
        return schemaRestrictionResponseBuilder_.getMessageOrBuilder();
      } else {
        return schemaRestrictionResponse_ == null
            ? com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                .getDefaultInstance()
            : schemaRestrictionResponse_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the schema restrictions actively enforced in creating this
     * report. To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse,
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse.Builder,
            com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponseOrBuilder>
        getSchemaRestrictionResponseFieldBuilder() {
      if (schemaRestrictionResponseBuilder_ == null) {
        schemaRestrictionResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse,
                com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
                    .Builder,
                com.google.analytics.data.v1alpha.ResponseMetaData
                    .SchemaRestrictionResponseOrBuilder>(
                getSchemaRestrictionResponse(), getParentForChildren(), isClean());
        schemaRestrictionResponse_ = null;
      }
      return schemaRestrictionResponseBuilder_;
    }

    private java.lang.Object currencyCode_ = "";
    /**
     *
     *
     * <pre>
     * The currency code used in this report. Intended to be used in formatting
     * currency metrics like `purchaseRevenue` for visualization. If currency_code
     * was specified in the request, this response parameter will echo the request
     * parameter; otherwise, this response parameter is the property's current
     * currency_code.
     *
     * Currency codes are string encodings of currency types from the ISO 4217
     * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
     * "EUR", "JPY". To learn more, see
     * https://support.google.com/analytics/answer/9796179.
     * </pre>
     *
     * <code>optional string currency_code = 5;</code>
     *
     * @return Whether the currencyCode field is set.
     */
    public boolean hasCurrencyCode() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The currency code used in this report. Intended to be used in formatting
     * currency metrics like `purchaseRevenue` for visualization. If currency_code
     * was specified in the request, this response parameter will echo the request
     * parameter; otherwise, this response parameter is the property's current
     * currency_code.
     *
     * Currency codes are string encodings of currency types from the ISO 4217
     * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
     * "EUR", "JPY". To learn more, see
     * https://support.google.com/analytics/answer/9796179.
     * </pre>
     *
     * <code>optional string currency_code = 5;</code>
     *
     * @return The currencyCode.
     */
    public java.lang.String getCurrencyCode() {
      java.lang.Object ref = currencyCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currencyCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The currency code used in this report. Intended to be used in formatting
     * currency metrics like `purchaseRevenue` for visualization. If currency_code
     * was specified in the request, this response parameter will echo the request
     * parameter; otherwise, this response parameter is the property's current
     * currency_code.
     *
     * Currency codes are string encodings of currency types from the ISO 4217
     * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
     * "EUR", "JPY". To learn more, see
     * https://support.google.com/analytics/answer/9796179.
     * </pre>
     *
     * <code>optional string currency_code = 5;</code>
     *
     * @return The bytes for currencyCode.
     */
    public com.google.protobuf.ByteString getCurrencyCodeBytes() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currencyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The currency code used in this report. Intended to be used in formatting
     * currency metrics like `purchaseRevenue` for visualization. If currency_code
     * was specified in the request, this response parameter will echo the request
     * parameter; otherwise, this response parameter is the property's current
     * currency_code.
     *
     * Currency codes are string encodings of currency types from the ISO 4217
     * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
     * "EUR", "JPY". To learn more, see
     * https://support.google.com/analytics/answer/9796179.
     * </pre>
     *
     * <code>optional string currency_code = 5;</code>
     *
     * @param value The currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currencyCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The currency code used in this report. Intended to be used in formatting
     * currency metrics like `purchaseRevenue` for visualization. If currency_code
     * was specified in the request, this response parameter will echo the request
     * parameter; otherwise, this response parameter is the property's current
     * currency_code.
     *
     * Currency codes are string encodings of currency types from the ISO 4217
     * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
     * "EUR", "JPY". To learn more, see
     * https://support.google.com/analytics/answer/9796179.
     * </pre>
     *
     * <code>optional string currency_code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrencyCode() {
      currencyCode_ = getDefaultInstance().getCurrencyCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The currency code used in this report. Intended to be used in formatting
     * currency metrics like `purchaseRevenue` for visualization. If currency_code
     * was specified in the request, this response parameter will echo the request
     * parameter; otherwise, this response parameter is the property's current
     * currency_code.
     *
     * Currency codes are string encodings of currency types from the ISO 4217
     * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
     * "EUR", "JPY". To learn more, see
     * https://support.google.com/analytics/answer/9796179.
     * </pre>
     *
     * <code>optional string currency_code = 5;</code>
     *
     * @param value The bytes for currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currencyCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * The property's current timezone. Intended to be used to interpret
     * time-based dimensions like `hour` and `minute`. Formatted as strings from
     * the IANA Time Zone database (https://www.iana.org/time-zones); for example
     * "America/New_York" or "Asia/Tokyo".
     * </pre>
     *
     * <code>optional string time_zone = 6;</code>
     *
     * @return Whether the timeZone field is set.
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The property's current timezone. Intended to be used to interpret
     * time-based dimensions like `hour` and `minute`. Formatted as strings from
     * the IANA Time Zone database (https://www.iana.org/time-zones); for example
     * "America/New_York" or "Asia/Tokyo".
     * </pre>
     *
     * <code>optional string time_zone = 6;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The property's current timezone. Intended to be used to interpret
     * time-based dimensions like `hour` and `minute`. Formatted as strings from
     * the IANA Time Zone database (https://www.iana.org/time-zones); for example
     * "America/New_York" or "Asia/Tokyo".
     * </pre>
     *
     * <code>optional string time_zone = 6;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The property's current timezone. Intended to be used to interpret
     * time-based dimensions like `hour` and `minute`. Formatted as strings from
     * the IANA Time Zone database (https://www.iana.org/time-zones); for example
     * "America/New_York" or "Asia/Tokyo".
     * </pre>
     *
     * <code>optional string time_zone = 6;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The property's current timezone. Intended to be used to interpret
     * time-based dimensions like `hour` and `minute`. Formatted as strings from
     * the IANA Time Zone database (https://www.iana.org/time-zones); for example
     * "America/New_York" or "Asia/Tokyo".
     * </pre>
     *
     * <code>optional string time_zone = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The property's current timezone. Intended to be used to interpret
     * time-based dimensions like `hour` and `minute`. Formatted as strings from
     * the IANA Time Zone database (https://www.iana.org/time-zones); for example
     * "America/New_York" or "Asia/Tokyo".
     * </pre>
     *
     * <code>optional string time_zone = 6;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object emptyReason_ = "";
    /**
     *
     *
     * <pre>
     * If empty reason is specified, the report is empty for this reason.
     * </pre>
     *
     * <code>optional string empty_reason = 7;</code>
     *
     * @return Whether the emptyReason field is set.
     */
    public boolean hasEmptyReason() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * If empty reason is specified, the report is empty for this reason.
     * </pre>
     *
     * <code>optional string empty_reason = 7;</code>
     *
     * @return The emptyReason.
     */
    public java.lang.String getEmptyReason() {
      java.lang.Object ref = emptyReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        emptyReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If empty reason is specified, the report is empty for this reason.
     * </pre>
     *
     * <code>optional string empty_reason = 7;</code>
     *
     * @return The bytes for emptyReason.
     */
    public com.google.protobuf.ByteString getEmptyReasonBytes() {
      java.lang.Object ref = emptyReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        emptyReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If empty reason is specified, the report is empty for this reason.
     * </pre>
     *
     * <code>optional string empty_reason = 7;</code>
     *
     * @param value The emptyReason to set.
     * @return This builder for chaining.
     */
    public Builder setEmptyReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      emptyReason_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If empty reason is specified, the report is empty for this reason.
     * </pre>
     *
     * <code>optional string empty_reason = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmptyReason() {
      emptyReason_ = getDefaultInstance().getEmptyReason();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If empty reason is specified, the report is empty for this reason.
     * </pre>
     *
     * <code>optional string empty_reason = 7;</code>
     *
     * @param value The bytes for emptyReason to set.
     * @return This builder for chaining.
     */
    public Builder setEmptyReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      emptyReason_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean subjectToThresholding_;
    /**
     *
     *
     * <pre>
     * If `subjectToThresholding` is true, this report is subject to thresholding
     * and only returns data that meets the minimum aggregation thresholds. It is
     * possible for a request to be subject to thresholding thresholding and no
     * data is absent from the report, and this happens when all data is above the
     * thresholds. To learn more, see [Data
     * thresholds](https://support.google.com/analytics/answer/9383630) and [About
     * Demographics and
     * Interests](https://support.google.com/analytics/answer/2799357).
     * </pre>
     *
     * <code>optional bool subject_to_thresholding = 8;</code>
     *
     * @return Whether the subjectToThresholding field is set.
     */
    @java.lang.Override
    public boolean hasSubjectToThresholding() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * If `subjectToThresholding` is true, this report is subject to thresholding
     * and only returns data that meets the minimum aggregation thresholds. It is
     * possible for a request to be subject to thresholding thresholding and no
     * data is absent from the report, and this happens when all data is above the
     * thresholds. To learn more, see [Data
     * thresholds](https://support.google.com/analytics/answer/9383630) and [About
     * Demographics and
     * Interests](https://support.google.com/analytics/answer/2799357).
     * </pre>
     *
     * <code>optional bool subject_to_thresholding = 8;</code>
     *
     * @return The subjectToThresholding.
     */
    @java.lang.Override
    public boolean getSubjectToThresholding() {
      return subjectToThresholding_;
    }
    /**
     *
     *
     * <pre>
     * If `subjectToThresholding` is true, this report is subject to thresholding
     * and only returns data that meets the minimum aggregation thresholds. It is
     * possible for a request to be subject to thresholding thresholding and no
     * data is absent from the report, and this happens when all data is above the
     * thresholds. To learn more, see [Data
     * thresholds](https://support.google.com/analytics/answer/9383630) and [About
     * Demographics and
     * Interests](https://support.google.com/analytics/answer/2799357).
     * </pre>
     *
     * <code>optional bool subject_to_thresholding = 8;</code>
     *
     * @param value The subjectToThresholding to set.
     * @return This builder for chaining.
     */
    public Builder setSubjectToThresholding(boolean value) {

      subjectToThresholding_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `subjectToThresholding` is true, this report is subject to thresholding
     * and only returns data that meets the minimum aggregation thresholds. It is
     * possible for a request to be subject to thresholding thresholding and no
     * data is absent from the report, and this happens when all data is above the
     * thresholds. To learn more, see [Data
     * thresholds](https://support.google.com/analytics/answer/9383630) and [About
     * Demographics and
     * Interests](https://support.google.com/analytics/answer/2799357).
     * </pre>
     *
     * <code>optional bool subject_to_thresholding = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubjectToThresholding() {
      bitField0_ = (bitField0_ & ~0x00000020);
      subjectToThresholding_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.ResponseMetaData)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.ResponseMetaData)
  private static final com.google.analytics.data.v1alpha.ResponseMetaData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.ResponseMetaData();
  }

  public static com.google.analytics.data.v1alpha.ResponseMetaData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResponseMetaData> PARSER =
      new com.google.protobuf.AbstractParser<ResponseMetaData>() {
        @java.lang.Override
        public ResponseMetaData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResponseMetaData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResponseMetaData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.ResponseMetaData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
