/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.5
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * A specific report task configuration.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.ReportTask}
 */
public final class ReportTask extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.ReportTask)
    ReportTaskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportTask.newBuilder() to construct.
  private ReportTask(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportTask() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportTask();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_ReportTask_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_ReportTask_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.ReportTask.class,
            com.google.analytics.data.v1alpha.ReportTask.Builder.class);
  }

  public interface ReportDefinitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.ReportTask.ReportDefinition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.analytics.data.v1alpha.Dimension> getDimensionsList();
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.Dimension getDimensions(int index);
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getDimensionsCount();
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.analytics.data.v1alpha.DimensionOrBuilder>
        getDimensionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.DimensionOrBuilder getDimensionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.analytics.data.v1alpha.Metric> getMetricsList();
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.Metric getMetrics(int index);
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getMetricsCount();
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.analytics.data.v1alpha.MetricOrBuilder>
        getMetricsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.MetricOrBuilder getMetricsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.analytics.data.v1alpha.DateRange> getDateRangesList();
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.DateRange getDateRanges(int index);
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getDateRangesCount();
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.analytics.data.v1alpha.DateRangeOrBuilder>
        getDateRangesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.DateRangeOrBuilder getDateRangesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Dimension filters let you ask for only specific dimension
     * values in the report. To learn more, see [Fundamentals of Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dimensionFilter field is set.
     */
    boolean hasDimensionFilter();
    /**
     *
     *
     * <pre>
     * Optional. Dimension filters let you ask for only specific dimension
     * values in the report. To learn more, see [Fundamentals of Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dimensionFilter.
     */
    com.google.analytics.data.v1alpha.FilterExpression getDimensionFilter();
    /**
     *
     *
     * <pre>
     * Optional. Dimension filters let you ask for only specific dimension
     * values in the report. To learn more, see [Fundamentals of Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.FilterExpressionOrBuilder getDimensionFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The filter clause of metrics. Applied after aggregating the
     * report's rows, similar to SQL having-clause. Dimensions cannot be used in
     * this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the metricFilter field is set.
     */
    boolean hasMetricFilter();
    /**
     *
     *
     * <pre>
     * Optional. The filter clause of metrics. Applied after aggregating the
     * report's rows, similar to SQL having-clause. Dimensions cannot be used in
     * this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The metricFilter.
     */
    com.google.analytics.data.v1alpha.FilterExpression getMetricFilter();
    /**
     *
     *
     * <pre>
     * Optional. The filter clause of metrics. Applied after aggregating the
     * report's rows, similar to SQL having-clause. Dimensions cannot be used in
     * this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.FilterExpressionOrBuilder getMetricFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The row count of the start row from Google Analytics Storage.
     * The first row is counted as row 0.
     *
     * When creating a report task, the `offset` and `limit` parameters define
     * the subset of data rows from Google Analytics storage to be included in
     * the generated report. For example, if there are a total of 300,000 rows
     * in Google Analytics storage, the initial report task may have the
     * first 10,000 rows with a limit of 10,000 and an offset of 0.
     * Subsequently, another report task could cover the next 10,000 rows with a
     * limit of 10,000 and an offset of 10,000.
     * </pre>
     *
     * <code>int64 offset = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The offset.
     */
    long getOffset();

    /**
     *
     *
     * <pre>
     * Optional. The number of rows to return in the Report. If unspecified,
     * 10,000 rows are returned. The API returns a maximum of 250,000 rows per
     * request, no matter how many you ask for. `limit` must be positive.
     *
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`. For instance, there are
     * fewer than 300 possible values for the dimension `country`, so when
     * reporting on only `country`, you can't get more than 300 rows, even if
     * you set `limit` to a higher value.
     * </pre>
     *
     * <code>int64 limit = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The limit.
     */
    long getLimit();

    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the metricAggregations.
     */
    java.util.List<com.google.analytics.data.v1alpha.MetricAggregation> getMetricAggregationsList();
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of metricAggregations.
     */
    int getMetricAggregationsCount();
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The metricAggregations at the given index.
     */
    com.google.analytics.data.v1alpha.MetricAggregation getMetricAggregations(int index);
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for metricAggregations.
     */
    java.util.List<java.lang.Integer> getMetricAggregationsValueList();
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of metricAggregations at the given index.
     */
    int getMetricAggregationsValue(int index);

    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.analytics.data.v1alpha.OrderBy> getOrderBysList();
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.OrderBy getOrderBys(int index);
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getOrderBysCount();
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.analytics.data.v1alpha.OrderByOrBuilder>
        getOrderBysOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.OrderByOrBuilder getOrderBysOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
     * If the field is empty, the report uses the property's default currency.
     * </pre>
     *
     * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The currencyCode.
     */
    java.lang.String getCurrencyCode();
    /**
     *
     *
     * <pre>
     * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
     * If the field is empty, the report uses the property's default currency.
     * </pre>
     *
     * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for currencyCode.
     */
    com.google.protobuf.ByteString getCurrencyCodeBytes();

    /**
     *
     *
     * <pre>
     * Optional. Cohort group associated with this request. If there is a cohort
     * group in the request the 'cohort' dimension must be present.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cohortSpec field is set.
     */
    boolean hasCohortSpec();
    /**
     *
     *
     * <pre>
     * Optional. Cohort group associated with this request. If there is a cohort
     * group in the request the 'cohort' dimension must be present.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cohortSpec.
     */
    com.google.analytics.data.v1alpha.CohortSpec getCohortSpec();
    /**
     *
     *
     * <pre>
     * Optional. Cohort group associated with this request. If there is a cohort
     * group in the request the 'cohort' dimension must be present.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.analytics.data.v1alpha.CohortSpecOrBuilder getCohortSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. If false or unspecified, each row with all metrics equal to 0
     * will not be returned. If true, these rows will be returned if they are
     * not separately removed by a filter.
     *
     * Regardless of this `keep_empty_rows` setting, only data recorded by the
     * Google Analytics property can be displayed in a report.
     *
     * For example if a property never logs a `purchase` event, then a query for
     * the `eventName` dimension and  `eventCount` metric will not have a row
     * containing eventName: "purchase" and eventCount: 0.
     * </pre>
     *
     * <code>bool keep_empty_rows = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The keepEmptyRows.
     */
    boolean getKeepEmptyRows();

    /**
     *
     *
     * <pre>
     * Optional. The report's sampling level.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the samplingLevel field is set.
     */
    boolean hasSamplingLevel();
    /**
     *
     *
     * <pre>
     * Optional. The report's sampling level.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for samplingLevel.
     */
    int getSamplingLevelValue();
    /**
     *
     *
     * <pre>
     * Optional. The report's sampling level.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The samplingLevel.
     */
    com.google.analytics.data.v1alpha.SamplingLevel getSamplingLevel();
  }
  /**
   *
   *
   * <pre>
   * The definition of how a report should be run.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.ReportTask.ReportDefinition}
   */
  public static final class ReportDefinition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.ReportTask.ReportDefinition)
      ReportDefinitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReportDefinition.newBuilder() to construct.
    private ReportDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReportDefinition() {
      dimensions_ = java.util.Collections.emptyList();
      metrics_ = java.util.Collections.emptyList();
      dateRanges_ = java.util.Collections.emptyList();
      metricAggregations_ = java.util.Collections.emptyList();
      orderBys_ = java.util.Collections.emptyList();
      currencyCode_ = "";
      samplingLevel_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReportDefinition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_ReportDefinition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_ReportDefinition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.class,
              com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder.class);
    }

    private int bitField0_;
    public static final int DIMENSIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.analytics.data.v1alpha.Dimension> dimensions_;
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.analytics.data.v1alpha.Dimension> getDimensionsList() {
      return dimensions_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.analytics.data.v1alpha.DimensionOrBuilder>
        getDimensionsOrBuilderList() {
      return dimensions_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getDimensionsCount() {
      return dimensions_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.Dimension getDimensions(int index) {
      return dimensions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The dimensions requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.DimensionOrBuilder getDimensionsOrBuilder(int index) {
      return dimensions_.get(index);
    }

    public static final int METRICS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.analytics.data.v1alpha.Metric> metrics_;
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.analytics.data.v1alpha.Metric> getMetricsList() {
      return metrics_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.analytics.data.v1alpha.MetricOrBuilder>
        getMetricsOrBuilderList() {
      return metrics_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getMetricsCount() {
      return metrics_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.Metric getMetrics(int index) {
      return metrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The metrics requested and displayed.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.MetricOrBuilder getMetricsOrBuilder(int index) {
      return metrics_.get(index);
    }

    public static final int DATE_RANGES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.analytics.data.v1alpha.DateRange> dateRanges_;
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.analytics.data.v1alpha.DateRange> getDateRangesList() {
      return dateRanges_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.analytics.data.v1alpha.DateRangeOrBuilder>
        getDateRangesOrBuilderList() {
      return dateRanges_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getDateRangesCount() {
      return dateRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.DateRange getDateRanges(int index) {
      return dateRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Date ranges of data to read. If multiple date ranges are
     * requested, each response row will contain a zero based date range index.
     * If two date ranges overlap, the event data for the overlapping days is
     * included in the response rows for both date ranges. In a cohort request,
     * this `dateRanges` must be unspecified.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.DateRangeOrBuilder getDateRangesOrBuilder(int index) {
      return dateRanges_.get(index);
    }

    public static final int DIMENSION_FILTER_FIELD_NUMBER = 5;
    private com.google.analytics.data.v1alpha.FilterExpression dimensionFilter_;
    /**
     *
     *
     * <pre>
     * Optional. Dimension filters let you ask for only specific dimension
     * values in the report. To learn more, see [Fundamentals of Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dimensionFilter field is set.
     */
    @java.lang.Override
    public boolean hasDimensionFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Dimension filters let you ask for only specific dimension
     * values in the report. To learn more, see [Fundamentals of Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dimensionFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.FilterExpression getDimensionFilter() {
      return dimensionFilter_ == null
          ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
          : dimensionFilter_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Dimension filters let you ask for only specific dimension
     * values in the report. To learn more, see [Fundamentals of Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.FilterExpressionOrBuilder
        getDimensionFilterOrBuilder() {
      return dimensionFilter_ == null
          ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
          : dimensionFilter_;
    }

    public static final int METRIC_FILTER_FIELD_NUMBER = 6;
    private com.google.analytics.data.v1alpha.FilterExpression metricFilter_;
    /**
     *
     *
     * <pre>
     * Optional. The filter clause of metrics. Applied after aggregating the
     * report's rows, similar to SQL having-clause. Dimensions cannot be used in
     * this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the metricFilter field is set.
     */
    @java.lang.Override
    public boolean hasMetricFilter() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The filter clause of metrics. Applied after aggregating the
     * report's rows, similar to SQL having-clause. Dimensions cannot be used in
     * this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The metricFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.FilterExpression getMetricFilter() {
      return metricFilter_ == null
          ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
          : metricFilter_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The filter clause of metrics. Applied after aggregating the
     * report's rows, similar to SQL having-clause. Dimensions cannot be used in
     * this filter.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.FilterExpressionOrBuilder getMetricFilterOrBuilder() {
      return metricFilter_ == null
          ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
          : metricFilter_;
    }

    public static final int OFFSET_FIELD_NUMBER = 7;
    private long offset_ = 0L;
    /**
     *
     *
     * <pre>
     * Optional. The row count of the start row from Google Analytics Storage.
     * The first row is counted as row 0.
     *
     * When creating a report task, the `offset` and `limit` parameters define
     * the subset of data rows from Google Analytics storage to be included in
     * the generated report. For example, if there are a total of 300,000 rows
     * in Google Analytics storage, the initial report task may have the
     * first 10,000 rows with a limit of 10,000 and an offset of 0.
     * Subsequently, another report task could cover the next 10,000 rows with a
     * limit of 10,000 and an offset of 10,000.
     * </pre>
     *
     * <code>int64 offset = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public long getOffset() {
      return offset_;
    }

    public static final int LIMIT_FIELD_NUMBER = 8;
    private long limit_ = 0L;
    /**
     *
     *
     * <pre>
     * Optional. The number of rows to return in the Report. If unspecified,
     * 10,000 rows are returned. The API returns a maximum of 250,000 rows per
     * request, no matter how many you ask for. `limit` must be positive.
     *
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`. For instance, there are
     * fewer than 300 possible values for the dimension `country`, so when
     * reporting on only `country`, you can't get more than 300 rows, even if
     * you set `limit` to a higher value.
     * </pre>
     *
     * <code>int64 limit = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public long getLimit() {
      return limit_;
    }

    public static final int METRIC_AGGREGATIONS_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> metricAggregations_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.analytics.data.v1alpha.MetricAggregation>
        metricAggregations_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.analytics.data.v1alpha.MetricAggregation>() {
              public com.google.analytics.data.v1alpha.MetricAggregation convert(
                  java.lang.Integer from) {
                com.google.analytics.data.v1alpha.MetricAggregation result =
                    com.google.analytics.data.v1alpha.MetricAggregation.forNumber(from);
                return result == null
                    ? com.google.analytics.data.v1alpha.MetricAggregation.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the metricAggregations.
     */
    @java.lang.Override
    public java.util.List<com.google.analytics.data.v1alpha.MetricAggregation>
        getMetricAggregationsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.analytics.data.v1alpha.MetricAggregation>(
          metricAggregations_, metricAggregations_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of metricAggregations.
     */
    @java.lang.Override
    public int getMetricAggregationsCount() {
      return metricAggregations_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The metricAggregations at the given index.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.MetricAggregation getMetricAggregations(int index) {
      return metricAggregations_converter_.convert(metricAggregations_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for metricAggregations.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getMetricAggregationsValueList() {
      return metricAggregations_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Aggregation of metrics. Aggregated metric values will be shown
     * in rows where the dimension_values are set to
     * "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of metricAggregations at the given index.
     */
    @java.lang.Override
    public int getMetricAggregationsValue(int index) {
      return metricAggregations_.get(index);
    }

    private int metricAggregationsMemoizedSerializedSize;

    public static final int ORDER_BYS_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private java.util.List<com.google.analytics.data.v1alpha.OrderBy> orderBys_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.analytics.data.v1alpha.OrderBy> getOrderBysList() {
      return orderBys_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.analytics.data.v1alpha.OrderByOrBuilder>
        getOrderBysOrBuilderList() {
      return orderBys_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getOrderBysCount() {
      return orderBys_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.OrderBy getOrderBys(int index) {
      return orderBys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.OrderByOrBuilder getOrderBysOrBuilder(int index) {
      return orderBys_.get(index);
    }

    public static final int CURRENCY_CODE_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private volatile java.lang.Object currencyCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
     * If the field is empty, the report uses the property's default currency.
     * </pre>
     *
     * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The currencyCode.
     */
    @java.lang.Override
    public java.lang.String getCurrencyCode() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currencyCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
     * If the field is empty, the report uses the property's default currency.
     * </pre>
     *
     * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for currencyCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCurrencyCodeBytes() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currencyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COHORT_SPEC_FIELD_NUMBER = 12;
    private com.google.analytics.data.v1alpha.CohortSpec cohortSpec_;
    /**
     *
     *
     * <pre>
     * Optional. Cohort group associated with this request. If there is a cohort
     * group in the request the 'cohort' dimension must be present.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cohortSpec field is set.
     */
    @java.lang.Override
    public boolean hasCohortSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Cohort group associated with this request. If there is a cohort
     * group in the request the 'cohort' dimension must be present.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cohortSpec.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.CohortSpec getCohortSpec() {
      return cohortSpec_ == null
          ? com.google.analytics.data.v1alpha.CohortSpec.getDefaultInstance()
          : cohortSpec_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cohort group associated with this request. If there is a cohort
     * group in the request the 'cohort' dimension must be present.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.CohortSpecOrBuilder getCohortSpecOrBuilder() {
      return cohortSpec_ == null
          ? com.google.analytics.data.v1alpha.CohortSpec.getDefaultInstance()
          : cohortSpec_;
    }

    public static final int KEEP_EMPTY_ROWS_FIELD_NUMBER = 13;
    private boolean keepEmptyRows_ = false;
    /**
     *
     *
     * <pre>
     * Optional. If false or unspecified, each row with all metrics equal to 0
     * will not be returned. If true, these rows will be returned if they are
     * not separately removed by a filter.
     *
     * Regardless of this `keep_empty_rows` setting, only data recorded by the
     * Google Analytics property can be displayed in a report.
     *
     * For example if a property never logs a `purchase` event, then a query for
     * the `eventName` dimension and  `eventCount` metric will not have a row
     * containing eventName: "purchase" and eventCount: 0.
     * </pre>
     *
     * <code>bool keep_empty_rows = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The keepEmptyRows.
     */
    @java.lang.Override
    public boolean getKeepEmptyRows() {
      return keepEmptyRows_;
    }

    public static final int SAMPLING_LEVEL_FIELD_NUMBER = 14;
    private int samplingLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The report's sampling level.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the samplingLevel field is set.
     */
    @java.lang.Override
    public boolean hasSamplingLevel() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The report's sampling level.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for samplingLevel.
     */
    @java.lang.Override
    public int getSamplingLevelValue() {
      return samplingLevel_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The report's sampling level.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The samplingLevel.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.SamplingLevel getSamplingLevel() {
      com.google.analytics.data.v1alpha.SamplingLevel result =
          com.google.analytics.data.v1alpha.SamplingLevel.forNumber(samplingLevel_);
      return result == null ? com.google.analytics.data.v1alpha.SamplingLevel.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < dimensions_.size(); i++) {
        output.writeMessage(2, dimensions_.get(i));
      }
      for (int i = 0; i < metrics_.size(); i++) {
        output.writeMessage(3, metrics_.get(i));
      }
      for (int i = 0; i < dateRanges_.size(); i++) {
        output.writeMessage(4, dateRanges_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getDimensionFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(6, getMetricFilter());
      }
      if (offset_ != 0L) {
        output.writeInt64(7, offset_);
      }
      if (limit_ != 0L) {
        output.writeInt64(8, limit_);
      }
      if (getMetricAggregationsList().size() > 0) {
        output.writeUInt32NoTag(74);
        output.writeUInt32NoTag(metricAggregationsMemoizedSerializedSize);
      }
      for (int i = 0; i < metricAggregations_.size(); i++) {
        output.writeEnumNoTag(metricAggregations_.get(i));
      }
      for (int i = 0; i < orderBys_.size(); i++) {
        output.writeMessage(10, orderBys_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currencyCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, currencyCode_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(12, getCohortSpec());
      }
      if (keepEmptyRows_ != false) {
        output.writeBool(13, keepEmptyRows_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeEnum(14, samplingLevel_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dimensions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dimensions_.get(i));
      }
      for (int i = 0; i < metrics_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metrics_.get(i));
      }
      for (int i = 0; i < dateRanges_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, dateRanges_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDimensionFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetricFilter());
      }
      if (offset_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, offset_);
      }
      if (limit_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, limit_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < metricAggregations_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  metricAggregations_.get(i));
        }
        size += dataSize;
        if (!getMetricAggregationsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        metricAggregationsMemoizedSerializedSize = dataSize;
      }
      for (int i = 0; i < orderBys_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, orderBys_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currencyCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, currencyCode_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCohortSpec());
      }
      if (keepEmptyRows_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, keepEmptyRows_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, samplingLevel_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.analytics.data.v1alpha.ReportTask.ReportDefinition)) {
        return super.equals(obj);
      }
      com.google.analytics.data.v1alpha.ReportTask.ReportDefinition other =
          (com.google.analytics.data.v1alpha.ReportTask.ReportDefinition) obj;

      if (!getDimensionsList().equals(other.getDimensionsList())) return false;
      if (!getMetricsList().equals(other.getMetricsList())) return false;
      if (!getDateRangesList().equals(other.getDateRangesList())) return false;
      if (hasDimensionFilter() != other.hasDimensionFilter()) return false;
      if (hasDimensionFilter()) {
        if (!getDimensionFilter().equals(other.getDimensionFilter())) return false;
      }
      if (hasMetricFilter() != other.hasMetricFilter()) return false;
      if (hasMetricFilter()) {
        if (!getMetricFilter().equals(other.getMetricFilter())) return false;
      }
      if (getOffset() != other.getOffset()) return false;
      if (getLimit() != other.getLimit()) return false;
      if (!metricAggregations_.equals(other.metricAggregations_)) return false;
      if (!getOrderBysList().equals(other.getOrderBysList())) return false;
      if (!getCurrencyCode().equals(other.getCurrencyCode())) return false;
      if (hasCohortSpec() != other.hasCohortSpec()) return false;
      if (hasCohortSpec()) {
        if (!getCohortSpec().equals(other.getCohortSpec())) return false;
      }
      if (getKeepEmptyRows() != other.getKeepEmptyRows()) return false;
      if (hasSamplingLevel() != other.hasSamplingLevel()) return false;
      if (hasSamplingLevel()) {
        if (samplingLevel_ != other.samplingLevel_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDimensionsCount() > 0) {
        hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDimensionsList().hashCode();
      }
      if (getMetricsCount() > 0) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetricsList().hashCode();
      }
      if (getDateRangesCount() > 0) {
        hash = (37 * hash) + DATE_RANGES_FIELD_NUMBER;
        hash = (53 * hash) + getDateRangesList().hashCode();
      }
      if (hasDimensionFilter()) {
        hash = (37 * hash) + DIMENSION_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getDimensionFilter().hashCode();
      }
      if (hasMetricFilter()) {
        hash = (37 * hash) + METRIC_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getMetricFilter().hashCode();
      }
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOffset());
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLimit());
      if (getMetricAggregationsCount() > 0) {
        hash = (37 * hash) + METRIC_AGGREGATIONS_FIELD_NUMBER;
        hash = (53 * hash) + metricAggregations_.hashCode();
      }
      if (getOrderBysCount() > 0) {
        hash = (37 * hash) + ORDER_BYS_FIELD_NUMBER;
        hash = (53 * hash) + getOrderBysList().hashCode();
      }
      hash = (37 * hash) + CURRENCY_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrencyCode().hashCode();
      if (hasCohortSpec()) {
        hash = (37 * hash) + COHORT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getCohortSpec().hashCode();
      }
      hash = (37 * hash) + KEEP_EMPTY_ROWS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getKeepEmptyRows());
      if (hasSamplingLevel()) {
        hash = (37 * hash) + SAMPLING_LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + samplingLevel_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The definition of how a report should be run.
     * </pre>
     *
     * Protobuf type {@code google.analytics.data.v1alpha.ReportTask.ReportDefinition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.ReportTask.ReportDefinition)
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
            .internal_static_google_analytics_data_v1alpha_ReportTask_ReportDefinition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
            .internal_static_google_analytics_data_v1alpha_ReportTask_ReportDefinition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.class,
                com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder.class);
      }

      // Construct using com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDimensionsFieldBuilder();
          getMetricsFieldBuilder();
          getDateRangesFieldBuilder();
          getDimensionFilterFieldBuilder();
          getMetricFilterFieldBuilder();
          getOrderBysFieldBuilder();
          getCohortSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dimensionsBuilder_ == null) {
          dimensions_ = java.util.Collections.emptyList();
        } else {
          dimensions_ = null;
          dimensionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (metricsBuilder_ == null) {
          metrics_ = java.util.Collections.emptyList();
        } else {
          metrics_ = null;
          metricsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (dateRangesBuilder_ == null) {
          dateRanges_ = java.util.Collections.emptyList();
        } else {
          dateRanges_ = null;
          dateRangesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        dimensionFilter_ = null;
        if (dimensionFilterBuilder_ != null) {
          dimensionFilterBuilder_.dispose();
          dimensionFilterBuilder_ = null;
        }
        metricFilter_ = null;
        if (metricFilterBuilder_ != null) {
          metricFilterBuilder_.dispose();
          metricFilterBuilder_ = null;
        }
        offset_ = 0L;
        limit_ = 0L;
        metricAggregations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        if (orderBysBuilder_ == null) {
          orderBys_ = java.util.Collections.emptyList();
        } else {
          orderBys_ = null;
          orderBysBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        currencyCode_ = "";
        cohortSpec_ = null;
        if (cohortSpecBuilder_ != null) {
          cohortSpecBuilder_.dispose();
          cohortSpecBuilder_ = null;
        }
        keepEmptyRows_ = false;
        samplingLevel_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
            .internal_static_google_analytics_data_v1alpha_ReportTask_ReportDefinition_descriptor;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition
          getDefaultInstanceForType() {
        return com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition build() {
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition buildPartial() {
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinition result =
            new com.google.analytics.data.v1alpha.ReportTask.ReportDefinition(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.analytics.data.v1alpha.ReportTask.ReportDefinition result) {
        if (dimensionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dimensions_ = dimensions_;
        } else {
          result.dimensions_ = dimensionsBuilder_.build();
        }
        if (metricsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            metrics_ = java.util.Collections.unmodifiableList(metrics_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.metrics_ = metrics_;
        } else {
          result.metrics_ = metricsBuilder_.build();
        }
        if (dateRangesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            dateRanges_ = java.util.Collections.unmodifiableList(dateRanges_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.dateRanges_ = dateRanges_;
        } else {
          result.dateRanges_ = dateRangesBuilder_.build();
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          metricAggregations_ = java.util.Collections.unmodifiableList(metricAggregations_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.metricAggregations_ = metricAggregations_;
        if (orderBysBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)) {
            orderBys_ = java.util.Collections.unmodifiableList(orderBys_);
            bitField0_ = (bitField0_ & ~0x00000100);
          }
          result.orderBys_ = orderBys_;
        } else {
          result.orderBys_ = orderBysBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.analytics.data.v1alpha.ReportTask.ReportDefinition result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.dimensionFilter_ =
              dimensionFilterBuilder_ == null ? dimensionFilter_ : dimensionFilterBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.metricFilter_ =
              metricFilterBuilder_ == null ? metricFilter_ : metricFilterBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.offset_ = offset_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.limit_ = limit_;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.currencyCode_ = currencyCode_;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.cohortSpec_ =
              cohortSpecBuilder_ == null ? cohortSpec_ : cohortSpecBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.keepEmptyRows_ = keepEmptyRows_;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.samplingLevel_ = samplingLevel_;
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.analytics.data.v1alpha.ReportTask.ReportDefinition) {
          return mergeFrom((com.google.analytics.data.v1alpha.ReportTask.ReportDefinition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.analytics.data.v1alpha.ReportTask.ReportDefinition other) {
        if (other
            == com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.getDefaultInstance())
          return this;
        if (dimensionsBuilder_ == null) {
          if (!other.dimensions_.isEmpty()) {
            if (dimensions_.isEmpty()) {
              dimensions_ = other.dimensions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDimensionsIsMutable();
              dimensions_.addAll(other.dimensions_);
            }
            onChanged();
          }
        } else {
          if (!other.dimensions_.isEmpty()) {
            if (dimensionsBuilder_.isEmpty()) {
              dimensionsBuilder_.dispose();
              dimensionsBuilder_ = null;
              dimensions_ = other.dimensions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dimensionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDimensionsFieldBuilder()
                      : null;
            } else {
              dimensionsBuilder_.addAllMessages(other.dimensions_);
            }
          }
        }
        if (metricsBuilder_ == null) {
          if (!other.metrics_.isEmpty()) {
            if (metrics_.isEmpty()) {
              metrics_ = other.metrics_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureMetricsIsMutable();
              metrics_.addAll(other.metrics_);
            }
            onChanged();
          }
        } else {
          if (!other.metrics_.isEmpty()) {
            if (metricsBuilder_.isEmpty()) {
              metricsBuilder_.dispose();
              metricsBuilder_ = null;
              metrics_ = other.metrics_;
              bitField0_ = (bitField0_ & ~0x00000002);
              metricsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMetricsFieldBuilder()
                      : null;
            } else {
              metricsBuilder_.addAllMessages(other.metrics_);
            }
          }
        }
        if (dateRangesBuilder_ == null) {
          if (!other.dateRanges_.isEmpty()) {
            if (dateRanges_.isEmpty()) {
              dateRanges_ = other.dateRanges_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDateRangesIsMutable();
              dateRanges_.addAll(other.dateRanges_);
            }
            onChanged();
          }
        } else {
          if (!other.dateRanges_.isEmpty()) {
            if (dateRangesBuilder_.isEmpty()) {
              dateRangesBuilder_.dispose();
              dateRangesBuilder_ = null;
              dateRanges_ = other.dateRanges_;
              bitField0_ = (bitField0_ & ~0x00000004);
              dateRangesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDateRangesFieldBuilder()
                      : null;
            } else {
              dateRangesBuilder_.addAllMessages(other.dateRanges_);
            }
          }
        }
        if (other.hasDimensionFilter()) {
          mergeDimensionFilter(other.getDimensionFilter());
        }
        if (other.hasMetricFilter()) {
          mergeMetricFilter(other.getMetricFilter());
        }
        if (other.getOffset() != 0L) {
          setOffset(other.getOffset());
        }
        if (other.getLimit() != 0L) {
          setLimit(other.getLimit());
        }
        if (!other.metricAggregations_.isEmpty()) {
          if (metricAggregations_.isEmpty()) {
            metricAggregations_ = other.metricAggregations_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureMetricAggregationsIsMutable();
            metricAggregations_.addAll(other.metricAggregations_);
          }
          onChanged();
        }
        if (orderBysBuilder_ == null) {
          if (!other.orderBys_.isEmpty()) {
            if (orderBys_.isEmpty()) {
              orderBys_ = other.orderBys_;
              bitField0_ = (bitField0_ & ~0x00000100);
            } else {
              ensureOrderBysIsMutable();
              orderBys_.addAll(other.orderBys_);
            }
            onChanged();
          }
        } else {
          if (!other.orderBys_.isEmpty()) {
            if (orderBysBuilder_.isEmpty()) {
              orderBysBuilder_.dispose();
              orderBysBuilder_ = null;
              orderBys_ = other.orderBys_;
              bitField0_ = (bitField0_ & ~0x00000100);
              orderBysBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getOrderBysFieldBuilder()
                      : null;
            } else {
              orderBysBuilder_.addAllMessages(other.orderBys_);
            }
          }
        }
        if (!other.getCurrencyCode().isEmpty()) {
          currencyCode_ = other.currencyCode_;
          bitField0_ |= 0x00000200;
          onChanged();
        }
        if (other.hasCohortSpec()) {
          mergeCohortSpec(other.getCohortSpec());
        }
        if (other.getKeepEmptyRows() != false) {
          setKeepEmptyRows(other.getKeepEmptyRows());
        }
        if (other.hasSamplingLevel()) {
          setSamplingLevel(other.getSamplingLevel());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  com.google.analytics.data.v1alpha.Dimension m =
                      input.readMessage(
                          com.google.analytics.data.v1alpha.Dimension.parser(), extensionRegistry);
                  if (dimensionsBuilder_ == null) {
                    ensureDimensionsIsMutable();
                    dimensions_.add(m);
                  } else {
                    dimensionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  com.google.analytics.data.v1alpha.Metric m =
                      input.readMessage(
                          com.google.analytics.data.v1alpha.Metric.parser(), extensionRegistry);
                  if (metricsBuilder_ == null) {
                    ensureMetricsIsMutable();
                    metrics_.add(m);
                  } else {
                    metricsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  com.google.analytics.data.v1alpha.DateRange m =
                      input.readMessage(
                          com.google.analytics.data.v1alpha.DateRange.parser(), extensionRegistry);
                  if (dateRangesBuilder_ == null) {
                    ensureDateRangesIsMutable();
                    dateRanges_.add(m);
                  } else {
                    dateRangesBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getDimensionFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getMetricFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 50
              case 56:
                {
                  offset_ = input.readInt64();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 56
              case 64:
                {
                  limit_ = input.readInt64();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 64
              case 72:
                {
                  int tmpRaw = input.readEnum();
                  ensureMetricAggregationsIsMutable();
                  metricAggregations_.add(tmpRaw);
                  break;
                } // case 72
              case 74:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureMetricAggregationsIsMutable();
                    metricAggregations_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 74
              case 82:
                {
                  com.google.analytics.data.v1alpha.OrderBy m =
                      input.readMessage(
                          com.google.analytics.data.v1alpha.OrderBy.parser(), extensionRegistry);
                  if (orderBysBuilder_ == null) {
                    ensureOrderBysIsMutable();
                    orderBys_.add(m);
                  } else {
                    orderBysBuilder_.addMessage(m);
                  }
                  break;
                } // case 82
              case 90:
                {
                  currencyCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000200;
                  break;
                } // case 90
              case 98:
                {
                  input.readMessage(getCohortSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000400;
                  break;
                } // case 98
              case 104:
                {
                  keepEmptyRows_ = input.readBool();
                  bitField0_ |= 0x00000800;
                  break;
                } // case 104
              case 112:
                {
                  samplingLevel_ = input.readEnum();
                  bitField0_ |= 0x00001000;
                  break;
                } // case 112
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.analytics.data.v1alpha.Dimension> dimensions_ =
          java.util.Collections.emptyList();

      private void ensureDimensionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dimensions_ =
              new java.util.ArrayList<com.google.analytics.data.v1alpha.Dimension>(dimensions_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.Dimension,
              com.google.analytics.data.v1alpha.Dimension.Builder,
              com.google.analytics.data.v1alpha.DimensionOrBuilder>
          dimensionsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.Dimension> getDimensionsList() {
        if (dimensionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dimensions_);
        } else {
          return dimensionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getDimensionsCount() {
        if (dimensionsBuilder_ == null) {
          return dimensions_.size();
        } else {
          return dimensionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Dimension getDimensions(int index) {
        if (dimensionsBuilder_ == null) {
          return dimensions_.get(index);
        } else {
          return dimensionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDimensions(int index, com.google.analytics.data.v1alpha.Dimension value) {
        if (dimensionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDimensionsIsMutable();
          dimensions_.set(index, value);
          onChanged();
        } else {
          dimensionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDimensions(
          int index, com.google.analytics.data.v1alpha.Dimension.Builder builderForValue) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.set(index, builderForValue.build());
          onChanged();
        } else {
          dimensionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDimensions(com.google.analytics.data.v1alpha.Dimension value) {
        if (dimensionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDimensionsIsMutable();
          dimensions_.add(value);
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDimensions(int index, com.google.analytics.data.v1alpha.Dimension value) {
        if (dimensionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDimensionsIsMutable();
          dimensions_.add(index, value);
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDimensions(
          com.google.analytics.data.v1alpha.Dimension.Builder builderForValue) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.add(builderForValue.build());
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDimensions(
          int index, com.google.analytics.data.v1alpha.Dimension.Builder builderForValue) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.add(index, builderForValue.build());
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllDimensions(
          java.lang.Iterable<? extends com.google.analytics.data.v1alpha.Dimension> values) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
          onChanged();
        } else {
          dimensionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDimensions() {
        if (dimensionsBuilder_ == null) {
          dimensions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dimensionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeDimensions(int index) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.remove(index);
          onChanged();
        } else {
          dimensionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Dimension.Builder getDimensionsBuilder(int index) {
        return getDimensionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.DimensionOrBuilder getDimensionsOrBuilder(
          int index) {
        if (dimensionsBuilder_ == null) {
          return dimensions_.get(index);
        } else {
          return dimensionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.analytics.data.v1alpha.DimensionOrBuilder>
          getDimensionsOrBuilderList() {
        if (dimensionsBuilder_ != null) {
          return dimensionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dimensions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Dimension.Builder addDimensionsBuilder() {
        return getDimensionsFieldBuilder()
            .addBuilder(com.google.analytics.data.v1alpha.Dimension.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Dimension.Builder addDimensionsBuilder(int index) {
        return getDimensionsFieldBuilder()
            .addBuilder(index, com.google.analytics.data.v1alpha.Dimension.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. The dimensions requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Dimension dimensions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.Dimension.Builder>
          getDimensionsBuilderList() {
        return getDimensionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.Dimension,
              com.google.analytics.data.v1alpha.Dimension.Builder,
              com.google.analytics.data.v1alpha.DimensionOrBuilder>
          getDimensionsFieldBuilder() {
        if (dimensionsBuilder_ == null) {
          dimensionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.analytics.data.v1alpha.Dimension,
                  com.google.analytics.data.v1alpha.Dimension.Builder,
                  com.google.analytics.data.v1alpha.DimensionOrBuilder>(
                  dimensions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          dimensions_ = null;
        }
        return dimensionsBuilder_;
      }

      private java.util.List<com.google.analytics.data.v1alpha.Metric> metrics_ =
          java.util.Collections.emptyList();

      private void ensureMetricsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          metrics_ = new java.util.ArrayList<com.google.analytics.data.v1alpha.Metric>(metrics_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.Metric,
              com.google.analytics.data.v1alpha.Metric.Builder,
              com.google.analytics.data.v1alpha.MetricOrBuilder>
          metricsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.Metric> getMetricsList() {
        if (metricsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(metrics_);
        } else {
          return metricsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getMetricsCount() {
        if (metricsBuilder_ == null) {
          return metrics_.size();
        } else {
          return metricsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Metric getMetrics(int index) {
        if (metricsBuilder_ == null) {
          return metrics_.get(index);
        } else {
          return metricsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMetrics(int index, com.google.analytics.data.v1alpha.Metric value) {
        if (metricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMetricsIsMutable();
          metrics_.set(index, value);
          onChanged();
        } else {
          metricsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMetrics(
          int index, com.google.analytics.data.v1alpha.Metric.Builder builderForValue) {
        if (metricsBuilder_ == null) {
          ensureMetricsIsMutable();
          metrics_.set(index, builderForValue.build());
          onChanged();
        } else {
          metricsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMetrics(com.google.analytics.data.v1alpha.Metric value) {
        if (metricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMetricsIsMutable();
          metrics_.add(value);
          onChanged();
        } else {
          metricsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMetrics(int index, com.google.analytics.data.v1alpha.Metric value) {
        if (metricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMetricsIsMutable();
          metrics_.add(index, value);
          onChanged();
        } else {
          metricsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMetrics(com.google.analytics.data.v1alpha.Metric.Builder builderForValue) {
        if (metricsBuilder_ == null) {
          ensureMetricsIsMutable();
          metrics_.add(builderForValue.build());
          onChanged();
        } else {
          metricsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMetrics(
          int index, com.google.analytics.data.v1alpha.Metric.Builder builderForValue) {
        if (metricsBuilder_ == null) {
          ensureMetricsIsMutable();
          metrics_.add(index, builderForValue.build());
          onChanged();
        } else {
          metricsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllMetrics(
          java.lang.Iterable<? extends com.google.analytics.data.v1alpha.Metric> values) {
        if (metricsBuilder_ == null) {
          ensureMetricsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
          onChanged();
        } else {
          metricsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearMetrics() {
        if (metricsBuilder_ == null) {
          metrics_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          metricsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeMetrics(int index) {
        if (metricsBuilder_ == null) {
          ensureMetricsIsMutable();
          metrics_.remove(index);
          onChanged();
        } else {
          metricsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Metric.Builder getMetricsBuilder(int index) {
        return getMetricsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.MetricOrBuilder getMetricsOrBuilder(int index) {
        if (metricsBuilder_ == null) {
          return metrics_.get(index);
        } else {
          return metricsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.analytics.data.v1alpha.MetricOrBuilder>
          getMetricsOrBuilderList() {
        if (metricsBuilder_ != null) {
          return metricsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(metrics_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Metric.Builder addMetricsBuilder() {
        return getMetricsFieldBuilder()
            .addBuilder(com.google.analytics.data.v1alpha.Metric.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.Metric.Builder addMetricsBuilder(int index) {
        return getMetricsFieldBuilder()
            .addBuilder(index, com.google.analytics.data.v1alpha.Metric.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. The metrics requested and displayed.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.Metric metrics = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.Metric.Builder>
          getMetricsBuilderList() {
        return getMetricsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.Metric,
              com.google.analytics.data.v1alpha.Metric.Builder,
              com.google.analytics.data.v1alpha.MetricOrBuilder>
          getMetricsFieldBuilder() {
        if (metricsBuilder_ == null) {
          metricsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.analytics.data.v1alpha.Metric,
                  com.google.analytics.data.v1alpha.Metric.Builder,
                  com.google.analytics.data.v1alpha.MetricOrBuilder>(
                  metrics_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          metrics_ = null;
        }
        return metricsBuilder_;
      }

      private java.util.List<com.google.analytics.data.v1alpha.DateRange> dateRanges_ =
          java.util.Collections.emptyList();

      private void ensureDateRangesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          dateRanges_ =
              new java.util.ArrayList<com.google.analytics.data.v1alpha.DateRange>(dateRanges_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.DateRange,
              com.google.analytics.data.v1alpha.DateRange.Builder,
              com.google.analytics.data.v1alpha.DateRangeOrBuilder>
          dateRangesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.DateRange> getDateRangesList() {
        if (dateRangesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dateRanges_);
        } else {
          return dateRangesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getDateRangesCount() {
        if (dateRangesBuilder_ == null) {
          return dateRanges_.size();
        } else {
          return dateRangesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.DateRange getDateRanges(int index) {
        if (dateRangesBuilder_ == null) {
          return dateRanges_.get(index);
        } else {
          return dateRangesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDateRanges(int index, com.google.analytics.data.v1alpha.DateRange value) {
        if (dateRangesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDateRangesIsMutable();
          dateRanges_.set(index, value);
          onChanged();
        } else {
          dateRangesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDateRanges(
          int index, com.google.analytics.data.v1alpha.DateRange.Builder builderForValue) {
        if (dateRangesBuilder_ == null) {
          ensureDateRangesIsMutable();
          dateRanges_.set(index, builderForValue.build());
          onChanged();
        } else {
          dateRangesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDateRanges(com.google.analytics.data.v1alpha.DateRange value) {
        if (dateRangesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDateRangesIsMutable();
          dateRanges_.add(value);
          onChanged();
        } else {
          dateRangesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDateRanges(int index, com.google.analytics.data.v1alpha.DateRange value) {
        if (dateRangesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDateRangesIsMutable();
          dateRanges_.add(index, value);
          onChanged();
        } else {
          dateRangesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDateRanges(
          com.google.analytics.data.v1alpha.DateRange.Builder builderForValue) {
        if (dateRangesBuilder_ == null) {
          ensureDateRangesIsMutable();
          dateRanges_.add(builderForValue.build());
          onChanged();
        } else {
          dateRangesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDateRanges(
          int index, com.google.analytics.data.v1alpha.DateRange.Builder builderForValue) {
        if (dateRangesBuilder_ == null) {
          ensureDateRangesIsMutable();
          dateRanges_.add(index, builderForValue.build());
          onChanged();
        } else {
          dateRangesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllDateRanges(
          java.lang.Iterable<? extends com.google.analytics.data.v1alpha.DateRange> values) {
        if (dateRangesBuilder_ == null) {
          ensureDateRangesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dateRanges_);
          onChanged();
        } else {
          dateRangesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDateRanges() {
        if (dateRangesBuilder_ == null) {
          dateRanges_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          dateRangesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeDateRanges(int index) {
        if (dateRangesBuilder_ == null) {
          ensureDateRangesIsMutable();
          dateRanges_.remove(index);
          onChanged();
        } else {
          dateRangesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.DateRange.Builder getDateRangesBuilder(int index) {
        return getDateRangesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.DateRangeOrBuilder getDateRangesOrBuilder(
          int index) {
        if (dateRangesBuilder_ == null) {
          return dateRanges_.get(index);
        } else {
          return dateRangesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.analytics.data.v1alpha.DateRangeOrBuilder>
          getDateRangesOrBuilderList() {
        if (dateRangesBuilder_ != null) {
          return dateRangesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dateRanges_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.DateRange.Builder addDateRangesBuilder() {
        return getDateRangesFieldBuilder()
            .addBuilder(com.google.analytics.data.v1alpha.DateRange.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.DateRange.Builder addDateRangesBuilder(int index) {
        return getDateRangesFieldBuilder()
            .addBuilder(index, com.google.analytics.data.v1alpha.DateRange.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Date ranges of data to read. If multiple date ranges are
       * requested, each response row will contain a zero based date range index.
       * If two date ranges overlap, the event data for the overlapping days is
       * included in the response rows for both date ranges. In a cohort request,
       * this `dateRanges` must be unspecified.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.DateRange date_ranges = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.DateRange.Builder>
          getDateRangesBuilderList() {
        return getDateRangesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.DateRange,
              com.google.analytics.data.v1alpha.DateRange.Builder,
              com.google.analytics.data.v1alpha.DateRangeOrBuilder>
          getDateRangesFieldBuilder() {
        if (dateRangesBuilder_ == null) {
          dateRangesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.analytics.data.v1alpha.DateRange,
                  com.google.analytics.data.v1alpha.DateRange.Builder,
                  com.google.analytics.data.v1alpha.DateRangeOrBuilder>(
                  dateRanges_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          dateRanges_ = null;
        }
        return dateRangesBuilder_;
      }

      private com.google.analytics.data.v1alpha.FilterExpression dimensionFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.analytics.data.v1alpha.FilterExpression,
              com.google.analytics.data.v1alpha.FilterExpression.Builder,
              com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>
          dimensionFilterBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the dimensionFilter field is set.
       */
      public boolean hasDimensionFilter() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The dimensionFilter.
       */
      public com.google.analytics.data.v1alpha.FilterExpression getDimensionFilter() {
        if (dimensionFilterBuilder_ == null) {
          return dimensionFilter_ == null
              ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
              : dimensionFilter_;
        } else {
          return dimensionFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDimensionFilter(com.google.analytics.data.v1alpha.FilterExpression value) {
        if (dimensionFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dimensionFilter_ = value;
        } else {
          dimensionFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDimensionFilter(
          com.google.analytics.data.v1alpha.FilterExpression.Builder builderForValue) {
        if (dimensionFilterBuilder_ == null) {
          dimensionFilter_ = builderForValue.build();
        } else {
          dimensionFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDimensionFilter(
          com.google.analytics.data.v1alpha.FilterExpression value) {
        if (dimensionFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && dimensionFilter_ != null
              && dimensionFilter_
                  != com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()) {
            getDimensionFilterBuilder().mergeFrom(value);
          } else {
            dimensionFilter_ = value;
          }
        } else {
          dimensionFilterBuilder_.mergeFrom(value);
        }
        if (dimensionFilter_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDimensionFilter() {
        bitField0_ = (bitField0_ & ~0x00000008);
        dimensionFilter_ = null;
        if (dimensionFilterBuilder_ != null) {
          dimensionFilterBuilder_.dispose();
          dimensionFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.FilterExpression.Builder
          getDimensionFilterBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getDimensionFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.FilterExpressionOrBuilder
          getDimensionFilterOrBuilder() {
        if (dimensionFilterBuilder_ != null) {
          return dimensionFilterBuilder_.getMessageOrBuilder();
        } else {
          return dimensionFilter_ == null
              ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
              : dimensionFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Dimension filters let you ask for only specific dimension
       * values in the report. To learn more, see [Fundamentals of Dimension
       * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
       * for examples. Metrics cannot be used in this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression dimension_filter = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.analytics.data.v1alpha.FilterExpression,
              com.google.analytics.data.v1alpha.FilterExpression.Builder,
              com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>
          getDimensionFilterFieldBuilder() {
        if (dimensionFilterBuilder_ == null) {
          dimensionFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.analytics.data.v1alpha.FilterExpression,
                  com.google.analytics.data.v1alpha.FilterExpression.Builder,
                  com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>(
                  getDimensionFilter(), getParentForChildren(), isClean());
          dimensionFilter_ = null;
        }
        return dimensionFilterBuilder_;
      }

      private com.google.analytics.data.v1alpha.FilterExpression metricFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.analytics.data.v1alpha.FilterExpression,
              com.google.analytics.data.v1alpha.FilterExpression.Builder,
              com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>
          metricFilterBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the metricFilter field is set.
       */
      public boolean hasMetricFilter() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The metricFilter.
       */
      public com.google.analytics.data.v1alpha.FilterExpression getMetricFilter() {
        if (metricFilterBuilder_ == null) {
          return metricFilter_ == null
              ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
              : metricFilter_;
        } else {
          return metricFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMetricFilter(com.google.analytics.data.v1alpha.FilterExpression value) {
        if (metricFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metricFilter_ = value;
        } else {
          metricFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMetricFilter(
          com.google.analytics.data.v1alpha.FilterExpression.Builder builderForValue) {
        if (metricFilterBuilder_ == null) {
          metricFilter_ = builderForValue.build();
        } else {
          metricFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeMetricFilter(com.google.analytics.data.v1alpha.FilterExpression value) {
        if (metricFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && metricFilter_ != null
              && metricFilter_
                  != com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()) {
            getMetricFilterBuilder().mergeFrom(value);
          } else {
            metricFilter_ = value;
          }
        } else {
          metricFilterBuilder_.mergeFrom(value);
        }
        if (metricFilter_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearMetricFilter() {
        bitField0_ = (bitField0_ & ~0x00000010);
        metricFilter_ = null;
        if (metricFilterBuilder_ != null) {
          metricFilterBuilder_.dispose();
          metricFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.FilterExpression.Builder getMetricFilterBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getMetricFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.FilterExpressionOrBuilder
          getMetricFilterOrBuilder() {
        if (metricFilterBuilder_ != null) {
          return metricFilterBuilder_.getMessageOrBuilder();
        } else {
          return metricFilter_ == null
              ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
              : metricFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter clause of metrics. Applied after aggregating the
       * report's rows, similar to SQL having-clause. Dimensions cannot be used in
       * this filter.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.FilterExpression metric_filter = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.analytics.data.v1alpha.FilterExpression,
              com.google.analytics.data.v1alpha.FilterExpression.Builder,
              com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>
          getMetricFilterFieldBuilder() {
        if (metricFilterBuilder_ == null) {
          metricFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.analytics.data.v1alpha.FilterExpression,
                  com.google.analytics.data.v1alpha.FilterExpression.Builder,
                  com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>(
                  getMetricFilter(), getParentForChildren(), isClean());
          metricFilter_ = null;
        }
        return metricFilterBuilder_;
      }

      private long offset_;
      /**
       *
       *
       * <pre>
       * Optional. The row count of the start row from Google Analytics Storage.
       * The first row is counted as row 0.
       *
       * When creating a report task, the `offset` and `limit` parameters define
       * the subset of data rows from Google Analytics storage to be included in
       * the generated report. For example, if there are a total of 300,000 rows
       * in Google Analytics storage, the initial report task may have the
       * first 10,000 rows with a limit of 10,000 and an offset of 0.
       * Subsequently, another report task could cover the next 10,000 rows with a
       * limit of 10,000 and an offset of 10,000.
       * </pre>
       *
       * <code>int64 offset = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The offset.
       */
      @java.lang.Override
      public long getOffset() {
        return offset_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The row count of the start row from Google Analytics Storage.
       * The first row is counted as row 0.
       *
       * When creating a report task, the `offset` and `limit` parameters define
       * the subset of data rows from Google Analytics storage to be included in
       * the generated report. For example, if there are a total of 300,000 rows
       * in Google Analytics storage, the initial report task may have the
       * first 10,000 rows with a limit of 10,000 and an offset of 0.
       * Subsequently, another report task could cover the next 10,000 rows with a
       * limit of 10,000 and an offset of 10,000.
       * </pre>
       *
       * <code>int64 offset = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffset(long value) {

        offset_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The row count of the start row from Google Analytics Storage.
       * The first row is counted as row 0.
       *
       * When creating a report task, the `offset` and `limit` parameters define
       * the subset of data rows from Google Analytics storage to be included in
       * the generated report. For example, if there are a total of 300,000 rows
       * in Google Analytics storage, the initial report task may have the
       * first 10,000 rows with a limit of 10,000 and an offset of 0.
       * Subsequently, another report task could cover the next 10,000 rows with a
       * limit of 10,000 and an offset of 10,000.
       * </pre>
       *
       * <code>int64 offset = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOffset() {
        bitField0_ = (bitField0_ & ~0x00000020);
        offset_ = 0L;
        onChanged();
        return this;
      }

      private long limit_;
      /**
       *
       *
       * <pre>
       * Optional. The number of rows to return in the Report. If unspecified,
       * 10,000 rows are returned. The API returns a maximum of 250,000 rows per
       * request, no matter how many you ask for. `limit` must be positive.
       *
       * The API can also return fewer rows than the requested `limit`, if there
       * aren't as many dimension values as the `limit`. For instance, there are
       * fewer than 300 possible values for the dimension `country`, so when
       * reporting on only `country`, you can't get more than 300 rows, even if
       * you set `limit` to a higher value.
       * </pre>
       *
       * <code>int64 limit = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The limit.
       */
      @java.lang.Override
      public long getLimit() {
        return limit_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of rows to return in the Report. If unspecified,
       * 10,000 rows are returned. The API returns a maximum of 250,000 rows per
       * request, no matter how many you ask for. `limit` must be positive.
       *
       * The API can also return fewer rows than the requested `limit`, if there
       * aren't as many dimension values as the `limit`. For instance, there are
       * fewer than 300 possible values for the dimension `country`, so when
       * reporting on only `country`, you can't get more than 300 rows, even if
       * you set `limit` to a higher value.
       * </pre>
       *
       * <code>int64 limit = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The limit to set.
       * @return This builder for chaining.
       */
      public Builder setLimit(long value) {

        limit_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of rows to return in the Report. If unspecified,
       * 10,000 rows are returned. The API returns a maximum of 250,000 rows per
       * request, no matter how many you ask for. `limit` must be positive.
       *
       * The API can also return fewer rows than the requested `limit`, if there
       * aren't as many dimension values as the `limit`. For instance, there are
       * fewer than 300 possible values for the dimension `country`, so when
       * reporting on only `country`, you can't get more than 300 rows, even if
       * you set `limit` to a higher value.
       * </pre>
       *
       * <code>int64 limit = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLimit() {
        bitField0_ = (bitField0_ & ~0x00000040);
        limit_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> metricAggregations_ =
          java.util.Collections.emptyList();

      private void ensureMetricAggregationsIsMutable() {
        if (!((bitField0_ & 0x00000080) != 0)) {
          metricAggregations_ = new java.util.ArrayList<java.lang.Integer>(metricAggregations_);
          bitField0_ |= 0x00000080;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the metricAggregations.
       */
      public java.util.List<com.google.analytics.data.v1alpha.MetricAggregation>
          getMetricAggregationsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.analytics.data.v1alpha.MetricAggregation>(
            metricAggregations_, metricAggregations_converter_);
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of metricAggregations.
       */
      public int getMetricAggregationsCount() {
        return metricAggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The metricAggregations at the given index.
       */
      public com.google.analytics.data.v1alpha.MetricAggregation getMetricAggregations(int index) {
        return metricAggregations_converter_.convert(metricAggregations_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The metricAggregations to set.
       * @return This builder for chaining.
       */
      public Builder setMetricAggregations(
          int index, com.google.analytics.data.v1alpha.MetricAggregation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricAggregationsIsMutable();
        metricAggregations_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The metricAggregations to add.
       * @return This builder for chaining.
       */
      public Builder addMetricAggregations(
          com.google.analytics.data.v1alpha.MetricAggregation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricAggregationsIsMutable();
        metricAggregations_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The metricAggregations to add.
       * @return This builder for chaining.
       */
      public Builder addAllMetricAggregations(
          java.lang.Iterable<? extends com.google.analytics.data.v1alpha.MetricAggregation>
              values) {
        ensureMetricAggregationsIsMutable();
        for (com.google.analytics.data.v1alpha.MetricAggregation value : values) {
          metricAggregations_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricAggregations() {
        metricAggregations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for metricAggregations.
       */
      public java.util.List<java.lang.Integer> getMetricAggregationsValueList() {
        return java.util.Collections.unmodifiableList(metricAggregations_);
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of metricAggregations at the given index.
       */
      public int getMetricAggregationsValue(int index) {
        return metricAggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for metricAggregations to set.
       * @return This builder for chaining.
       */
      public Builder setMetricAggregationsValue(int index, int value) {
        ensureMetricAggregationsIsMutable();
        metricAggregations_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for metricAggregations to add.
       * @return This builder for chaining.
       */
      public Builder addMetricAggregationsValue(int value) {
        ensureMetricAggregationsIsMutable();
        metricAggregations_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Aggregation of metrics. Aggregated metric values will be shown
       * in rows where the dimension_values are set to
       * "RESERVED_(MetricAggregation)".
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.MetricAggregation metric_aggregations = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The enum numeric values on the wire for metricAggregations to add.
       * @return This builder for chaining.
       */
      public Builder addAllMetricAggregationsValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureMetricAggregationsIsMutable();
        for (int value : values) {
          metricAggregations_.add(value);
        }
        onChanged();
        return this;
      }

      private java.util.List<com.google.analytics.data.v1alpha.OrderBy> orderBys_ =
          java.util.Collections.emptyList();

      private void ensureOrderBysIsMutable() {
        if (!((bitField0_ & 0x00000100) != 0)) {
          orderBys_ = new java.util.ArrayList<com.google.analytics.data.v1alpha.OrderBy>(orderBys_);
          bitField0_ |= 0x00000100;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.OrderBy,
              com.google.analytics.data.v1alpha.OrderBy.Builder,
              com.google.analytics.data.v1alpha.OrderByOrBuilder>
          orderBysBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.OrderBy> getOrderBysList() {
        if (orderBysBuilder_ == null) {
          return java.util.Collections.unmodifiableList(orderBys_);
        } else {
          return orderBysBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getOrderBysCount() {
        if (orderBysBuilder_ == null) {
          return orderBys_.size();
        } else {
          return orderBysBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.OrderBy getOrderBys(int index) {
        if (orderBysBuilder_ == null) {
          return orderBys_.get(index);
        } else {
          return orderBysBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOrderBys(int index, com.google.analytics.data.v1alpha.OrderBy value) {
        if (orderBysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderBysIsMutable();
          orderBys_.set(index, value);
          onChanged();
        } else {
          orderBysBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOrderBys(
          int index, com.google.analytics.data.v1alpha.OrderBy.Builder builderForValue) {
        if (orderBysBuilder_ == null) {
          ensureOrderBysIsMutable();
          orderBys_.set(index, builderForValue.build());
          onChanged();
        } else {
          orderBysBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addOrderBys(com.google.analytics.data.v1alpha.OrderBy value) {
        if (orderBysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderBysIsMutable();
          orderBys_.add(value);
          onChanged();
        } else {
          orderBysBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addOrderBys(int index, com.google.analytics.data.v1alpha.OrderBy value) {
        if (orderBysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderBysIsMutable();
          orderBys_.add(index, value);
          onChanged();
        } else {
          orderBysBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addOrderBys(
          com.google.analytics.data.v1alpha.OrderBy.Builder builderForValue) {
        if (orderBysBuilder_ == null) {
          ensureOrderBysIsMutable();
          orderBys_.add(builderForValue.build());
          onChanged();
        } else {
          orderBysBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addOrderBys(
          int index, com.google.analytics.data.v1alpha.OrderBy.Builder builderForValue) {
        if (orderBysBuilder_ == null) {
          ensureOrderBysIsMutable();
          orderBys_.add(index, builderForValue.build());
          onChanged();
        } else {
          orderBysBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllOrderBys(
          java.lang.Iterable<? extends com.google.analytics.data.v1alpha.OrderBy> values) {
        if (orderBysBuilder_ == null) {
          ensureOrderBysIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, orderBys_);
          onChanged();
        } else {
          orderBysBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOrderBys() {
        if (orderBysBuilder_ == null) {
          orderBys_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000100);
          onChanged();
        } else {
          orderBysBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeOrderBys(int index) {
        if (orderBysBuilder_ == null) {
          ensureOrderBysIsMutable();
          orderBys_.remove(index);
          onChanged();
        } else {
          orderBysBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.OrderBy.Builder getOrderBysBuilder(int index) {
        return getOrderBysFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.OrderByOrBuilder getOrderBysOrBuilder(int index) {
        if (orderBysBuilder_ == null) {
          return orderBys_.get(index);
        } else {
          return orderBysBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.analytics.data.v1alpha.OrderByOrBuilder>
          getOrderBysOrBuilderList() {
        if (orderBysBuilder_ != null) {
          return orderBysBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(orderBys_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.OrderBy.Builder addOrderBysBuilder() {
        return getOrderBysFieldBuilder()
            .addBuilder(com.google.analytics.data.v1alpha.OrderBy.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.OrderBy.Builder addOrderBysBuilder(int index) {
        return getOrderBysFieldBuilder()
            .addBuilder(index, com.google.analytics.data.v1alpha.OrderBy.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies how rows are ordered in the response.
       * </pre>
       *
       * <code>
       * repeated .google.analytics.data.v1alpha.OrderBy order_bys = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.analytics.data.v1alpha.OrderBy.Builder>
          getOrderBysBuilderList() {
        return getOrderBysFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.analytics.data.v1alpha.OrderBy,
              com.google.analytics.data.v1alpha.OrderBy.Builder,
              com.google.analytics.data.v1alpha.OrderByOrBuilder>
          getOrderBysFieldBuilder() {
        if (orderBysBuilder_ == null) {
          orderBysBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.analytics.data.v1alpha.OrderBy,
                  com.google.analytics.data.v1alpha.OrderBy.Builder,
                  com.google.analytics.data.v1alpha.OrderByOrBuilder>(
                  orderBys_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
          orderBys_ = null;
        }
        return orderBysBuilder_;
      }

      private java.lang.Object currencyCode_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
       * If the field is empty, the report uses the property's default currency.
       * </pre>
       *
       * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The currencyCode.
       */
      public java.lang.String getCurrencyCode() {
        java.lang.Object ref = currencyCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          currencyCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
       * If the field is empty, the report uses the property's default currency.
       * </pre>
       *
       * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for currencyCode.
       */
      public com.google.protobuf.ByteString getCurrencyCodeBytes() {
        java.lang.Object ref = currencyCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          currencyCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
       * If the field is empty, the report uses the property's default currency.
       * </pre>
       *
       * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The currencyCode to set.
       * @return This builder for chaining.
       */
      public Builder setCurrencyCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        currencyCode_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
       * If the field is empty, the report uses the property's default currency.
       * </pre>
       *
       * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCurrencyCode() {
        currencyCode_ = getDefaultInstance().getCurrencyCode();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A currency code in ISO4217 format, such as "AED", "USD", "JPY".
       * If the field is empty, the report uses the property's default currency.
       * </pre>
       *
       * <code>string currency_code = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for currencyCode to set.
       * @return This builder for chaining.
       */
      public Builder setCurrencyCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        currencyCode_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }

      private com.google.analytics.data.v1alpha.CohortSpec cohortSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.analytics.data.v1alpha.CohortSpec,
              com.google.analytics.data.v1alpha.CohortSpec.Builder,
              com.google.analytics.data.v1alpha.CohortSpecOrBuilder>
          cohortSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the cohortSpec field is set.
       */
      public boolean hasCohortSpec() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The cohortSpec.
       */
      public com.google.analytics.data.v1alpha.CohortSpec getCohortSpec() {
        if (cohortSpecBuilder_ == null) {
          return cohortSpec_ == null
              ? com.google.analytics.data.v1alpha.CohortSpec.getDefaultInstance()
              : cohortSpec_;
        } else {
          return cohortSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCohortSpec(com.google.analytics.data.v1alpha.CohortSpec value) {
        if (cohortSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cohortSpec_ = value;
        } else {
          cohortSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCohortSpec(
          com.google.analytics.data.v1alpha.CohortSpec.Builder builderForValue) {
        if (cohortSpecBuilder_ == null) {
          cohortSpec_ = builderForValue.build();
        } else {
          cohortSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeCohortSpec(com.google.analytics.data.v1alpha.CohortSpec value) {
        if (cohortSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)
              && cohortSpec_ != null
              && cohortSpec_ != com.google.analytics.data.v1alpha.CohortSpec.getDefaultInstance()) {
            getCohortSpecBuilder().mergeFrom(value);
          } else {
            cohortSpec_ = value;
          }
        } else {
          cohortSpecBuilder_.mergeFrom(value);
        }
        if (cohortSpec_ != null) {
          bitField0_ |= 0x00000400;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearCohortSpec() {
        bitField0_ = (bitField0_ & ~0x00000400);
        cohortSpec_ = null;
        if (cohortSpecBuilder_ != null) {
          cohortSpecBuilder_.dispose();
          cohortSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.CohortSpec.Builder getCohortSpecBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getCohortSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.analytics.data.v1alpha.CohortSpecOrBuilder getCohortSpecOrBuilder() {
        if (cohortSpecBuilder_ != null) {
          return cohortSpecBuilder_.getMessageOrBuilder();
        } else {
          return cohortSpec_ == null
              ? com.google.analytics.data.v1alpha.CohortSpec.getDefaultInstance()
              : cohortSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Cohort group associated with this request. If there is a cohort
       * group in the request the 'cohort' dimension must be present.
       * </pre>
       *
       * <code>
       * .google.analytics.data.v1alpha.CohortSpec cohort_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.analytics.data.v1alpha.CohortSpec,
              com.google.analytics.data.v1alpha.CohortSpec.Builder,
              com.google.analytics.data.v1alpha.CohortSpecOrBuilder>
          getCohortSpecFieldBuilder() {
        if (cohortSpecBuilder_ == null) {
          cohortSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.analytics.data.v1alpha.CohortSpec,
                  com.google.analytics.data.v1alpha.CohortSpec.Builder,
                  com.google.analytics.data.v1alpha.CohortSpecOrBuilder>(
                  getCohortSpec(), getParentForChildren(), isClean());
          cohortSpec_ = null;
        }
        return cohortSpecBuilder_;
      }

      private boolean keepEmptyRows_;
      /**
       *
       *
       * <pre>
       * Optional. If false or unspecified, each row with all metrics equal to 0
       * will not be returned. If true, these rows will be returned if they are
       * not separately removed by a filter.
       *
       * Regardless of this `keep_empty_rows` setting, only data recorded by the
       * Google Analytics property can be displayed in a report.
       *
       * For example if a property never logs a `purchase` event, then a query for
       * the `eventName` dimension and  `eventCount` metric will not have a row
       * containing eventName: "purchase" and eventCount: 0.
       * </pre>
       *
       * <code>bool keep_empty_rows = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The keepEmptyRows.
       */
      @java.lang.Override
      public boolean getKeepEmptyRows() {
        return keepEmptyRows_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If false or unspecified, each row with all metrics equal to 0
       * will not be returned. If true, these rows will be returned if they are
       * not separately removed by a filter.
       *
       * Regardless of this `keep_empty_rows` setting, only data recorded by the
       * Google Analytics property can be displayed in a report.
       *
       * For example if a property never logs a `purchase` event, then a query for
       * the `eventName` dimension and  `eventCount` metric will not have a row
       * containing eventName: "purchase" and eventCount: 0.
       * </pre>
       *
       * <code>bool keep_empty_rows = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The keepEmptyRows to set.
       * @return This builder for chaining.
       */
      public Builder setKeepEmptyRows(boolean value) {

        keepEmptyRows_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If false or unspecified, each row with all metrics equal to 0
       * will not be returned. If true, these rows will be returned if they are
       * not separately removed by a filter.
       *
       * Regardless of this `keep_empty_rows` setting, only data recorded by the
       * Google Analytics property can be displayed in a report.
       *
       * For example if a property never logs a `purchase` event, then a query for
       * the `eventName` dimension and  `eventCount` metric will not have a row
       * containing eventName: "purchase" and eventCount: 0.
       * </pre>
       *
       * <code>bool keep_empty_rows = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKeepEmptyRows() {
        bitField0_ = (bitField0_ & ~0x00000800);
        keepEmptyRows_ = false;
        onChanged();
        return this;
      }

      private int samplingLevel_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The report's sampling level.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the samplingLevel field is set.
       */
      @java.lang.Override
      public boolean hasSamplingLevel() {
        return ((bitField0_ & 0x00001000) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The report's sampling level.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for samplingLevel.
       */
      @java.lang.Override
      public int getSamplingLevelValue() {
        return samplingLevel_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The report's sampling level.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for samplingLevel to set.
       * @return This builder for chaining.
       */
      public Builder setSamplingLevelValue(int value) {
        samplingLevel_ = value;
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The report's sampling level.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The samplingLevel.
       */
      @java.lang.Override
      public com.google.analytics.data.v1alpha.SamplingLevel getSamplingLevel() {
        com.google.analytics.data.v1alpha.SamplingLevel result =
            com.google.analytics.data.v1alpha.SamplingLevel.forNumber(samplingLevel_);
        return result == null
            ? com.google.analytics.data.v1alpha.SamplingLevel.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. The report's sampling level.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The samplingLevel to set.
       * @return This builder for chaining.
       */
      public Builder setSamplingLevel(com.google.analytics.data.v1alpha.SamplingLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00001000;
        samplingLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The report's sampling level.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.SamplingLevel sampling_level = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSamplingLevel() {
        bitField0_ = (bitField0_ & ~0x00001000);
        samplingLevel_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.ReportTask.ReportDefinition)
    }

    // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.ReportTask.ReportDefinition)
    private static final com.google.analytics.data.v1alpha.ReportTask.ReportDefinition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.ReportTask.ReportDefinition();
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportDefinition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReportDefinition> PARSER =
        new com.google.protobuf.AbstractParser<ReportDefinition>() {
          @java.lang.Override
          public ReportDefinition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReportDefinition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReportDefinition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReportMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.ReportTask.ReportMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The current state for this report task.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the state field is set.
     */
    boolean hasState();
    /**
     *
     *
     * <pre>
     * Output only. The current state for this report task.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. The current state for this report task.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State getState();

    /**
     *
     *
     * <pre>
     * Output only. The time when `CreateReportTask` was called and the report
     * began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the beginCreatingTime field is set.
     */
    boolean hasBeginCreatingTime();
    /**
     *
     *
     * <pre>
     * Output only. The time when `CreateReportTask` was called and the report
     * began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The beginCreatingTime.
     */
    com.google.protobuf.Timestamp getBeginCreatingTime();
    /**
     *
     *
     * <pre>
     * Output only. The time when `CreateReportTask` was called and the report
     * began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The total quota tokens charged during creation of the
     * report. Because this token count is based on activity from the `CREATING`
     * state, this tokens charge will be fixed once a report task enters the
     * `ACTIVE` or `FAILED` state.
     * </pre>
     *
     * <code>int32 creation_quota_tokens_charged = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationQuotaTokensCharged.
     */
    int getCreationQuotaTokensCharged();

    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the report result. This field
     * will be populated when the state is active. You can utilize
     * `task_row_count` for pagination within the confines of their existing
     * report.
     * </pre>
     *
     * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the taskRowCount field is set.
     */
    boolean hasTaskRowCount();
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the report result. This field
     * will be populated when the state is active. You can utilize
     * `task_row_count` for pagination within the confines of their existing
     * report.
     * </pre>
     *
     * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The taskRowCount.
     */
    int getTaskRowCount();

    /**
     *
     *
     * <pre>
     * Output only. Error message is populated if a report task fails during
     * creation.
     * </pre>
     *
     * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the errorMessage field is set.
     */
    boolean hasErrorMessage();
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated if a report task fails during
     * creation.
     * </pre>
     *
     * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated if a report task fails during
     * creation.
     * </pre>
     *
     * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString getErrorMessageBytes();

    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in Google Analytics storage. If you
     * want to query additional data rows beyond the current report, they can
     * initiate a new report task based on the `total_row_count`.
     *
     * The `task_row_count` represents the number of rows specifically
     * pertaining to the current report, whereas `total_row_count` encompasses
     * the total count of rows across all data retrieved from Google
     * Analytics storage.
     *
     * For example, suppose the current report's `task_row_count` is 20,
     * displaying the data from the first 20 rows. Simultaneously, the
     * `total_row_count` is 30, indicating the presence of data for all 30 rows.
     * The `task_row_count` can be utilizated to paginate through the initial 20
     * rows. To expand the report and include data from all 30 rows, a new
     * report task can be created using the total_row_count to access the full
     * set of 30 rows' worth of data.
     * </pre>
     *
     * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the totalRowCount field is set.
     */
    boolean hasTotalRowCount();
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in Google Analytics storage. If you
     * want to query additional data rows beyond the current report, they can
     * initiate a new report task based on the `total_row_count`.
     *
     * The `task_row_count` represents the number of rows specifically
     * pertaining to the current report, whereas `total_row_count` encompasses
     * the total count of rows across all data retrieved from Google
     * Analytics storage.
     *
     * For example, suppose the current report's `task_row_count` is 20,
     * displaying the data from the first 20 rows. Simultaneously, the
     * `total_row_count` is 30, indicating the presence of data for all 30 rows.
     * The `task_row_count` can be utilizated to paginate through the initial 20
     * rows. To expand the report and include data from all 30 rows, a new
     * report task can be created using the total_row_count to access the full
     * set of 30 rows' worth of data.
     * </pre>
     *
     * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The totalRowCount.
     */
    int getTotalRowCount();
  }
  /**
   *
   *
   * <pre>
   * The report metadata for a specific report task.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.ReportTask.ReportMetadata}
   */
  public static final class ReportMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.ReportTask.ReportMetadata)
      ReportMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReportMetadata.newBuilder() to construct.
    private ReportMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReportMetadata() {
      state_ = 0;
      errorMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReportMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_ReportMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_ReportMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.class,
              com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The processing state.
     * </pre>
     *
     * Protobuf enum {@code google.analytics.data.v1alpha.ReportTask.ReportMetadata.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified state will never be used.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The report is currently creating and will be available in the
       * future. Creating occurs immediately after the CreateReport call.
       * </pre>
       *
       * <code>CREATING = 1;</code>
       */
      CREATING(1),
      /**
       *
       *
       * <pre>
       * The report is fully created and ready for querying.
       * </pre>
       *
       * <code>ACTIVE = 2;</code>
       */
      ACTIVE(2),
      /**
       *
       *
       * <pre>
       * The report failed to be created.
       * </pre>
       *
       * <code>FAILED = 3;</code>
       */
      FAILED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified state will never be used.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The report is currently creating and will be available in the
       * future. Creating occurs immediately after the CreateReport call.
       * </pre>
       *
       * <code>CREATING = 1;</code>
       */
      public static final int CREATING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The report is fully created and ready for querying.
       * </pre>
       *
       * <code>ACTIVE = 2;</code>
       */
      public static final int ACTIVE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The report failed to be created.
       * </pre>
       *
       * <code>FAILED = 3;</code>
       */
      public static final int FAILED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return CREATING;
          case 2:
            return ACTIVE;
          case 3:
            return FAILED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.analytics.data.v1alpha.ReportTask.ReportMetadata.State)
    }

    private int bitField0_;
    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state for this report task.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the state field is set.
     */
    @java.lang.Override
    public boolean hasState() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this report task.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this report task.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State getState() {
      com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State result =
          com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State.forNumber(state_);
      return result == null
          ? com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State.UNRECOGNIZED
          : result;
    }

    public static final int BEGIN_CREATING_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp beginCreatingTime_;
    /**
     *
     *
     * <pre>
     * Output only. The time when `CreateReportTask` was called and the report
     * began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the beginCreatingTime field is set.
     */
    @java.lang.Override
    public boolean hasBeginCreatingTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when `CreateReportTask` was called and the report
     * began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The beginCreatingTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getBeginCreatingTime() {
      return beginCreatingTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : beginCreatingTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when `CreateReportTask` was called and the report
     * began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder() {
      return beginCreatingTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : beginCreatingTime_;
    }

    public static final int CREATION_QUOTA_TOKENS_CHARGED_FIELD_NUMBER = 3;
    private int creationQuotaTokensCharged_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The total quota tokens charged during creation of the
     * report. Because this token count is based on activity from the `CREATING`
     * state, this tokens charge will be fixed once a report task enters the
     * `ACTIVE` or `FAILED` state.
     * </pre>
     *
     * <code>int32 creation_quota_tokens_charged = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationQuotaTokensCharged.
     */
    @java.lang.Override
    public int getCreationQuotaTokensCharged() {
      return creationQuotaTokensCharged_;
    }

    public static final int TASK_ROW_COUNT_FIELD_NUMBER = 4;
    private int taskRowCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the report result. This field
     * will be populated when the state is active. You can utilize
     * `task_row_count` for pagination within the confines of their existing
     * report.
     * </pre>
     *
     * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the taskRowCount field is set.
     */
    @java.lang.Override
    public boolean hasTaskRowCount() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the report result. This field
     * will be populated when the state is active. You can utilize
     * `task_row_count` for pagination within the confines of their existing
     * report.
     * </pre>
     *
     * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The taskRowCount.
     */
    @java.lang.Override
    public int getTaskRowCount() {
      return taskRowCount_;
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated if a report task fails during
     * creation.
     * </pre>
     *
     * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the errorMessage field is set.
     */
    @java.lang.Override
    public boolean hasErrorMessage() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated if a report task fails during
     * creation.
     * </pre>
     *
     * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated if a report task fails during
     * creation.
     * </pre>
     *
     * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOTAL_ROW_COUNT_FIELD_NUMBER = 6;
    private int totalRowCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in Google Analytics storage. If you
     * want to query additional data rows beyond the current report, they can
     * initiate a new report task based on the `total_row_count`.
     *
     * The `task_row_count` represents the number of rows specifically
     * pertaining to the current report, whereas `total_row_count` encompasses
     * the total count of rows across all data retrieved from Google
     * Analytics storage.
     *
     * For example, suppose the current report's `task_row_count` is 20,
     * displaying the data from the first 20 rows. Simultaneously, the
     * `total_row_count` is 30, indicating the presence of data for all 30 rows.
     * The `task_row_count` can be utilizated to paginate through the initial 20
     * rows. To expand the report and include data from all 30 rows, a new
     * report task can be created using the total_row_count to access the full
     * set of 30 rows' worth of data.
     * </pre>
     *
     * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the totalRowCount field is set.
     */
    @java.lang.Override
    public boolean hasTotalRowCount() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in Google Analytics storage. If you
     * want to query additional data rows beyond the current report, they can
     * initiate a new report task based on the `total_row_count`.
     *
     * The `task_row_count` represents the number of rows specifically
     * pertaining to the current report, whereas `total_row_count` encompasses
     * the total count of rows across all data retrieved from Google
     * Analytics storage.
     *
     * For example, suppose the current report's `task_row_count` is 20,
     * displaying the data from the first 20 rows. Simultaneously, the
     * `total_row_count` is 30, indicating the presence of data for all 30 rows.
     * The `task_row_count` can be utilizated to paginate through the initial 20
     * rows. To expand the report and include data from all 30 rows, a new
     * report task can be created using the total_row_count to access the full
     * set of 30 rows' worth of data.
     * </pre>
     *
     * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The totalRowCount.
     */
    @java.lang.Override
    public int getTotalRowCount() {
      return totalRowCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, state_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getBeginCreatingTime());
      }
      if (creationQuotaTokensCharged_ != 0) {
        output.writeInt32(3, creationQuotaTokensCharged_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt32(4, taskRowCount_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, errorMessage_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeInt32(6, totalRowCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBeginCreatingTime());
      }
      if (creationQuotaTokensCharged_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(3, creationQuotaTokensCharged_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, taskRowCount_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, errorMessage_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, totalRowCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.analytics.data.v1alpha.ReportTask.ReportMetadata)) {
        return super.equals(obj);
      }
      com.google.analytics.data.v1alpha.ReportTask.ReportMetadata other =
          (com.google.analytics.data.v1alpha.ReportTask.ReportMetadata) obj;

      if (hasState() != other.hasState()) return false;
      if (hasState()) {
        if (state_ != other.state_) return false;
      }
      if (hasBeginCreatingTime() != other.hasBeginCreatingTime()) return false;
      if (hasBeginCreatingTime()) {
        if (!getBeginCreatingTime().equals(other.getBeginCreatingTime())) return false;
      }
      if (getCreationQuotaTokensCharged() != other.getCreationQuotaTokensCharged()) return false;
      if (hasTaskRowCount() != other.hasTaskRowCount()) return false;
      if (hasTaskRowCount()) {
        if (getTaskRowCount() != other.getTaskRowCount()) return false;
      }
      if (hasErrorMessage() != other.hasErrorMessage()) return false;
      if (hasErrorMessage()) {
        if (!getErrorMessage().equals(other.getErrorMessage())) return false;
      }
      if (hasTotalRowCount() != other.hasTotalRowCount()) return false;
      if (hasTotalRowCount()) {
        if (getTotalRowCount() != other.getTotalRowCount()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasState()) {
        hash = (37 * hash) + STATE_FIELD_NUMBER;
        hash = (53 * hash) + state_;
      }
      if (hasBeginCreatingTime()) {
        hash = (37 * hash) + BEGIN_CREATING_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getBeginCreatingTime().hashCode();
      }
      hash = (37 * hash) + CREATION_QUOTA_TOKENS_CHARGED_FIELD_NUMBER;
      hash = (53 * hash) + getCreationQuotaTokensCharged();
      if (hasTaskRowCount()) {
        hash = (37 * hash) + TASK_ROW_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getTaskRowCount();
      }
      if (hasErrorMessage()) {
        hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getErrorMessage().hashCode();
      }
      if (hasTotalRowCount()) {
        hash = (37 * hash) + TOTAL_ROW_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getTotalRowCount();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The report metadata for a specific report task.
     * </pre>
     *
     * Protobuf type {@code google.analytics.data.v1alpha.ReportTask.ReportMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.ReportTask.ReportMetadata)
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
            .internal_static_google_analytics_data_v1alpha_ReportTask_ReportMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
            .internal_static_google_analytics_data_v1alpha_ReportTask_ReportMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.class,
                com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder.class);
      }

      // Construct using com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBeginCreatingTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        beginCreatingTime_ = null;
        if (beginCreatingTimeBuilder_ != null) {
          beginCreatingTimeBuilder_.dispose();
          beginCreatingTimeBuilder_ = null;
        }
        creationQuotaTokensCharged_ = 0;
        taskRowCount_ = 0;
        errorMessage_ = "";
        totalRowCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
            .internal_static_google_analytics_data_v1alpha_ReportTask_ReportMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata
          getDefaultInstanceForType() {
        return com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata build() {
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata buildPartial() {
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata result =
            new com.google.analytics.data.v1alpha.ReportTask.ReportMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.analytics.data.v1alpha.ReportTask.ReportMetadata result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.beginCreatingTime_ =
              beginCreatingTimeBuilder_ == null
                  ? beginCreatingTime_
                  : beginCreatingTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.creationQuotaTokensCharged_ = creationQuotaTokensCharged_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.taskRowCount_ = taskRowCount_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.errorMessage_ = errorMessage_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.totalRowCount_ = totalRowCount_;
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.analytics.data.v1alpha.ReportTask.ReportMetadata) {
          return mergeFrom((com.google.analytics.data.v1alpha.ReportTask.ReportMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.analytics.data.v1alpha.ReportTask.ReportMetadata other) {
        if (other
            == com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDefaultInstance())
          return this;
        if (other.hasState()) {
          setState(other.getState());
        }
        if (other.hasBeginCreatingTime()) {
          mergeBeginCreatingTime(other.getBeginCreatingTime());
        }
        if (other.getCreationQuotaTokensCharged() != 0) {
          setCreationQuotaTokensCharged(other.getCreationQuotaTokensCharged());
        }
        if (other.hasTaskRowCount()) {
          setTaskRowCount(other.getTaskRowCount());
        }
        if (other.hasErrorMessage()) {
          errorMessage_ = other.errorMessage_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasTotalRowCount()) {
          setTotalRowCount(other.getTotalRowCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getBeginCreatingTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  creationQuotaTokensCharged_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  taskRowCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  errorMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 48:
                {
                  totalRowCount_ = input.readInt32();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The current state for this report task.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the state field is set.
       */
      @java.lang.Override
      public boolean hasState() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The current state for this report task.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The current state for this report task.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The current state for this report task.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State getState() {
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State result =
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State.forNumber(state_);
        return result == null
            ? com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The current state for this report task.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The current state for this report task.
       * </pre>
       *
       * <code>
       * optional .google.analytics.data.v1alpha.ReportTask.ReportMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp beginCreatingTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          beginCreatingTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the beginCreatingTime field is set.
       */
      public boolean hasBeginCreatingTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The beginCreatingTime.
       */
      public com.google.protobuf.Timestamp getBeginCreatingTime() {
        if (beginCreatingTimeBuilder_ == null) {
          return beginCreatingTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : beginCreatingTime_;
        } else {
          return beginCreatingTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setBeginCreatingTime(com.google.protobuf.Timestamp value) {
        if (beginCreatingTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          beginCreatingTime_ = value;
        } else {
          beginCreatingTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setBeginCreatingTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (beginCreatingTimeBuilder_ == null) {
          beginCreatingTime_ = builderForValue.build();
        } else {
          beginCreatingTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeBeginCreatingTime(com.google.protobuf.Timestamp value) {
        if (beginCreatingTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && beginCreatingTime_ != null
              && beginCreatingTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getBeginCreatingTimeBuilder().mergeFrom(value);
          } else {
            beginCreatingTime_ = value;
          }
        } else {
          beginCreatingTimeBuilder_.mergeFrom(value);
        }
        if (beginCreatingTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearBeginCreatingTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        beginCreatingTime_ = null;
        if (beginCreatingTimeBuilder_ != null) {
          beginCreatingTimeBuilder_.dispose();
          beginCreatingTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getBeginCreatingTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getBeginCreatingTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder() {
        if (beginCreatingTimeBuilder_ != null) {
          return beginCreatingTimeBuilder_.getMessageOrBuilder();
        } else {
          return beginCreatingTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : beginCreatingTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when `CreateReportTask` was called and the report
       * began the `CREATING` state.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp begin_creating_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getBeginCreatingTimeFieldBuilder() {
        if (beginCreatingTimeBuilder_ == null) {
          beginCreatingTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getBeginCreatingTime(), getParentForChildren(), isClean());
          beginCreatingTime_ = null;
        }
        return beginCreatingTimeBuilder_;
      }

      private int creationQuotaTokensCharged_;
      /**
       *
       *
       * <pre>
       * Output only. The total quota tokens charged during creation of the
       * report. Because this token count is based on activity from the `CREATING`
       * state, this tokens charge will be fixed once a report task enters the
       * `ACTIVE` or `FAILED` state.
       * </pre>
       *
       * <code>int32 creation_quota_tokens_charged = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The creationQuotaTokensCharged.
       */
      @java.lang.Override
      public int getCreationQuotaTokensCharged() {
        return creationQuotaTokensCharged_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The total quota tokens charged during creation of the
       * report. Because this token count is based on activity from the `CREATING`
       * state, this tokens charge will be fixed once a report task enters the
       * `ACTIVE` or `FAILED` state.
       * </pre>
       *
       * <code>int32 creation_quota_tokens_charged = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The creationQuotaTokensCharged to set.
       * @return This builder for chaining.
       */
      public Builder setCreationQuotaTokensCharged(int value) {

        creationQuotaTokensCharged_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The total quota tokens charged during creation of the
       * report. Because this token count is based on activity from the `CREATING`
       * state, this tokens charge will be fixed once a report task enters the
       * `ACTIVE` or `FAILED` state.
       * </pre>
       *
       * <code>int32 creation_quota_tokens_charged = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCreationQuotaTokensCharged() {
        bitField0_ = (bitField0_ & ~0x00000004);
        creationQuotaTokensCharged_ = 0;
        onChanged();
        return this;
      }

      private int taskRowCount_;
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in the report result. This field
       * will be populated when the state is active. You can utilize
       * `task_row_count` for pagination within the confines of their existing
       * report.
       * </pre>
       *
       * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the taskRowCount field is set.
       */
      @java.lang.Override
      public boolean hasTaskRowCount() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in the report result. This field
       * will be populated when the state is active. You can utilize
       * `task_row_count` for pagination within the confines of their existing
       * report.
       * </pre>
       *
       * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The taskRowCount.
       */
      @java.lang.Override
      public int getTaskRowCount() {
        return taskRowCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in the report result. This field
       * will be populated when the state is active. You can utilize
       * `task_row_count` for pagination within the confines of their existing
       * report.
       * </pre>
       *
       * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The taskRowCount to set.
       * @return This builder for chaining.
       */
      public Builder setTaskRowCount(int value) {

        taskRowCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in the report result. This field
       * will be populated when the state is active. You can utilize
       * `task_row_count` for pagination within the confines of their existing
       * report.
       * </pre>
       *
       * <code>optional int32 task_row_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTaskRowCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        taskRowCount_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Error message is populated if a report task fails during
       * creation.
       * </pre>
       *
       * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the errorMessage field is set.
       */
      public boolean hasErrorMessage() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Error message is populated if a report task fails during
       * creation.
       * </pre>
       *
       * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Error message is populated if a report task fails during
       * creation.
       * </pre>
       *
       * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Error message is populated if a report task fails during
       * creation.
       * </pre>
       *
       * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorMessage_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Error message is populated if a report task fails during
       * creation.
       * </pre>
       *
       * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        errorMessage_ = getDefaultInstance().getErrorMessage();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Error message is populated if a report task fails during
       * creation.
       * </pre>
       *
       * <code>optional string error_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        errorMessage_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private int totalRowCount_;
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in Google Analytics storage. If you
       * want to query additional data rows beyond the current report, they can
       * initiate a new report task based on the `total_row_count`.
       *
       * The `task_row_count` represents the number of rows specifically
       * pertaining to the current report, whereas `total_row_count` encompasses
       * the total count of rows across all data retrieved from Google
       * Analytics storage.
       *
       * For example, suppose the current report's `task_row_count` is 20,
       * displaying the data from the first 20 rows. Simultaneously, the
       * `total_row_count` is 30, indicating the presence of data for all 30 rows.
       * The `task_row_count` can be utilizated to paginate through the initial 20
       * rows. To expand the report and include data from all 30 rows, a new
       * report task can be created using the total_row_count to access the full
       * set of 30 rows' worth of data.
       * </pre>
       *
       * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the totalRowCount field is set.
       */
      @java.lang.Override
      public boolean hasTotalRowCount() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in Google Analytics storage. If you
       * want to query additional data rows beyond the current report, they can
       * initiate a new report task based on the `total_row_count`.
       *
       * The `task_row_count` represents the number of rows specifically
       * pertaining to the current report, whereas `total_row_count` encompasses
       * the total count of rows across all data retrieved from Google
       * Analytics storage.
       *
       * For example, suppose the current report's `task_row_count` is 20,
       * displaying the data from the first 20 rows. Simultaneously, the
       * `total_row_count` is 30, indicating the presence of data for all 30 rows.
       * The `task_row_count` can be utilizated to paginate through the initial 20
       * rows. To expand the report and include data from all 30 rows, a new
       * report task can be created using the total_row_count to access the full
       * set of 30 rows' worth of data.
       * </pre>
       *
       * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The totalRowCount.
       */
      @java.lang.Override
      public int getTotalRowCount() {
        return totalRowCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in Google Analytics storage. If you
       * want to query additional data rows beyond the current report, they can
       * initiate a new report task based on the `total_row_count`.
       *
       * The `task_row_count` represents the number of rows specifically
       * pertaining to the current report, whereas `total_row_count` encompasses
       * the total count of rows across all data retrieved from Google
       * Analytics storage.
       *
       * For example, suppose the current report's `task_row_count` is 20,
       * displaying the data from the first 20 rows. Simultaneously, the
       * `total_row_count` is 30, indicating the presence of data for all 30 rows.
       * The `task_row_count` can be utilizated to paginate through the initial 20
       * rows. To expand the report and include data from all 30 rows, a new
       * report task can be created using the total_row_count to access the full
       * set of 30 rows' worth of data.
       * </pre>
       *
       * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The totalRowCount to set.
       * @return This builder for chaining.
       */
      public Builder setTotalRowCount(int value) {

        totalRowCount_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The total number of rows in Google Analytics storage. If you
       * want to query additional data rows beyond the current report, they can
       * initiate a new report task based on the `total_row_count`.
       *
       * The `task_row_count` represents the number of rows specifically
       * pertaining to the current report, whereas `total_row_count` encompasses
       * the total count of rows across all data retrieved from Google
       * Analytics storage.
       *
       * For example, suppose the current report's `task_row_count` is 20,
       * displaying the data from the first 20 rows. Simultaneously, the
       * `total_row_count` is 30, indicating the presence of data for all 30 rows.
       * The `task_row_count` can be utilizated to paginate through the initial 20
       * rows. To expand the report and include data from all 30 rows, a new
       * report task can be created using the total_row_count to access the full
       * set of 30 rows' worth of data.
       * </pre>
       *
       * <code>optional int32 total_row_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalRowCount() {
        bitField0_ = (bitField0_ & ~0x00000020);
        totalRowCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.ReportTask.ReportMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.ReportTask.ReportMetadata)
    private static final com.google.analytics.data.v1alpha.ReportTask.ReportMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.ReportTask.ReportMetadata();
    }

    public static com.google.analytics.data.v1alpha.ReportTask.ReportMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReportMetadata> PARSER =
        new com.google.protobuf.AbstractParser<ReportMetadata>() {
          @java.lang.Override
          public ReportMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReportMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReportMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The report task resource name assigned during
   * creation. Format: "properties/{property}/reportTasks/{report_task}"
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The report task resource name assigned during
   * creation. Format: "properties/{property}/reportTasks/{report_task}"
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPORT_DEFINITION_FIELD_NUMBER = 2;
  private com.google.analytics.data.v1alpha.ReportTask.ReportDefinition reportDefinition_;
  /**
   *
   *
   * <pre>
   * Optional. A report definition to fetch report data, which describes the
   * structure of a report. It typically includes the fields that will be
   * included in the report and the criteria that will be used to filter the
   * data.
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the reportDefinition field is set.
   */
  @java.lang.Override
  public boolean hasReportDefinition() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. A report definition to fetch report data, which describes the
   * structure of a report. It typically includes the fields that will be
   * included in the report and the criteria that will be used to filter the
   * data.
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The reportDefinition.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition getReportDefinition() {
    return reportDefinition_ == null
        ? com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.getDefaultInstance()
        : reportDefinition_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A report definition to fetch report data, which describes the
   * structure of a report. It typically includes the fields that will be
   * included in the report and the criteria that will be used to filter the
   * data.
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.ReportTask.ReportDefinitionOrBuilder
      getReportDefinitionOrBuilder() {
    return reportDefinition_ == null
        ? com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.getDefaultInstance()
        : reportDefinition_;
  }

  public static final int REPORT_METADATA_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1alpha.ReportTask.ReportMetadata reportMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. The report metadata for a specific report task, which provides
   * information about a report.  It typically includes the following
   * information: the resource name of the report, the state of the report, the
   * timestamp the report was created, etc,
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the reportMetadata field is set.
   */
  @java.lang.Override
  public boolean hasReportMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The report metadata for a specific report task, which provides
   * information about a report.  It typically includes the following
   * information: the resource name of the report, the state of the report, the
   * timestamp the report was created, etc,
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The reportMetadata.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata getReportMetadata() {
    return reportMetadata_ == null
        ? com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDefaultInstance()
        : reportMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The report metadata for a specific report task, which provides
   * information about a report.  It typically includes the following
   * information: the resource name of the report, the state of the report, the
   * timestamp the report was created, etc,
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.ReportTask.ReportMetadataOrBuilder
      getReportMetadataOrBuilder() {
    return reportMetadata_ == null
        ? com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDefaultInstance()
        : reportMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getReportDefinition());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getReportMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReportDefinition());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReportMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.ReportTask)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.ReportTask other =
        (com.google.analytics.data.v1alpha.ReportTask) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasReportDefinition() != other.hasReportDefinition()) return false;
    if (hasReportDefinition()) {
      if (!getReportDefinition().equals(other.getReportDefinition())) return false;
    }
    if (hasReportMetadata() != other.hasReportMetadata()) return false;
    if (hasReportMetadata()) {
      if (!getReportMetadata().equals(other.getReportMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasReportDefinition()) {
      hash = (37 * hash) + REPORT_DEFINITION_FIELD_NUMBER;
      hash = (53 * hash) + getReportDefinition().hashCode();
    }
    if (hasReportMetadata()) {
      hash = (37 * hash) + REPORT_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getReportMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.ReportTask parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.ReportTask prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A specific report task configuration.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.ReportTask}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.ReportTask)
      com.google.analytics.data.v1alpha.ReportTaskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.ReportTask.class,
              com.google.analytics.data.v1alpha.ReportTask.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.ReportTask.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReportDefinitionFieldBuilder();
        getReportMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      reportDefinition_ = null;
      if (reportDefinitionBuilder_ != null) {
        reportDefinitionBuilder_.dispose();
        reportDefinitionBuilder_ = null;
      }
      reportMetadata_ = null;
      if (reportMetadataBuilder_ != null) {
        reportMetadataBuilder_.dispose();
        reportMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_ReportTask_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ReportTask getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.ReportTask.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ReportTask build() {
      com.google.analytics.data.v1alpha.ReportTask result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.ReportTask buildPartial() {
      com.google.analytics.data.v1alpha.ReportTask result =
          new com.google.analytics.data.v1alpha.ReportTask(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.ReportTask result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.reportDefinition_ =
            reportDefinitionBuilder_ == null ? reportDefinition_ : reportDefinitionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.reportMetadata_ =
            reportMetadataBuilder_ == null ? reportMetadata_ : reportMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.ReportTask) {
        return mergeFrom((com.google.analytics.data.v1alpha.ReportTask) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.ReportTask other) {
      if (other == com.google.analytics.data.v1alpha.ReportTask.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasReportDefinition()) {
        mergeReportDefinition(other.getReportDefinition());
      }
      if (other.hasReportMetadata()) {
        mergeReportMetadata(other.getReportMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getReportDefinitionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getReportMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The report task resource name assigned during
     * creation. Format: "properties/{property}/reportTasks/{report_task}"
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The report task resource name assigned during
     * creation. Format: "properties/{property}/reportTasks/{report_task}"
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The report task resource name assigned during
     * creation. Format: "properties/{property}/reportTasks/{report_task}"
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The report task resource name assigned during
     * creation. Format: "properties/{property}/reportTasks/{report_task}"
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The report task resource name assigned during
     * creation. Format: "properties/{property}/reportTasks/{report_task}"
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.ReportTask.ReportDefinition reportDefinition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.ReportTask.ReportDefinition,
            com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder,
            com.google.analytics.data.v1alpha.ReportTask.ReportDefinitionOrBuilder>
        reportDefinitionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reportDefinition field is set.
     */
    public boolean hasReportDefinition() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reportDefinition.
     */
    public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition getReportDefinition() {
      if (reportDefinitionBuilder_ == null) {
        return reportDefinition_ == null
            ? com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.getDefaultInstance()
            : reportDefinition_;
      } else {
        return reportDefinitionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReportDefinition(
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinition value) {
      if (reportDefinitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportDefinition_ = value;
      } else {
        reportDefinitionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReportDefinition(
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder builderForValue) {
      if (reportDefinitionBuilder_ == null) {
        reportDefinition_ = builderForValue.build();
      } else {
        reportDefinitionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReportDefinition(
        com.google.analytics.data.v1alpha.ReportTask.ReportDefinition value) {
      if (reportDefinitionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && reportDefinition_ != null
            && reportDefinition_
                != com.google.analytics.data.v1alpha.ReportTask.ReportDefinition
                    .getDefaultInstance()) {
          getReportDefinitionBuilder().mergeFrom(value);
        } else {
          reportDefinition_ = value;
        }
      } else {
        reportDefinitionBuilder_.mergeFrom(value);
      }
      if (reportDefinition_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReportDefinition() {
      bitField0_ = (bitField0_ & ~0x00000002);
      reportDefinition_ = null;
      if (reportDefinitionBuilder_ != null) {
        reportDefinitionBuilder_.dispose();
        reportDefinitionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder
        getReportDefinitionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getReportDefinitionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.analytics.data.v1alpha.ReportTask.ReportDefinitionOrBuilder
        getReportDefinitionOrBuilder() {
      if (reportDefinitionBuilder_ != null) {
        return reportDefinitionBuilder_.getMessageOrBuilder();
      } else {
        return reportDefinition_ == null
            ? com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.getDefaultInstance()
            : reportDefinition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A report definition to fetch report data, which describes the
     * structure of a report. It typically includes the fields that will be
     * included in the report and the criteria that will be used to filter the
     * data.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportDefinition report_definition = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.ReportTask.ReportDefinition,
            com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder,
            com.google.analytics.data.v1alpha.ReportTask.ReportDefinitionOrBuilder>
        getReportDefinitionFieldBuilder() {
      if (reportDefinitionBuilder_ == null) {
        reportDefinitionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.ReportTask.ReportDefinition,
                com.google.analytics.data.v1alpha.ReportTask.ReportDefinition.Builder,
                com.google.analytics.data.v1alpha.ReportTask.ReportDefinitionOrBuilder>(
                getReportDefinition(), getParentForChildren(), isClean());
        reportDefinition_ = null;
      }
      return reportDefinitionBuilder_;
    }

    private com.google.analytics.data.v1alpha.ReportTask.ReportMetadata reportMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadata,
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder,
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadataOrBuilder>
        reportMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the reportMetadata field is set.
     */
    public boolean hasReportMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The reportMetadata.
     */
    public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata getReportMetadata() {
      if (reportMetadataBuilder_ == null) {
        return reportMetadata_ == null
            ? com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDefaultInstance()
            : reportMetadata_;
      } else {
        return reportMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setReportMetadata(
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata value) {
      if (reportMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportMetadata_ = value;
      } else {
        reportMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setReportMetadata(
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder builderForValue) {
      if (reportMetadataBuilder_ == null) {
        reportMetadata_ = builderForValue.build();
      } else {
        reportMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeReportMetadata(
        com.google.analytics.data.v1alpha.ReportTask.ReportMetadata value) {
      if (reportMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && reportMetadata_ != null
            && reportMetadata_
                != com.google.analytics.data.v1alpha.ReportTask.ReportMetadata
                    .getDefaultInstance()) {
          getReportMetadataBuilder().mergeFrom(value);
        } else {
          reportMetadata_ = value;
        }
      } else {
        reportMetadataBuilder_.mergeFrom(value);
      }
      if (reportMetadata_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearReportMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      reportMetadata_ = null;
      if (reportMetadataBuilder_ != null) {
        reportMetadataBuilder_.dispose();
        reportMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder
        getReportMetadataBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReportMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.analytics.data.v1alpha.ReportTask.ReportMetadataOrBuilder
        getReportMetadataOrBuilder() {
      if (reportMetadataBuilder_ != null) {
        return reportMetadataBuilder_.getMessageOrBuilder();
      } else {
        return reportMetadata_ == null
            ? com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.getDefaultInstance()
            : reportMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The report metadata for a specific report task, which provides
     * information about a report.  It typically includes the following
     * information: the resource name of the report, the state of the report, the
     * timestamp the report was created, etc,
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.ReportTask.ReportMetadata report_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadata,
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder,
            com.google.analytics.data.v1alpha.ReportTask.ReportMetadataOrBuilder>
        getReportMetadataFieldBuilder() {
      if (reportMetadataBuilder_ == null) {
        reportMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.ReportTask.ReportMetadata,
                com.google.analytics.data.v1alpha.ReportTask.ReportMetadata.Builder,
                com.google.analytics.data.v1alpha.ReportTask.ReportMetadataOrBuilder>(
                getReportMetadata(), getParentForChildren(), isClean());
        reportMetadata_ = null;
      }
      return reportMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.ReportTask)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.ReportTask)
  private static final com.google.analytics.data.v1alpha.ReportTask DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.ReportTask();
  }

  public static com.google.analytics.data.v1alpha.ReportTask getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportTask> PARSER =
      new com.google.protobuf.AbstractParser<ReportTask>() {
        @java.lang.Override
        public ReportTask parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportTask> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportTask> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.ReportTask getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
