/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

// Protobuf Java Version: 3.25.3
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * A condition that must occur in the specified step order for this user
 * to match the sequence.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.UserSequenceStep}
 */
public final class UserSequenceStep extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.UserSequenceStep)
    UserSequenceStepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserSequenceStep.newBuilder() to construct.
  private UserSequenceStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserSequenceStep() {
    stepScoping_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserSequenceStep();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_UserSequenceStep_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_UserSequenceStep_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.UserSequenceStep.class,
            com.google.analytics.data.v1alpha.UserSequenceStep.Builder.class);
  }

  private int bitField0_;
  public static final int IS_DIRECTLY_FOLLOWED_BY_FIELD_NUMBER = 1;
  private boolean isDirectlyFollowedBy_ = false;
  /**
   *
   *
   * <pre>
   * If true, the event satisfying this step must be the very next event
   * after the event satifying the last step. If false, this step indirectly
   * follows the prior step; for example, there may be events between the
   * prior step and this step. `isDirectlyFollowedBy` must be false for
   * the first step.
   * </pre>
   *
   * <code>bool is_directly_followed_by = 1;</code>
   *
   * @return The isDirectlyFollowedBy.
   */
  @java.lang.Override
  public boolean getIsDirectlyFollowedBy() {
    return isDirectlyFollowedBy_;
  }

  public static final int STEP_SCOPING_FIELD_NUMBER = 2;
  private int stepScoping_ = 0;
  /**
   *
   *
   * <pre>
   * This sequence step must be satisfied in the scoping for the user to
   * match the sequence. For example if `sequenceScoping =
   * WITHIN_SAME_SESSION`, this sequence steps must complete within one
   * session for the user to match the sequence. `stepScoping =
   * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
   * ACROSS_ALL_SESSIONS`.
   *
   * Optional. If unspecified, `stepScoping` uses the same
   * `UserCriteriaScoping` as the `sequenceScoping`.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
   *
   * @return The enum numeric value on the wire for stepScoping.
   */
  @java.lang.Override
  public int getStepScopingValue() {
    return stepScoping_;
  }
  /**
   *
   *
   * <pre>
   * This sequence step must be satisfied in the scoping for the user to
   * match the sequence. For example if `sequenceScoping =
   * WITHIN_SAME_SESSION`, this sequence steps must complete within one
   * session for the user to match the sequence. `stepScoping =
   * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
   * ACROSS_ALL_SESSIONS`.
   *
   * Optional. If unspecified, `stepScoping` uses the same
   * `UserCriteriaScoping` as the `sequenceScoping`.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
   *
   * @return The stepScoping.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserCriteriaScoping getStepScoping() {
    com.google.analytics.data.v1alpha.UserCriteriaScoping result =
        com.google.analytics.data.v1alpha.UserCriteriaScoping.forNumber(stepScoping_);
    return result == null
        ? com.google.analytics.data.v1alpha.UserCriteriaScoping.UNRECOGNIZED
        : result;
  }

  public static final int SEGMENT_FILTER_EXPRESSION_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1alpha.SegmentFilterExpression segmentFilterExpression_;
  /**
   *
   *
   * <pre>
   * A user matches this sequence step if their events match this
   * expression. Expressions express criteria on dimension, metrics,
   * and/or parameters.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
   * </code>
   *
   * @return Whether the segmentFilterExpression field is set.
   */
  @java.lang.Override
  public boolean hasSegmentFilterExpression() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A user matches this sequence step if their events match this
   * expression. Expressions express criteria on dimension, metrics,
   * and/or parameters.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
   * </code>
   *
   * @return The segmentFilterExpression.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SegmentFilterExpression getSegmentFilterExpression() {
    return segmentFilterExpression_ == null
        ? com.google.analytics.data.v1alpha.SegmentFilterExpression.getDefaultInstance()
        : segmentFilterExpression_;
  }
  /**
   *
   *
   * <pre>
   * A user matches this sequence step if their events match this
   * expression. Expressions express criteria on dimension, metrics,
   * and/or parameters.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SegmentFilterExpressionOrBuilder
      getSegmentFilterExpressionOrBuilder() {
    return segmentFilterExpression_ == null
        ? com.google.analytics.data.v1alpha.SegmentFilterExpression.getDefaultInstance()
        : segmentFilterExpression_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (isDirectlyFollowedBy_ != false) {
      output.writeBool(1, isDirectlyFollowedBy_);
    }
    if (stepScoping_
        != com.google.analytics.data.v1alpha.UserCriteriaScoping.USER_CRITERIA_SCOPING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, stepScoping_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSegmentFilterExpression());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (isDirectlyFollowedBy_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, isDirectlyFollowedBy_);
    }
    if (stepScoping_
        != com.google.analytics.data.v1alpha.UserCriteriaScoping.USER_CRITERIA_SCOPING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, stepScoping_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSegmentFilterExpression());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.UserSequenceStep)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.UserSequenceStep other =
        (com.google.analytics.data.v1alpha.UserSequenceStep) obj;

    if (getIsDirectlyFollowedBy() != other.getIsDirectlyFollowedBy()) return false;
    if (stepScoping_ != other.stepScoping_) return false;
    if (hasSegmentFilterExpression() != other.hasSegmentFilterExpression()) return false;
    if (hasSegmentFilterExpression()) {
      if (!getSegmentFilterExpression().equals(other.getSegmentFilterExpression())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IS_DIRECTLY_FOLLOWED_BY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDirectlyFollowedBy());
    hash = (37 * hash) + STEP_SCOPING_FIELD_NUMBER;
    hash = (53 * hash) + stepScoping_;
    if (hasSegmentFilterExpression()) {
      hash = (37 * hash) + SEGMENT_FILTER_EXPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentFilterExpression().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.UserSequenceStep prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A condition that must occur in the specified step order for this user
   * to match the sequence.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.UserSequenceStep}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.UserSequenceStep)
      com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_UserSequenceStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_UserSequenceStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.UserSequenceStep.class,
              com.google.analytics.data.v1alpha.UserSequenceStep.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.UserSequenceStep.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSegmentFilterExpressionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      isDirectlyFollowedBy_ = false;
      stepScoping_ = 0;
      segmentFilterExpression_ = null;
      if (segmentFilterExpressionBuilder_ != null) {
        segmentFilterExpressionBuilder_.dispose();
        segmentFilterExpressionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_UserSequenceStep_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSequenceStep getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.UserSequenceStep.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSequenceStep build() {
      com.google.analytics.data.v1alpha.UserSequenceStep result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSequenceStep buildPartial() {
      com.google.analytics.data.v1alpha.UserSequenceStep result =
          new com.google.analytics.data.v1alpha.UserSequenceStep(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.UserSequenceStep result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.isDirectlyFollowedBy_ = isDirectlyFollowedBy_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.stepScoping_ = stepScoping_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.segmentFilterExpression_ =
            segmentFilterExpressionBuilder_ == null
                ? segmentFilterExpression_
                : segmentFilterExpressionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.UserSequenceStep) {
        return mergeFrom((com.google.analytics.data.v1alpha.UserSequenceStep) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.UserSequenceStep other) {
      if (other == com.google.analytics.data.v1alpha.UserSequenceStep.getDefaultInstance())
        return this;
      if (other.getIsDirectlyFollowedBy() != false) {
        setIsDirectlyFollowedBy(other.getIsDirectlyFollowedBy());
      }
      if (other.stepScoping_ != 0) {
        setStepScopingValue(other.getStepScopingValue());
      }
      if (other.hasSegmentFilterExpression()) {
        mergeSegmentFilterExpression(other.getSegmentFilterExpression());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                isDirectlyFollowedBy_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                stepScoping_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getSegmentFilterExpressionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean isDirectlyFollowedBy_;
    /**
     *
     *
     * <pre>
     * If true, the event satisfying this step must be the very next event
     * after the event satifying the last step. If false, this step indirectly
     * follows the prior step; for example, there may be events between the
     * prior step and this step. `isDirectlyFollowedBy` must be false for
     * the first step.
     * </pre>
     *
     * <code>bool is_directly_followed_by = 1;</code>
     *
     * @return The isDirectlyFollowedBy.
     */
    @java.lang.Override
    public boolean getIsDirectlyFollowedBy() {
      return isDirectlyFollowedBy_;
    }
    /**
     *
     *
     * <pre>
     * If true, the event satisfying this step must be the very next event
     * after the event satifying the last step. If false, this step indirectly
     * follows the prior step; for example, there may be events between the
     * prior step and this step. `isDirectlyFollowedBy` must be false for
     * the first step.
     * </pre>
     *
     * <code>bool is_directly_followed_by = 1;</code>
     *
     * @param value The isDirectlyFollowedBy to set.
     * @return This builder for chaining.
     */
    public Builder setIsDirectlyFollowedBy(boolean value) {

      isDirectlyFollowedBy_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the event satisfying this step must be the very next event
     * after the event satifying the last step. If false, this step indirectly
     * follows the prior step; for example, there may be events between the
     * prior step and this step. `isDirectlyFollowedBy` must be false for
     * the first step.
     * </pre>
     *
     * <code>bool is_directly_followed_by = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDirectlyFollowedBy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      isDirectlyFollowedBy_ = false;
      onChanged();
      return this;
    }

    private int stepScoping_ = 0;
    /**
     *
     *
     * <pre>
     * This sequence step must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * WITHIN_SAME_SESSION`, this sequence steps must complete within one
     * session for the user to match the sequence. `stepScoping =
     * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
     * ACROSS_ALL_SESSIONS`.
     *
     * Optional. If unspecified, `stepScoping` uses the same
     * `UserCriteriaScoping` as the `sequenceScoping`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
     *
     * @return The enum numeric value on the wire for stepScoping.
     */
    @java.lang.Override
    public int getStepScopingValue() {
      return stepScoping_;
    }
    /**
     *
     *
     * <pre>
     * This sequence step must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * WITHIN_SAME_SESSION`, this sequence steps must complete within one
     * session for the user to match the sequence. `stepScoping =
     * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
     * ACROSS_ALL_SESSIONS`.
     *
     * Optional. If unspecified, `stepScoping` uses the same
     * `UserCriteriaScoping` as the `sequenceScoping`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
     *
     * @param value The enum numeric value on the wire for stepScoping to set.
     * @return This builder for chaining.
     */
    public Builder setStepScopingValue(int value) {
      stepScoping_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This sequence step must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * WITHIN_SAME_SESSION`, this sequence steps must complete within one
     * session for the user to match the sequence. `stepScoping =
     * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
     * ACROSS_ALL_SESSIONS`.
     *
     * Optional. If unspecified, `stepScoping` uses the same
     * `UserCriteriaScoping` as the `sequenceScoping`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
     *
     * @return The stepScoping.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserCriteriaScoping getStepScoping() {
      com.google.analytics.data.v1alpha.UserCriteriaScoping result =
          com.google.analytics.data.v1alpha.UserCriteriaScoping.forNumber(stepScoping_);
      return result == null
          ? com.google.analytics.data.v1alpha.UserCriteriaScoping.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This sequence step must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * WITHIN_SAME_SESSION`, this sequence steps must complete within one
     * session for the user to match the sequence. `stepScoping =
     * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
     * ACROSS_ALL_SESSIONS`.
     *
     * Optional. If unspecified, `stepScoping` uses the same
     * `UserCriteriaScoping` as the `sequenceScoping`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
     *
     * @param value The stepScoping to set.
     * @return This builder for chaining.
     */
    public Builder setStepScoping(com.google.analytics.data.v1alpha.UserCriteriaScoping value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      stepScoping_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This sequence step must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * WITHIN_SAME_SESSION`, this sequence steps must complete within one
     * session for the user to match the sequence. `stepScoping =
     * ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
     * ACROSS_ALL_SESSIONS`.
     *
     * Optional. If unspecified, `stepScoping` uses the same
     * `UserCriteriaScoping` as the `sequenceScoping`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping step_scoping = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStepScoping() {
      bitField0_ = (bitField0_ & ~0x00000002);
      stepScoping_ = 0;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.SegmentFilterExpression segmentFilterExpression_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.SegmentFilterExpression,
            com.google.analytics.data.v1alpha.SegmentFilterExpression.Builder,
            com.google.analytics.data.v1alpha.SegmentFilterExpressionOrBuilder>
        segmentFilterExpressionBuilder_;
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     *
     * @return Whether the segmentFilterExpression field is set.
     */
    public boolean hasSegmentFilterExpression() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     *
     * @return The segmentFilterExpression.
     */
    public com.google.analytics.data.v1alpha.SegmentFilterExpression getSegmentFilterExpression() {
      if (segmentFilterExpressionBuilder_ == null) {
        return segmentFilterExpression_ == null
            ? com.google.analytics.data.v1alpha.SegmentFilterExpression.getDefaultInstance()
            : segmentFilterExpression_;
      } else {
        return segmentFilterExpressionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    public Builder setSegmentFilterExpression(
        com.google.analytics.data.v1alpha.SegmentFilterExpression value) {
      if (segmentFilterExpressionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        segmentFilterExpression_ = value;
      } else {
        segmentFilterExpressionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    public Builder setSegmentFilterExpression(
        com.google.analytics.data.v1alpha.SegmentFilterExpression.Builder builderForValue) {
      if (segmentFilterExpressionBuilder_ == null) {
        segmentFilterExpression_ = builderForValue.build();
      } else {
        segmentFilterExpressionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    public Builder mergeSegmentFilterExpression(
        com.google.analytics.data.v1alpha.SegmentFilterExpression value) {
      if (segmentFilterExpressionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && segmentFilterExpression_ != null
            && segmentFilterExpression_
                != com.google.analytics.data.v1alpha.SegmentFilterExpression.getDefaultInstance()) {
          getSegmentFilterExpressionBuilder().mergeFrom(value);
        } else {
          segmentFilterExpression_ = value;
        }
      } else {
        segmentFilterExpressionBuilder_.mergeFrom(value);
      }
      if (segmentFilterExpression_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    public Builder clearSegmentFilterExpression() {
      bitField0_ = (bitField0_ & ~0x00000004);
      segmentFilterExpression_ = null;
      if (segmentFilterExpressionBuilder_ != null) {
        segmentFilterExpressionBuilder_.dispose();
        segmentFilterExpressionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.SegmentFilterExpression.Builder
        getSegmentFilterExpressionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSegmentFilterExpressionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.SegmentFilterExpressionOrBuilder
        getSegmentFilterExpressionOrBuilder() {
      if (segmentFilterExpressionBuilder_ != null) {
        return segmentFilterExpressionBuilder_.getMessageOrBuilder();
      } else {
        return segmentFilterExpression_ == null
            ? com.google.analytics.data.v1alpha.SegmentFilterExpression.getDefaultInstance()
            : segmentFilterExpression_;
      }
    }
    /**
     *
     *
     * <pre>
     * A user matches this sequence step if their events match this
     * expression. Expressions express criteria on dimension, metrics,
     * and/or parameters.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterExpression segment_filter_expression = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.SegmentFilterExpression,
            com.google.analytics.data.v1alpha.SegmentFilterExpression.Builder,
            com.google.analytics.data.v1alpha.SegmentFilterExpressionOrBuilder>
        getSegmentFilterExpressionFieldBuilder() {
      if (segmentFilterExpressionBuilder_ == null) {
        segmentFilterExpressionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.SegmentFilterExpression,
                com.google.analytics.data.v1alpha.SegmentFilterExpression.Builder,
                com.google.analytics.data.v1alpha.SegmentFilterExpressionOrBuilder>(
                getSegmentFilterExpression(), getParentForChildren(), isClean());
        segmentFilterExpression_ = null;
      }
      return segmentFilterExpressionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.UserSequenceStep)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.UserSequenceStep)
  private static final com.google.analytics.data.v1alpha.UserSequenceStep DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.UserSequenceStep();
  }

  public static com.google.analytics.data.v1alpha.UserSequenceStep getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserSequenceStep> PARSER =
      new com.google.protobuf.AbstractParser<UserSequenceStep>() {
        @java.lang.Override
        public UserSequenceStep parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserSequenceStep> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserSequenceStep> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserSequenceStep getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
