/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PropertyName
implements ResourceName {
    private static final PathTemplate PROPERTY_ID = PathTemplate.createWithoutUrlEncoding((String)"properties/{propertyId}");
    private volatile Map<String, String> fieldValuesMap;
    private final String propertyId;

    @Deprecated
    protected PropertyName() {
        this.propertyId = null;
    }

    private PropertyName(Builder builder) {
        this.propertyId = (String)Preconditions.checkNotNull((Object)builder.getPropertyId());
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PropertyName of(String propertyId) {
        return PropertyName.newBuilder().setPropertyId(propertyId).build();
    }

    public static String format(String propertyId) {
        return PropertyName.newBuilder().setPropertyId(propertyId).build().toString();
    }

    public static PropertyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_ID.validatedMatch(formattedString, "PropertyName.parse: formattedString not in valid format");
        return PropertyName.of((String)matchMap.get("propertyId"));
    }

    public static List<PropertyName> parseList(List<String> formattedStrings) {
        ArrayList<PropertyName> list = new ArrayList<PropertyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PropertyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PropertyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PropertyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PropertyName propertyName = this;
            synchronized (propertyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.propertyId != null) {
                        fieldMapBuilder.put((Object)"propertyId", (Object)this.propertyId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_ID.instantiate(new String[]{"propertyId", this.propertyId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PropertyName that = (PropertyName)o;
            return Objects.equals(this.propertyId, that.propertyId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.propertyId);
    }

    public static class Builder {
        private String propertyId;

        protected Builder() {
        }

        public String getPropertyId() {
            return this.propertyId;
        }

        public Builder setPropertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        private Builder(PropertyName propertyName) {
            this.propertyId = propertyName.propertyId;
        }

        public PropertyName build() {
            return new PropertyName(this);
        }
    }
}

