/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * Funnel sub reports contain the dimension and metric data values. For example,
 * 12 users reached the second step of the funnel.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.FunnelSubReport}
 */
public final class FunnelSubReport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.FunnelSubReport)
    FunnelSubReportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FunnelSubReport.newBuilder() to construct.
  private FunnelSubReport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FunnelSubReport() {
    dimensionHeaders_ = java.util.Collections.emptyList();
    metricHeaders_ = java.util.Collections.emptyList();
    rows_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FunnelSubReport();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_FunnelSubReport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_FunnelSubReport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.FunnelSubReport.class,
            com.google.analytics.data.v1alpha.FunnelSubReport.Builder.class);
  }

  public static final int DIMENSION_HEADERS_FIELD_NUMBER = 1;
  private java.util.List<com.google.analytics.data.v1alpha.DimensionHeader> dimensionHeaders_;
  /**
   *
   *
   * <pre>
   * Describes dimension columns. Funnel reports always include the funnel step
   * dimension in sub report responses. Additional dimensions like breakdowns,
   * dates, and next actions may be present in the response if requested.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.DimensionHeader>
      getDimensionHeadersList() {
    return dimensionHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Describes dimension columns. Funnel reports always include the funnel step
   * dimension in sub report responses. Additional dimensions like breakdowns,
   * dates, and next actions may be present in the response if requested.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder>
      getDimensionHeadersOrBuilderList() {
    return dimensionHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Describes dimension columns. Funnel reports always include the funnel step
   * dimension in sub report responses. Additional dimensions like breakdowns,
   * dates, and next actions may be present in the response if requested.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
   */
  @java.lang.Override
  public int getDimensionHeadersCount() {
    return dimensionHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes dimension columns. Funnel reports always include the funnel step
   * dimension in sub report responses. Additional dimensions like breakdowns,
   * dates, and next actions may be present in the response if requested.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.DimensionHeader getDimensionHeaders(int index) {
    return dimensionHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes dimension columns. Funnel reports always include the funnel step
   * dimension in sub report responses. Additional dimensions like breakdowns,
   * dates, and next actions may be present in the response if requested.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder getDimensionHeadersOrBuilder(
      int index) {
    return dimensionHeaders_.get(index);
  }

  public static final int METRIC_HEADERS_FIELD_NUMBER = 2;
  private java.util.List<com.google.analytics.data.v1alpha.MetricHeader> metricHeaders_;
  /**
   *
   *
   * <pre>
   * Describes metric columns. Funnel reports always include active users in sub
   * report responses. The funnel table includes additional metrics like
   * completion rate, abandonments, and abandonments rate.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.MetricHeader> getMetricHeadersList() {
    return metricHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Describes metric columns. Funnel reports always include active users in sub
   * report responses. The funnel table includes additional metrics like
   * completion rate, abandonments, and abandonments rate.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.MetricHeaderOrBuilder>
      getMetricHeadersOrBuilderList() {
    return metricHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Describes metric columns. Funnel reports always include active users in sub
   * report responses. The funnel table includes additional metrics like
   * completion rate, abandonments, and abandonments rate.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
   */
  @java.lang.Override
  public int getMetricHeadersCount() {
    return metricHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes metric columns. Funnel reports always include active users in sub
   * report responses. The funnel table includes additional metrics like
   * completion rate, abandonments, and abandonments rate.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.MetricHeader getMetricHeaders(int index) {
    return metricHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes metric columns. Funnel reports always include active users in sub
   * report responses. The funnel table includes additional metrics like
   * completion rate, abandonments, and abandonments rate.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.MetricHeaderOrBuilder getMetricHeadersOrBuilder(
      int index) {
    return metricHeaders_.get(index);
  }

  public static final int ROWS_FIELD_NUMBER = 3;
  private java.util.List<com.google.analytics.data.v1alpha.Row> rows_;
  /**
   *
   *
   * <pre>
   * Rows of dimension value combinations and metric values in the report.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.Row> getRowsList() {
    return rows_;
  }
  /**
   *
   *
   * <pre>
   * Rows of dimension value combinations and metric values in the report.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.RowOrBuilder>
      getRowsOrBuilderList() {
    return rows_;
  }
  /**
   *
   *
   * <pre>
   * Rows of dimension value combinations and metric values in the report.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
   */
  @java.lang.Override
  public int getRowsCount() {
    return rows_.size();
  }
  /**
   *
   *
   * <pre>
   * Rows of dimension value combinations and metric values in the report.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.Row getRows(int index) {
    return rows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Rows of dimension value combinations and metric values in the report.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.RowOrBuilder getRowsOrBuilder(int index) {
    return rows_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1alpha.FunnelResponseMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Metadata for the funnel report.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the funnel report.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.analytics.data.v1alpha.FunnelResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the funnel report.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelResponseMetadataOrBuilder getMetadataOrBuilder() {
    return getMetadata();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < dimensionHeaders_.size(); i++) {
      output.writeMessage(1, dimensionHeaders_.get(i));
    }
    for (int i = 0; i < metricHeaders_.size(); i++) {
      output.writeMessage(2, metricHeaders_.get(i));
    }
    for (int i = 0; i < rows_.size(); i++) {
      output.writeMessage(3, rows_.get(i));
    }
    if (metadata_ != null) {
      output.writeMessage(4, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < dimensionHeaders_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, dimensionHeaders_.get(i));
    }
    for (int i = 0; i < metricHeaders_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, metricHeaders_.get(i));
    }
    for (int i = 0; i < rows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, rows_.get(i));
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.FunnelSubReport)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.FunnelSubReport other =
        (com.google.analytics.data.v1alpha.FunnelSubReport) obj;

    if (!getDimensionHeadersList().equals(other.getDimensionHeadersList())) return false;
    if (!getMetricHeadersList().equals(other.getMetricHeadersList())) return false;
    if (!getRowsList().equals(other.getRowsList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDimensionHeadersCount() > 0) {
      hash = (37 * hash) + DIMENSION_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionHeadersList().hashCode();
    }
    if (getMetricHeadersCount() > 0) {
      hash = (37 * hash) + METRIC_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricHeadersList().hashCode();
    }
    if (getRowsCount() > 0) {
      hash = (37 * hash) + ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getRowsList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.FunnelSubReport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Funnel sub reports contain the dimension and metric data values. For example,
   * 12 users reached the second step of the funnel.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.FunnelSubReport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.FunnelSubReport)
      com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_FunnelSubReport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_FunnelSubReport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.FunnelSubReport.class,
              com.google.analytics.data.v1alpha.FunnelSubReport.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.FunnelSubReport.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (dimensionHeadersBuilder_ == null) {
        dimensionHeaders_ = java.util.Collections.emptyList();
      } else {
        dimensionHeaders_ = null;
        dimensionHeadersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (metricHeadersBuilder_ == null) {
        metricHeaders_ = java.util.Collections.emptyList();
      } else {
        metricHeaders_ = null;
        metricHeadersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
      } else {
        rows_ = null;
        rowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (metadataBuilder_ == null) {
        metadata_ = null;
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_FunnelSubReport_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.FunnelSubReport getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.FunnelSubReport build() {
      com.google.analytics.data.v1alpha.FunnelSubReport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.FunnelSubReport buildPartial() {
      com.google.analytics.data.v1alpha.FunnelSubReport result =
          new com.google.analytics.data.v1alpha.FunnelSubReport(this);
      int from_bitField0_ = bitField0_;
      if (dimensionHeadersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          dimensionHeaders_ = java.util.Collections.unmodifiableList(dimensionHeaders_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.dimensionHeaders_ = dimensionHeaders_;
      } else {
        result.dimensionHeaders_ = dimensionHeadersBuilder_.build();
      }
      if (metricHeadersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metricHeaders_ = java.util.Collections.unmodifiableList(metricHeaders_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metricHeaders_ = metricHeaders_;
      } else {
        result.metricHeaders_ = metricHeadersBuilder_.build();
      }
      if (rowsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          rows_ = java.util.Collections.unmodifiableList(rows_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.rows_ = rows_;
      } else {
        result.rows_ = rowsBuilder_.build();
      }
      if (metadataBuilder_ == null) {
        result.metadata_ = metadata_;
      } else {
        result.metadata_ = metadataBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.FunnelSubReport) {
        return mergeFrom((com.google.analytics.data.v1alpha.FunnelSubReport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.FunnelSubReport other) {
      if (other == com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance())
        return this;
      if (dimensionHeadersBuilder_ == null) {
        if (!other.dimensionHeaders_.isEmpty()) {
          if (dimensionHeaders_.isEmpty()) {
            dimensionHeaders_ = other.dimensionHeaders_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDimensionHeadersIsMutable();
            dimensionHeaders_.addAll(other.dimensionHeaders_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensionHeaders_.isEmpty()) {
          if (dimensionHeadersBuilder_.isEmpty()) {
            dimensionHeadersBuilder_.dispose();
            dimensionHeadersBuilder_ = null;
            dimensionHeaders_ = other.dimensionHeaders_;
            bitField0_ = (bitField0_ & ~0x00000001);
            dimensionHeadersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionHeadersFieldBuilder()
                    : null;
          } else {
            dimensionHeadersBuilder_.addAllMessages(other.dimensionHeaders_);
          }
        }
      }
      if (metricHeadersBuilder_ == null) {
        if (!other.metricHeaders_.isEmpty()) {
          if (metricHeaders_.isEmpty()) {
            metricHeaders_ = other.metricHeaders_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricHeadersIsMutable();
            metricHeaders_.addAll(other.metricHeaders_);
          }
          onChanged();
        }
      } else {
        if (!other.metricHeaders_.isEmpty()) {
          if (metricHeadersBuilder_.isEmpty()) {
            metricHeadersBuilder_.dispose();
            metricHeadersBuilder_ = null;
            metricHeaders_ = other.metricHeaders_;
            bitField0_ = (bitField0_ & ~0x00000002);
            metricHeadersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricHeadersFieldBuilder()
                    : null;
          } else {
            metricHeadersBuilder_.addAllMessages(other.metricHeaders_);
          }
        }
      }
      if (rowsBuilder_ == null) {
        if (!other.rows_.isEmpty()) {
          if (rows_.isEmpty()) {
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRowsIsMutable();
            rows_.addAll(other.rows_);
          }
          onChanged();
        }
      } else {
        if (!other.rows_.isEmpty()) {
          if (rowsBuilder_.isEmpty()) {
            rowsBuilder_.dispose();
            rowsBuilder_ = null;
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000004);
            rowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowsFieldBuilder()
                    : null;
          } else {
            rowsBuilder_.addAllMessages(other.rows_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.analytics.data.v1alpha.DimensionHeader m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.DimensionHeader.parser(),
                        extensionRegistry);
                if (dimensionHeadersBuilder_ == null) {
                  ensureDimensionHeadersIsMutable();
                  dimensionHeaders_.add(m);
                } else {
                  dimensionHeadersBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.analytics.data.v1alpha.MetricHeader m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.MetricHeader.parser(), extensionRegistry);
                if (metricHeadersBuilder_ == null) {
                  ensureMetricHeadersIsMutable();
                  metricHeaders_.add(m);
                } else {
                  metricHeadersBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.analytics.data.v1alpha.Row m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.Row.parser(), extensionRegistry);
                if (rowsBuilder_ == null) {
                  ensureRowsIsMutable();
                  rows_.add(m);
                } else {
                  rowsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.analytics.data.v1alpha.DimensionHeader> dimensionHeaders_ =
        java.util.Collections.emptyList();

    private void ensureDimensionHeadersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        dimensionHeaders_ =
            new java.util.ArrayList<com.google.analytics.data.v1alpha.DimensionHeader>(
                dimensionHeaders_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.DimensionHeader,
            com.google.analytics.data.v1alpha.DimensionHeader.Builder,
            com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder>
        dimensionHeadersBuilder_;

    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.DimensionHeader>
        getDimensionHeadersList() {
      if (dimensionHeadersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensionHeaders_);
      } else {
        return dimensionHeadersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public int getDimensionHeadersCount() {
      if (dimensionHeadersBuilder_ == null) {
        return dimensionHeaders_.size();
      } else {
        return dimensionHeadersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public com.google.analytics.data.v1alpha.DimensionHeader getDimensionHeaders(int index) {
      if (dimensionHeadersBuilder_ == null) {
        return dimensionHeaders_.get(index);
      } else {
        return dimensionHeadersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder setDimensionHeaders(
        int index, com.google.analytics.data.v1alpha.DimensionHeader value) {
      if (dimensionHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.set(index, value);
        onChanged();
      } else {
        dimensionHeadersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder setDimensionHeaders(
        int index, com.google.analytics.data.v1alpha.DimensionHeader.Builder builderForValue) {
      if (dimensionHeadersBuilder_ == null) {
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionHeadersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder addDimensionHeaders(com.google.analytics.data.v1alpha.DimensionHeader value) {
      if (dimensionHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.add(value);
        onChanged();
      } else {
        dimensionHeadersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder addDimensionHeaders(
        int index, com.google.analytics.data.v1alpha.DimensionHeader value) {
      if (dimensionHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.add(index, value);
        onChanged();
      } else {
        dimensionHeadersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder addDimensionHeaders(
        com.google.analytics.data.v1alpha.DimensionHeader.Builder builderForValue) {
      if (dimensionHeadersBuilder_ == null) {
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionHeadersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder addDimensionHeaders(
        int index, com.google.analytics.data.v1alpha.DimensionHeader.Builder builderForValue) {
      if (dimensionHeadersBuilder_ == null) {
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionHeadersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder addAllDimensionHeaders(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.DimensionHeader> values) {
      if (dimensionHeadersBuilder_ == null) {
        ensureDimensionHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensionHeaders_);
        onChanged();
      } else {
        dimensionHeadersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder clearDimensionHeaders() {
      if (dimensionHeadersBuilder_ == null) {
        dimensionHeaders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        dimensionHeadersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public Builder removeDimensionHeaders(int index) {
      if (dimensionHeadersBuilder_ == null) {
        ensureDimensionHeadersIsMutable();
        dimensionHeaders_.remove(index);
        onChanged();
      } else {
        dimensionHeadersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public com.google.analytics.data.v1alpha.DimensionHeader.Builder getDimensionHeadersBuilder(
        int index) {
      return getDimensionHeadersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder getDimensionHeadersOrBuilder(
        int index) {
      if (dimensionHeadersBuilder_ == null) {
        return dimensionHeaders_.get(index);
      } else {
        return dimensionHeadersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder>
        getDimensionHeadersOrBuilderList() {
      if (dimensionHeadersBuilder_ != null) {
        return dimensionHeadersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensionHeaders_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public com.google.analytics.data.v1alpha.DimensionHeader.Builder addDimensionHeadersBuilder() {
      return getDimensionHeadersFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.DimensionHeader.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public com.google.analytics.data.v1alpha.DimensionHeader.Builder addDimensionHeadersBuilder(
        int index) {
      return getDimensionHeadersFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1alpha.DimensionHeader.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes dimension columns. Funnel reports always include the funnel step
     * dimension in sub report responses. Additional dimensions like breakdowns,
     * dates, and next actions may be present in the response if requested.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DimensionHeader dimension_headers = 1;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.DimensionHeader.Builder>
        getDimensionHeadersBuilderList() {
      return getDimensionHeadersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.DimensionHeader,
            com.google.analytics.data.v1alpha.DimensionHeader.Builder,
            com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder>
        getDimensionHeadersFieldBuilder() {
      if (dimensionHeadersBuilder_ == null) {
        dimensionHeadersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.DimensionHeader,
                com.google.analytics.data.v1alpha.DimensionHeader.Builder,
                com.google.analytics.data.v1alpha.DimensionHeaderOrBuilder>(
                dimensionHeaders_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        dimensionHeaders_ = null;
      }
      return dimensionHeadersBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1alpha.MetricHeader> metricHeaders_ =
        java.util.Collections.emptyList();

    private void ensureMetricHeadersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        metricHeaders_ =
            new java.util.ArrayList<com.google.analytics.data.v1alpha.MetricHeader>(metricHeaders_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.MetricHeader,
            com.google.analytics.data.v1alpha.MetricHeader.Builder,
            com.google.analytics.data.v1alpha.MetricHeaderOrBuilder>
        metricHeadersBuilder_;

    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.MetricHeader> getMetricHeadersList() {
      if (metricHeadersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metricHeaders_);
      } else {
        return metricHeadersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public int getMetricHeadersCount() {
      if (metricHeadersBuilder_ == null) {
        return metricHeaders_.size();
      } else {
        return metricHeadersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public com.google.analytics.data.v1alpha.MetricHeader getMetricHeaders(int index) {
      if (metricHeadersBuilder_ == null) {
        return metricHeaders_.get(index);
      } else {
        return metricHeadersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder setMetricHeaders(
        int index, com.google.analytics.data.v1alpha.MetricHeader value) {
      if (metricHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricHeadersIsMutable();
        metricHeaders_.set(index, value);
        onChanged();
      } else {
        metricHeadersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder setMetricHeaders(
        int index, com.google.analytics.data.v1alpha.MetricHeader.Builder builderForValue) {
      if (metricHeadersBuilder_ == null) {
        ensureMetricHeadersIsMutable();
        metricHeaders_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricHeadersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder addMetricHeaders(com.google.analytics.data.v1alpha.MetricHeader value) {
      if (metricHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricHeadersIsMutable();
        metricHeaders_.add(value);
        onChanged();
      } else {
        metricHeadersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder addMetricHeaders(
        int index, com.google.analytics.data.v1alpha.MetricHeader value) {
      if (metricHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricHeadersIsMutable();
        metricHeaders_.add(index, value);
        onChanged();
      } else {
        metricHeadersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder addMetricHeaders(
        com.google.analytics.data.v1alpha.MetricHeader.Builder builderForValue) {
      if (metricHeadersBuilder_ == null) {
        ensureMetricHeadersIsMutable();
        metricHeaders_.add(builderForValue.build());
        onChanged();
      } else {
        metricHeadersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder addMetricHeaders(
        int index, com.google.analytics.data.v1alpha.MetricHeader.Builder builderForValue) {
      if (metricHeadersBuilder_ == null) {
        ensureMetricHeadersIsMutable();
        metricHeaders_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricHeadersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder addAllMetricHeaders(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.MetricHeader> values) {
      if (metricHeadersBuilder_ == null) {
        ensureMetricHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metricHeaders_);
        onChanged();
      } else {
        metricHeadersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder clearMetricHeaders() {
      if (metricHeadersBuilder_ == null) {
        metricHeaders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        metricHeadersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public Builder removeMetricHeaders(int index) {
      if (metricHeadersBuilder_ == null) {
        ensureMetricHeadersIsMutable();
        metricHeaders_.remove(index);
        onChanged();
      } else {
        metricHeadersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public com.google.analytics.data.v1alpha.MetricHeader.Builder getMetricHeadersBuilder(
        int index) {
      return getMetricHeadersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public com.google.analytics.data.v1alpha.MetricHeaderOrBuilder getMetricHeadersOrBuilder(
        int index) {
      if (metricHeadersBuilder_ == null) {
        return metricHeaders_.get(index);
      } else {
        return metricHeadersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.MetricHeaderOrBuilder>
        getMetricHeadersOrBuilderList() {
      if (metricHeadersBuilder_ != null) {
        return metricHeadersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metricHeaders_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public com.google.analytics.data.v1alpha.MetricHeader.Builder addMetricHeadersBuilder() {
      return getMetricHeadersFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.MetricHeader.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public com.google.analytics.data.v1alpha.MetricHeader.Builder addMetricHeadersBuilder(
        int index) {
      return getMetricHeadersFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1alpha.MetricHeader.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes metric columns. Funnel reports always include active users in sub
     * report responses. The funnel table includes additional metrics like
     * completion rate, abandonments, and abandonments rate.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.MetricHeader metric_headers = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.MetricHeader.Builder>
        getMetricHeadersBuilderList() {
      return getMetricHeadersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.MetricHeader,
            com.google.analytics.data.v1alpha.MetricHeader.Builder,
            com.google.analytics.data.v1alpha.MetricHeaderOrBuilder>
        getMetricHeadersFieldBuilder() {
      if (metricHeadersBuilder_ == null) {
        metricHeadersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.MetricHeader,
                com.google.analytics.data.v1alpha.MetricHeader.Builder,
                com.google.analytics.data.v1alpha.MetricHeaderOrBuilder>(
                metricHeaders_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        metricHeaders_ = null;
      }
      return metricHeadersBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1alpha.Row> rows_ =
        java.util.Collections.emptyList();

    private void ensureRowsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        rows_ = new java.util.ArrayList<com.google.analytics.data.v1alpha.Row>(rows_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.Row,
            com.google.analytics.data.v1alpha.Row.Builder,
            com.google.analytics.data.v1alpha.RowOrBuilder>
        rowsBuilder_;

    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.Row> getRowsList() {
      if (rowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rows_);
      } else {
        return rowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public int getRowsCount() {
      if (rowsBuilder_ == null) {
        return rows_.size();
      } else {
        return rowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public com.google.analytics.data.v1alpha.Row getRows(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder setRows(int index, com.google.analytics.data.v1alpha.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.set(index, value);
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder setRows(
        int index, com.google.analytics.data.v1alpha.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder addRows(com.google.analytics.data.v1alpha.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder addRows(int index, com.google.analytics.data.v1alpha.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(index, value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder addRows(com.google.analytics.data.v1alpha.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder addRows(
        int index, com.google.analytics.data.v1alpha.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder addAllRows(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.Row> values) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rows_);
        onChanged();
      } else {
        rowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder clearRows() {
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        rowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public Builder removeRows(int index) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.remove(index);
        onChanged();
      } else {
        rowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public com.google.analytics.data.v1alpha.Row.Builder getRowsBuilder(int index) {
      return getRowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public com.google.analytics.data.v1alpha.RowOrBuilder getRowsOrBuilder(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.RowOrBuilder>
        getRowsOrBuilderList() {
      if (rowsBuilder_ != null) {
        return rowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public com.google.analytics.data.v1alpha.Row.Builder addRowsBuilder() {
      return getRowsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.Row.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public com.google.analytics.data.v1alpha.Row.Builder addRowsBuilder(int index) {
      return getRowsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1alpha.Row.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows of dimension value combinations and metric values in the report.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Row rows = 3;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.Row.Builder> getRowsBuilderList() {
      return getRowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.Row,
            com.google.analytics.data.v1alpha.Row.Builder,
            com.google.analytics.data.v1alpha.RowOrBuilder>
        getRowsFieldBuilder() {
      if (rowsBuilder_ == null) {
        rowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.Row,
                com.google.analytics.data.v1alpha.Row.Builder,
                com.google.analytics.data.v1alpha.RowOrBuilder>(
                rows_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        rows_ = null;
      }
      return rowsBuilder_;
    }

    private com.google.analytics.data.v1alpha.FunnelResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelResponseMetadata,
            com.google.analytics.data.v1alpha.FunnelResponseMetadata.Builder,
            com.google.analytics.data.v1alpha.FunnelResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return metadataBuilder_ != null || metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     *
     * @return The metadata.
     */
    public com.google.analytics.data.v1alpha.FunnelResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.analytics.data.v1alpha.FunnelResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    public Builder setMetadata(com.google.analytics.data.v1alpha.FunnelResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        metadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    public Builder setMetadata(
        com.google.analytics.data.v1alpha.FunnelResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    public Builder mergeMetadata(com.google.analytics.data.v1alpha.FunnelResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (metadata_ != null) {
          metadata_ =
              com.google.analytics.data.v1alpha.FunnelResponseMetadata.newBuilder(metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        metadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        metadata_ = null;
        onChanged();
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelResponseMetadata.Builder getMetadataBuilder() {

      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelResponseMetadataOrBuilder
        getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.analytics.data.v1alpha.FunnelResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for the funnel report.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelResponseMetadata metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelResponseMetadata,
            com.google.analytics.data.v1alpha.FunnelResponseMetadata.Builder,
            com.google.analytics.data.v1alpha.FunnelResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FunnelResponseMetadata,
                com.google.analytics.data.v1alpha.FunnelResponseMetadata.Builder,
                com.google.analytics.data.v1alpha.FunnelResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.FunnelSubReport)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.FunnelSubReport)
  private static final com.google.analytics.data.v1alpha.FunnelSubReport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.FunnelSubReport();
  }

  public static com.google.analytics.data.v1alpha.FunnelSubReport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FunnelSubReport> PARSER =
      new com.google.protobuf.AbstractParser<FunnelSubReport>() {
        @java.lang.Override
        public FunnelSubReport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FunnelSubReport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FunnelSubReport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelSubReport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
