/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * The funnel report response contains two sub reports. The two sub reports are
 * different combinations of dimensions and metrics.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.RunFunnelReportResponse}
 */
public final class RunFunnelReportResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.RunFunnelReportResponse)
    RunFunnelReportResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunFunnelReportResponse.newBuilder() to construct.
  private RunFunnelReportResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunFunnelReportResponse() {
    kind_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunFunnelReportResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RunFunnelReportResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.analytics.data.v1alpha.FunnelSubReport.Builder subBuilder = null;
              if (funnelTable_ != null) {
                subBuilder = funnelTable_.toBuilder();
              }
              funnelTable_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.FunnelSubReport.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(funnelTable_);
                funnelTable_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.analytics.data.v1alpha.FunnelSubReport.Builder subBuilder = null;
              if (funnelVisualization_ != null) {
                subBuilder = funnelVisualization_.toBuilder();
              }
              funnelVisualization_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.FunnelSubReport.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(funnelVisualization_);
                funnelVisualization_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.analytics.data.v1alpha.PropertyQuota.Builder subBuilder = null;
              if (propertyQuota_ != null) {
                subBuilder = propertyQuota_.toBuilder();
              }
              propertyQuota_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.PropertyQuota.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(propertyQuota_);
                propertyQuota_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              kind_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_RunFunnelReportResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_RunFunnelReportResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.RunFunnelReportResponse.class,
            com.google.analytics.data.v1alpha.RunFunnelReportResponse.Builder.class);
  }

  public static final int FUNNEL_TABLE_FIELD_NUMBER = 1;
  private com.google.analytics.data.v1alpha.FunnelSubReport funnelTable_;
  /**
   *
   *
   * <pre>
   * The funnel table is a report with the funnel step, segment, breakdown
   * dimension, active users, completion rate, abandonments, and abandonments
   * rate.
   * The segment dimension is only present in this response if a segment was
   * requested. The breakdown dimension is only present in this response if it
   * was requested.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
   *
   * @return Whether the funnelTable field is set.
   */
  @java.lang.Override
  public boolean hasFunnelTable() {
    return funnelTable_ != null;
  }
  /**
   *
   *
   * <pre>
   * The funnel table is a report with the funnel step, segment, breakdown
   * dimension, active users, completion rate, abandonments, and abandonments
   * rate.
   * The segment dimension is only present in this response if a segment was
   * requested. The breakdown dimension is only present in this response if it
   * was requested.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
   *
   * @return The funnelTable.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelSubReport getFunnelTable() {
    return funnelTable_ == null
        ? com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance()
        : funnelTable_;
  }
  /**
   *
   *
   * <pre>
   * The funnel table is a report with the funnel step, segment, breakdown
   * dimension, active users, completion rate, abandonments, and abandonments
   * rate.
   * The segment dimension is only present in this response if a segment was
   * requested. The breakdown dimension is only present in this response if it
   * was requested.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder getFunnelTableOrBuilder() {
    return getFunnelTable();
  }

  public static final int FUNNEL_VISUALIZATION_FIELD_NUMBER = 2;
  private com.google.analytics.data.v1alpha.FunnelSubReport funnelVisualization_;
  /**
   *
   *
   * <pre>
   * The funnel visualization is a report with the funnel step, segment, date,
   * next action dimension, and active users.
   * The segment dimension is only present in this response if a segment was
   * requested. The date dimension is only present in this response if it was
   * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
   * is only present in the response if it was requested.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
   *
   * @return Whether the funnelVisualization field is set.
   */
  @java.lang.Override
  public boolean hasFunnelVisualization() {
    return funnelVisualization_ != null;
  }
  /**
   *
   *
   * <pre>
   * The funnel visualization is a report with the funnel step, segment, date,
   * next action dimension, and active users.
   * The segment dimension is only present in this response if a segment was
   * requested. The date dimension is only present in this response if it was
   * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
   * is only present in the response if it was requested.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
   *
   * @return The funnelVisualization.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelSubReport getFunnelVisualization() {
    return funnelVisualization_ == null
        ? com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance()
        : funnelVisualization_;
  }
  /**
   *
   *
   * <pre>
   * The funnel visualization is a report with the funnel step, segment, date,
   * next action dimension, and active users.
   * The segment dimension is only present in this response if a segment was
   * requested. The date dimension is only present in this response if it was
   * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
   * is only present in the response if it was requested.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder
      getFunnelVisualizationOrBuilder() {
    return getFunnelVisualization();
  }

  public static final int PROPERTY_QUOTA_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1alpha.PropertyQuota propertyQuota_;
  /**
   *
   *
   * <pre>
   * This Analytics Property's quota state including this request.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
   *
   * @return Whether the propertyQuota field is set.
   */
  @java.lang.Override
  public boolean hasPropertyQuota() {
    return propertyQuota_ != null;
  }
  /**
   *
   *
   * <pre>
   * This Analytics Property's quota state including this request.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
   *
   * @return The propertyQuota.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.PropertyQuota getPropertyQuota() {
    return propertyQuota_ == null
        ? com.google.analytics.data.v1alpha.PropertyQuota.getDefaultInstance()
        : propertyQuota_;
  }
  /**
   *
   *
   * <pre>
   * This Analytics Property's quota state including this request.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.PropertyQuotaOrBuilder getPropertyQuotaOrBuilder() {
    return getPropertyQuota();
  }

  public static final int KIND_FIELD_NUMBER = 4;
  private volatile java.lang.Object kind_;
  /**
   *
   *
   * <pre>
   * Identifies what kind of resource this message is. This `kind` is always the
   * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
   * response types in JSON.
   * </pre>
   *
   * <code>string kind = 4;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifies what kind of resource this message is. This `kind` is always the
   * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
   * response types in JSON.
   * </pre>
   *
   * <code>string kind = 4;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (funnelTable_ != null) {
      output.writeMessage(1, getFunnelTable());
    }
    if (funnelVisualization_ != null) {
      output.writeMessage(2, getFunnelVisualization());
    }
    if (propertyQuota_ != null) {
      output.writeMessage(3, getPropertyQuota());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, kind_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (funnelTable_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFunnelTable());
    }
    if (funnelVisualization_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFunnelVisualization());
    }
    if (propertyQuota_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPropertyQuota());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, kind_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.RunFunnelReportResponse)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.RunFunnelReportResponse other =
        (com.google.analytics.data.v1alpha.RunFunnelReportResponse) obj;

    if (hasFunnelTable() != other.hasFunnelTable()) return false;
    if (hasFunnelTable()) {
      if (!getFunnelTable().equals(other.getFunnelTable())) return false;
    }
    if (hasFunnelVisualization() != other.hasFunnelVisualization()) return false;
    if (hasFunnelVisualization()) {
      if (!getFunnelVisualization().equals(other.getFunnelVisualization())) return false;
    }
    if (hasPropertyQuota() != other.hasPropertyQuota()) return false;
    if (hasPropertyQuota()) {
      if (!getPropertyQuota().equals(other.getPropertyQuota())) return false;
    }
    if (!getKind().equals(other.getKind())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFunnelTable()) {
      hash = (37 * hash) + FUNNEL_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getFunnelTable().hashCode();
    }
    if (hasFunnelVisualization()) {
      hash = (37 * hash) + FUNNEL_VISUALIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getFunnelVisualization().hashCode();
    }
    if (hasPropertyQuota()) {
      hash = (37 * hash) + PROPERTY_QUOTA_FIELD_NUMBER;
      hash = (53 * hash) + getPropertyQuota().hashCode();
    }
    hash = (37 * hash) + KIND_FIELD_NUMBER;
    hash = (53 * hash) + getKind().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1alpha.RunFunnelReportResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The funnel report response contains two sub reports. The two sub reports are
   * different combinations of dimensions and metrics.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.RunFunnelReportResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.RunFunnelReportResponse)
      com.google.analytics.data.v1alpha.RunFunnelReportResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RunFunnelReportResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RunFunnelReportResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.RunFunnelReportResponse.class,
              com.google.analytics.data.v1alpha.RunFunnelReportResponse.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.RunFunnelReportResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (funnelTableBuilder_ == null) {
        funnelTable_ = null;
      } else {
        funnelTable_ = null;
        funnelTableBuilder_ = null;
      }
      if (funnelVisualizationBuilder_ == null) {
        funnelVisualization_ = null;
      } else {
        funnelVisualization_ = null;
        funnelVisualizationBuilder_ = null;
      }
      if (propertyQuotaBuilder_ == null) {
        propertyQuota_ = null;
      } else {
        propertyQuota_ = null;
        propertyQuotaBuilder_ = null;
      }
      kind_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RunFunnelReportResponse_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportResponse getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.RunFunnelReportResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportResponse build() {
      com.google.analytics.data.v1alpha.RunFunnelReportResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportResponse buildPartial() {
      com.google.analytics.data.v1alpha.RunFunnelReportResponse result =
          new com.google.analytics.data.v1alpha.RunFunnelReportResponse(this);
      if (funnelTableBuilder_ == null) {
        result.funnelTable_ = funnelTable_;
      } else {
        result.funnelTable_ = funnelTableBuilder_.build();
      }
      if (funnelVisualizationBuilder_ == null) {
        result.funnelVisualization_ = funnelVisualization_;
      } else {
        result.funnelVisualization_ = funnelVisualizationBuilder_.build();
      }
      if (propertyQuotaBuilder_ == null) {
        result.propertyQuota_ = propertyQuota_;
      } else {
        result.propertyQuota_ = propertyQuotaBuilder_.build();
      }
      result.kind_ = kind_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.RunFunnelReportResponse) {
        return mergeFrom((com.google.analytics.data.v1alpha.RunFunnelReportResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.RunFunnelReportResponse other) {
      if (other == com.google.analytics.data.v1alpha.RunFunnelReportResponse.getDefaultInstance())
        return this;
      if (other.hasFunnelTable()) {
        mergeFunnelTable(other.getFunnelTable());
      }
      if (other.hasFunnelVisualization()) {
        mergeFunnelVisualization(other.getFunnelVisualization());
      }
      if (other.hasPropertyQuota()) {
        mergePropertyQuota(other.getPropertyQuota());
      }
      if (!other.getKind().isEmpty()) {
        kind_ = other.kind_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.analytics.data.v1alpha.RunFunnelReportResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.analytics.data.v1alpha.RunFunnelReportResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.analytics.data.v1alpha.FunnelSubReport funnelTable_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelSubReport,
            com.google.analytics.data.v1alpha.FunnelSubReport.Builder,
            com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder>
        funnelTableBuilder_;
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     *
     * @return Whether the funnelTable field is set.
     */
    public boolean hasFunnelTable() {
      return funnelTableBuilder_ != null || funnelTable_ != null;
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     *
     * @return The funnelTable.
     */
    public com.google.analytics.data.v1alpha.FunnelSubReport getFunnelTable() {
      if (funnelTableBuilder_ == null) {
        return funnelTable_ == null
            ? com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance()
            : funnelTable_;
      } else {
        return funnelTableBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    public Builder setFunnelTable(com.google.analytics.data.v1alpha.FunnelSubReport value) {
      if (funnelTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        funnelTable_ = value;
        onChanged();
      } else {
        funnelTableBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    public Builder setFunnelTable(
        com.google.analytics.data.v1alpha.FunnelSubReport.Builder builderForValue) {
      if (funnelTableBuilder_ == null) {
        funnelTable_ = builderForValue.build();
        onChanged();
      } else {
        funnelTableBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    public Builder mergeFunnelTable(com.google.analytics.data.v1alpha.FunnelSubReport value) {
      if (funnelTableBuilder_ == null) {
        if (funnelTable_ != null) {
          funnelTable_ =
              com.google.analytics.data.v1alpha.FunnelSubReport.newBuilder(funnelTable_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          funnelTable_ = value;
        }
        onChanged();
      } else {
        funnelTableBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    public Builder clearFunnelTable() {
      if (funnelTableBuilder_ == null) {
        funnelTable_ = null;
        onChanged();
      } else {
        funnelTable_ = null;
        funnelTableBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelSubReport.Builder getFunnelTableBuilder() {

      onChanged();
      return getFunnelTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder getFunnelTableOrBuilder() {
      if (funnelTableBuilder_ != null) {
        return funnelTableBuilder_.getMessageOrBuilder();
      } else {
        return funnelTable_ == null
            ? com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance()
            : funnelTable_;
      }
    }
    /**
     *
     *
     * <pre>
     * The funnel table is a report with the funnel step, segment, breakdown
     * dimension, active users, completion rate, abandonments, and abandonments
     * rate.
     * The segment dimension is only present in this response if a segment was
     * requested. The breakdown dimension is only present in this response if it
     * was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_table = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelSubReport,
            com.google.analytics.data.v1alpha.FunnelSubReport.Builder,
            com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder>
        getFunnelTableFieldBuilder() {
      if (funnelTableBuilder_ == null) {
        funnelTableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FunnelSubReport,
                com.google.analytics.data.v1alpha.FunnelSubReport.Builder,
                com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder>(
                getFunnelTable(), getParentForChildren(), isClean());
        funnelTable_ = null;
      }
      return funnelTableBuilder_;
    }

    private com.google.analytics.data.v1alpha.FunnelSubReport funnelVisualization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelSubReport,
            com.google.analytics.data.v1alpha.FunnelSubReport.Builder,
            com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder>
        funnelVisualizationBuilder_;
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     *
     * @return Whether the funnelVisualization field is set.
     */
    public boolean hasFunnelVisualization() {
      return funnelVisualizationBuilder_ != null || funnelVisualization_ != null;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     *
     * @return The funnelVisualization.
     */
    public com.google.analytics.data.v1alpha.FunnelSubReport getFunnelVisualization() {
      if (funnelVisualizationBuilder_ == null) {
        return funnelVisualization_ == null
            ? com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance()
            : funnelVisualization_;
      } else {
        return funnelVisualizationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    public Builder setFunnelVisualization(com.google.analytics.data.v1alpha.FunnelSubReport value) {
      if (funnelVisualizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        funnelVisualization_ = value;
        onChanged();
      } else {
        funnelVisualizationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    public Builder setFunnelVisualization(
        com.google.analytics.data.v1alpha.FunnelSubReport.Builder builderForValue) {
      if (funnelVisualizationBuilder_ == null) {
        funnelVisualization_ = builderForValue.build();
        onChanged();
      } else {
        funnelVisualizationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    public Builder mergeFunnelVisualization(
        com.google.analytics.data.v1alpha.FunnelSubReport value) {
      if (funnelVisualizationBuilder_ == null) {
        if (funnelVisualization_ != null) {
          funnelVisualization_ =
              com.google.analytics.data.v1alpha.FunnelSubReport.newBuilder(funnelVisualization_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          funnelVisualization_ = value;
        }
        onChanged();
      } else {
        funnelVisualizationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    public Builder clearFunnelVisualization() {
      if (funnelVisualizationBuilder_ == null) {
        funnelVisualization_ = null;
        onChanged();
      } else {
        funnelVisualization_ = null;
        funnelVisualizationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelSubReport.Builder
        getFunnelVisualizationBuilder() {

      onChanged();
      return getFunnelVisualizationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder
        getFunnelVisualizationOrBuilder() {
      if (funnelVisualizationBuilder_ != null) {
        return funnelVisualizationBuilder_.getMessageOrBuilder();
      } else {
        return funnelVisualization_ == null
            ? com.google.analytics.data.v1alpha.FunnelSubReport.getDefaultInstance()
            : funnelVisualization_;
      }
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization is a report with the funnel step, segment, date,
     * next action dimension, and active users.
     * The segment dimension is only present in this response if a segment was
     * requested. The date dimension is only present in this response if it was
     * requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
     * is only present in the response if it was requested.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelSubReport funnel_visualization = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelSubReport,
            com.google.analytics.data.v1alpha.FunnelSubReport.Builder,
            com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder>
        getFunnelVisualizationFieldBuilder() {
      if (funnelVisualizationBuilder_ == null) {
        funnelVisualizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FunnelSubReport,
                com.google.analytics.data.v1alpha.FunnelSubReport.Builder,
                com.google.analytics.data.v1alpha.FunnelSubReportOrBuilder>(
                getFunnelVisualization(), getParentForChildren(), isClean());
        funnelVisualization_ = null;
      }
      return funnelVisualizationBuilder_;
    }

    private com.google.analytics.data.v1alpha.PropertyQuota propertyQuota_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.PropertyQuota,
            com.google.analytics.data.v1alpha.PropertyQuota.Builder,
            com.google.analytics.data.v1alpha.PropertyQuotaOrBuilder>
        propertyQuotaBuilder_;
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     *
     * @return Whether the propertyQuota field is set.
     */
    public boolean hasPropertyQuota() {
      return propertyQuotaBuilder_ != null || propertyQuota_ != null;
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     *
     * @return The propertyQuota.
     */
    public com.google.analytics.data.v1alpha.PropertyQuota getPropertyQuota() {
      if (propertyQuotaBuilder_ == null) {
        return propertyQuota_ == null
            ? com.google.analytics.data.v1alpha.PropertyQuota.getDefaultInstance()
            : propertyQuota_;
      } else {
        return propertyQuotaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    public Builder setPropertyQuota(com.google.analytics.data.v1alpha.PropertyQuota value) {
      if (propertyQuotaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        propertyQuota_ = value;
        onChanged();
      } else {
        propertyQuotaBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    public Builder setPropertyQuota(
        com.google.analytics.data.v1alpha.PropertyQuota.Builder builderForValue) {
      if (propertyQuotaBuilder_ == null) {
        propertyQuota_ = builderForValue.build();
        onChanged();
      } else {
        propertyQuotaBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    public Builder mergePropertyQuota(com.google.analytics.data.v1alpha.PropertyQuota value) {
      if (propertyQuotaBuilder_ == null) {
        if (propertyQuota_ != null) {
          propertyQuota_ =
              com.google.analytics.data.v1alpha.PropertyQuota.newBuilder(propertyQuota_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          propertyQuota_ = value;
        }
        onChanged();
      } else {
        propertyQuotaBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    public Builder clearPropertyQuota() {
      if (propertyQuotaBuilder_ == null) {
        propertyQuota_ = null;
        onChanged();
      } else {
        propertyQuota_ = null;
        propertyQuotaBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    public com.google.analytics.data.v1alpha.PropertyQuota.Builder getPropertyQuotaBuilder() {

      onChanged();
      return getPropertyQuotaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    public com.google.analytics.data.v1alpha.PropertyQuotaOrBuilder getPropertyQuotaOrBuilder() {
      if (propertyQuotaBuilder_ != null) {
        return propertyQuotaBuilder_.getMessageOrBuilder();
      } else {
        return propertyQuota_ == null
            ? com.google.analytics.data.v1alpha.PropertyQuota.getDefaultInstance()
            : propertyQuota_;
      }
    }
    /**
     *
     *
     * <pre>
     * This Analytics Property's quota state including this request.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.PropertyQuota property_quota = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.PropertyQuota,
            com.google.analytics.data.v1alpha.PropertyQuota.Builder,
            com.google.analytics.data.v1alpha.PropertyQuotaOrBuilder>
        getPropertyQuotaFieldBuilder() {
      if (propertyQuotaBuilder_ == null) {
        propertyQuotaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.PropertyQuota,
                com.google.analytics.data.v1alpha.PropertyQuota.Builder,
                com.google.analytics.data.v1alpha.PropertyQuotaOrBuilder>(
                getPropertyQuota(), getParentForChildren(), isClean());
        propertyQuota_ = null;
      }
      return propertyQuotaBuilder_;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * Identifies what kind of resource this message is. This `kind` is always the
     * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
     * response types in JSON.
     * </pre>
     *
     * <code>string kind = 4;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies what kind of resource this message is. This `kind` is always the
     * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
     * response types in JSON.
     * </pre>
     *
     * <code>string kind = 4;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies what kind of resource this message is. This `kind` is always the
     * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
     * response types in JSON.
     * </pre>
     *
     * <code>string kind = 4;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies what kind of resource this message is. This `kind` is always the
     * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
     * response types in JSON.
     * </pre>
     *
     * <code>string kind = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {

      kind_ = getDefaultInstance().getKind();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies what kind of resource this message is. This `kind` is always the
     * fixed string "analyticsData#runFunnelReport". Useful to distinguish between
     * response types in JSON.
     * </pre>
     *
     * <code>string kind = 4;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      kind_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.RunFunnelReportResponse)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.RunFunnelReportResponse)
  private static final com.google.analytics.data.v1alpha.RunFunnelReportResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.RunFunnelReportResponse();
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunFunnelReportResponse> PARSER =
      new com.google.protobuf.AbstractParser<RunFunnelReportResponse>() {
        @java.lang.Override
        public RunFunnelReportResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RunFunnelReportResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RunFunnelReportResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunFunnelReportResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.RunFunnelReportResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
