/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyEventName
implements ResourceName {
    private static final PathTemplate PROPERTY_KEY_EVENT = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/keyEvents/{key_event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String keyEvent;

    @Deprecated
    protected KeyEventName() {
        this.property = null;
        this.keyEvent = null;
    }

    private KeyEventName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.keyEvent = (String)Preconditions.checkNotNull((Object)builder.getKeyEvent());
    }

    public String getProperty() {
        return this.property;
    }

    public String getKeyEvent() {
        return this.keyEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeyEventName of(String property, String keyEvent) {
        return KeyEventName.newBuilder().setProperty(property).setKeyEvent(keyEvent).build();
    }

    public static String format(String property, String keyEvent) {
        return KeyEventName.newBuilder().setProperty(property).setKeyEvent(keyEvent).build().toString();
    }

    public static KeyEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_KEY_EVENT.validatedMatch(formattedString, "KeyEventName.parse: formattedString not in valid format");
        return KeyEventName.of((String)matchMap.get("property"), (String)matchMap.get("key_event"));
    }

    public static List<KeyEventName> parseList(List<String> formattedStrings) {
        ArrayList<KeyEventName> list = new ArrayList<KeyEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeyEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeyEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeyEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_KEY_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeyEventName keyEventName = this;
            synchronized (keyEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.keyEvent != null) {
                        fieldMapBuilder.put((Object)"key_event", (Object)this.keyEvent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_KEY_EVENT.instantiate(new String[]{"property", this.property, "key_event", this.keyEvent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeyEventName that = (KeyEventName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.keyEvent, that.keyEvent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keyEvent);
    }

    public static class Builder {
        private String property;
        private String keyEvent;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getKeyEvent() {
            return this.keyEvent;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setKeyEvent(String keyEvent) {
            this.keyEvent = keyEvent;
            return this;
        }

        private Builder(KeyEventName keyEventName) {
            this.property = keyEventName.property;
            this.keyEvent = keyEventName.keyEvent;
        }

        public KeyEventName build() {
            return new KeyEventName(this);
        }
    }
}

