/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomMetricName
implements ResourceName {
    private static final PathTemplate PROPERTY = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/customMetrics");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;

    @Deprecated
    protected CustomMetricName() {
        this.property = null;
    }

    private CustomMetricName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
    }

    public String getProperty() {
        return this.property;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomMetricName of(String property) {
        return CustomMetricName.newBuilder().setProperty(property).build();
    }

    public static String format(String property) {
        return CustomMetricName.newBuilder().setProperty(property).build().toString();
    }

    public static CustomMetricName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY.validatedMatch(formattedString, "CustomMetricName.parse: formattedString not in valid format");
        return CustomMetricName.of((String)matchMap.get("property"));
    }

    public static List<CustomMetricName> parseList(List<String> formattedStrings) {
        ArrayList<CustomMetricName> list = new ArrayList<CustomMetricName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomMetricName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomMetricName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomMetricName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomMetricName customMetricName = this;
            synchronized (customMetricName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY.instantiate(new String[]{"property", this.property});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomMetricName that = (CustomMetricName)o;
            return Objects.equals(this.property, that.property);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.property);
    }

    public static class Builder {
        private String property;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        private Builder(CustomMetricName customMetricName) {
            this.property = customMetricName.property;
        }

        public CustomMetricName build() {
            return new CustomMetricName(this);
        }
    }
}

