/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportingDataAnnotationName
implements ResourceName {
    private static final PathTemplate PROPERTY_REPORTING_DATA_ANNOTATION = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/reportingDataAnnotations/{reporting_data_annotation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String reportingDataAnnotation;

    @Deprecated
    protected ReportingDataAnnotationName() {
        this.property = null;
        this.reportingDataAnnotation = null;
    }

    private ReportingDataAnnotationName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.reportingDataAnnotation = (String)Preconditions.checkNotNull((Object)builder.getReportingDataAnnotation());
    }

    public String getProperty() {
        return this.property;
    }

    public String getReportingDataAnnotation() {
        return this.reportingDataAnnotation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportingDataAnnotationName of(String property, String reportingDataAnnotation) {
        return ReportingDataAnnotationName.newBuilder().setProperty(property).setReportingDataAnnotation(reportingDataAnnotation).build();
    }

    public static String format(String property, String reportingDataAnnotation) {
        return ReportingDataAnnotationName.newBuilder().setProperty(property).setReportingDataAnnotation(reportingDataAnnotation).build().toString();
    }

    public static ReportingDataAnnotationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_REPORTING_DATA_ANNOTATION.validatedMatch(formattedString, "ReportingDataAnnotationName.parse: formattedString not in valid format");
        return ReportingDataAnnotationName.of((String)matchMap.get("property"), (String)matchMap.get("reporting_data_annotation"));
    }

    public static List<ReportingDataAnnotationName> parseList(List<String> formattedStrings) {
        ArrayList<ReportingDataAnnotationName> list = new ArrayList<ReportingDataAnnotationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportingDataAnnotationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportingDataAnnotationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportingDataAnnotationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_REPORTING_DATA_ANNOTATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportingDataAnnotationName reportingDataAnnotationName = this;
            synchronized (reportingDataAnnotationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.reportingDataAnnotation != null) {
                        fieldMapBuilder.put((Object)"reporting_data_annotation", (Object)this.reportingDataAnnotation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_REPORTING_DATA_ANNOTATION.instantiate(new String[]{"property", this.property, "reporting_data_annotation", this.reportingDataAnnotation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReportingDataAnnotationName that = (ReportingDataAnnotationName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.reportingDataAnnotation, that.reportingDataAnnotation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reportingDataAnnotation);
    }

    public static class Builder {
        private String property;
        private String reportingDataAnnotation;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getReportingDataAnnotation() {
            return this.reportingDataAnnotation;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setReportingDataAnnotation(String reportingDataAnnotation) {
            this.reportingDataAnnotation = reportingDataAnnotation;
            return this;
        }

        private Builder(ReportingDataAnnotationName reportingDataAnnotationName) {
            this.property = reportingDataAnnotationName.property;
            this.reportingDataAnnotation = reportingDataAnnotationName.reportingDataAnnotation;
        }

        public ReportingDataAnnotationName build() {
            return new ReportingDataAnnotationName(this);
        }
    }
}

