/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnhancedMeasurementSettingsName
implements ResourceName {
    private static final PathTemplate PROPERTY_WEB_DATA_STREAM = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/webDataStreams/{web_data_stream}/enhancedMeasurementSettings");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String webDataStream;

    @Deprecated
    protected EnhancedMeasurementSettingsName() {
        this.property = null;
        this.webDataStream = null;
    }

    private EnhancedMeasurementSettingsName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.webDataStream = (String)Preconditions.checkNotNull((Object)builder.getWebDataStream());
    }

    public String getProperty() {
        return this.property;
    }

    public String getWebDataStream() {
        return this.webDataStream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EnhancedMeasurementSettingsName of(String property, String webDataStream) {
        return EnhancedMeasurementSettingsName.newBuilder().setProperty(property).setWebDataStream(webDataStream).build();
    }

    public static String format(String property, String webDataStream) {
        return EnhancedMeasurementSettingsName.newBuilder().setProperty(property).setWebDataStream(webDataStream).build().toString();
    }

    public static EnhancedMeasurementSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_WEB_DATA_STREAM.validatedMatch(formattedString, "EnhancedMeasurementSettingsName.parse: formattedString not in valid format");
        return EnhancedMeasurementSettingsName.of((String)matchMap.get("property"), (String)matchMap.get("web_data_stream"));
    }

    public static List<EnhancedMeasurementSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<EnhancedMeasurementSettingsName> list = new ArrayList<EnhancedMeasurementSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnhancedMeasurementSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnhancedMeasurementSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnhancedMeasurementSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_WEB_DATA_STREAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnhancedMeasurementSettingsName enhancedMeasurementSettingsName = this;
            synchronized (enhancedMeasurementSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.webDataStream != null) {
                        fieldMapBuilder.put((Object)"web_data_stream", (Object)this.webDataStream);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_WEB_DATA_STREAM.instantiate(new String[]{"property", this.property, "web_data_stream", this.webDataStream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EnhancedMeasurementSettingsName that = (EnhancedMeasurementSettingsName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.webDataStream, that.webDataStream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.webDataStream);
    }

    public static class Builder {
        private String property;
        private String webDataStream;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getWebDataStream() {
            return this.webDataStream;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setWebDataStream(String webDataStream) {
            this.webDataStream = webDataStream;
            return this;
        }

        private Builder(EnhancedMeasurementSettingsName enhancedMeasurementSettingsName) {
            this.property = enhancedMeasurementSettingsName.property;
            this.webDataStream = enhancedMeasurementSettingsName.webDataStream;
        }

        public EnhancedMeasurementSettingsName build() {
            return new EnhancedMeasurementSettingsName(this);
        }
    }
}

