/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpandedDataSetName
implements ResourceName {
    private static final PathTemplate PROPERTY_EXPANDED_DATA_SET = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/expandedDataSets/{expanded_data_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String expandedDataSet;

    @Deprecated
    protected ExpandedDataSetName() {
        this.property = null;
        this.expandedDataSet = null;
    }

    private ExpandedDataSetName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.expandedDataSet = (String)Preconditions.checkNotNull((Object)builder.getExpandedDataSet());
    }

    public String getProperty() {
        return this.property;
    }

    public String getExpandedDataSet() {
        return this.expandedDataSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExpandedDataSetName of(String property, String expandedDataSet) {
        return ExpandedDataSetName.newBuilder().setProperty(property).setExpandedDataSet(expandedDataSet).build();
    }

    public static String format(String property, String expandedDataSet) {
        return ExpandedDataSetName.newBuilder().setProperty(property).setExpandedDataSet(expandedDataSet).build().toString();
    }

    public static ExpandedDataSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_EXPANDED_DATA_SET.validatedMatch(formattedString, "ExpandedDataSetName.parse: formattedString not in valid format");
        return ExpandedDataSetName.of((String)matchMap.get("property"), (String)matchMap.get("expanded_data_set"));
    }

    public static List<ExpandedDataSetName> parseList(List<String> formattedStrings) {
        ArrayList<ExpandedDataSetName> list = new ArrayList<ExpandedDataSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExpandedDataSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExpandedDataSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExpandedDataSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_EXPANDED_DATA_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExpandedDataSetName expandedDataSetName = this;
            synchronized (expandedDataSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.expandedDataSet != null) {
                        fieldMapBuilder.put((Object)"expanded_data_set", (Object)this.expandedDataSet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_EXPANDED_DATA_SET.instantiate(new String[]{"property", this.property, "expanded_data_set", this.expandedDataSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExpandedDataSetName that = (ExpandedDataSetName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.expandedDataSet, that.expandedDataSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.expandedDataSet);
    }

    public static class Builder {
        private String property;
        private String expandedDataSet;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getExpandedDataSet() {
            return this.expandedDataSet;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setExpandedDataSet(String expandedDataSet) {
            this.expandedDataSet = expandedDataSet;
            return this;
        }

        private Builder(ExpandedDataSetName expandedDataSetName) {
            this.property = expandedDataSetName.property;
            this.expandedDataSet = expandedDataSetName.expandedDataSet;
        }

        public ExpandedDataSetName build() {
            return new ExpandedDataSetName(this);
        }
    }
}

