/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudienceName
implements ResourceName {
    private static final PathTemplate PROPERTY_AUDIENCE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/audiences/{audience}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String audience;

    @Deprecated
    protected AudienceName() {
        this.property = null;
        this.audience = null;
    }

    private AudienceName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.audience = (String)Preconditions.checkNotNull((Object)builder.getAudience());
    }

    public String getProperty() {
        return this.property;
    }

    public String getAudience() {
        return this.audience;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AudienceName of(String property, String audience) {
        return AudienceName.newBuilder().setProperty(property).setAudience(audience).build();
    }

    public static String format(String property, String audience) {
        return AudienceName.newBuilder().setProperty(property).setAudience(audience).build().toString();
    }

    public static AudienceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_AUDIENCE.validatedMatch(formattedString, "AudienceName.parse: formattedString not in valid format");
        return AudienceName.of((String)matchMap.get("property"), (String)matchMap.get("audience"));
    }

    public static List<AudienceName> parseList(List<String> formattedStrings) {
        ArrayList<AudienceName> list = new ArrayList<AudienceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AudienceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AudienceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AudienceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_AUDIENCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AudienceName audienceName = this;
            synchronized (audienceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.audience != null) {
                        fieldMapBuilder.put((Object)"audience", (Object)this.audience);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_AUDIENCE.instantiate(new String[]{"property", this.property, "audience", this.audience});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AudienceName that = (AudienceName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.audience, that.audience);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.audience);
    }

    public static class Builder {
        private String property;
        private String audience;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getAudience() {
            return this.audience;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        private Builder(AudienceName audienceName) {
            this.property = audienceName.property;
            this.audience = audienceName.audience;
        }

        public AudienceName build() {
            return new AudienceName(this);
        }
    }
}

