/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WebDataStreamName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/webDataStreams/{web_data_stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String webDataStream;

    public String getProperty() {
        return this.property;
    }

    public String getWebDataStream() {
        return this.webDataStream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private WebDataStreamName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.webDataStream = (String)Preconditions.checkNotNull((Object)builder.getWebDataStream());
    }

    public static WebDataStreamName of(String property, String webDataStream) {
        return WebDataStreamName.newBuilder().setProperty(property).setWebDataStream(webDataStream).build();
    }

    public static String format(String property, String webDataStream) {
        return WebDataStreamName.newBuilder().setProperty(property).setWebDataStream(webDataStream).build().toString();
    }

    public static WebDataStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "WebDataStreamName.parse: formattedString not in valid format");
        return WebDataStreamName.of((String)matchMap.get("property"), (String)matchMap.get("web_data_stream"));
    }

    public static List<WebDataStreamName> parseList(List<String> formattedStrings) {
        ArrayList<WebDataStreamName> list = new ArrayList<WebDataStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WebDataStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WebDataStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WebDataStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WebDataStreamName webDataStreamName = this;
            synchronized (webDataStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"property", (Object)this.property);
                    fieldMapBuilder.put((Object)"webDataStream", (Object)this.webDataStream);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"property", this.property, "web_data_stream", this.webDataStream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WebDataStreamName) {
            WebDataStreamName that = (WebDataStreamName)o;
            return this.property.equals(that.property) && this.webDataStream.equals(that.webDataStream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.property.hashCode();
        h *= 1000003;
        return h ^= this.webDataStream.hashCode();
    }

    public static class Builder {
        private String property;
        private String webDataStream;

        public String getProperty() {
            return this.property;
        }

        public String getWebDataStream() {
            return this.webDataStream;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setWebDataStream(String webDataStream) {
            this.webDataStream = webDataStream;
            return this;
        }

        private Builder() {
        }

        private Builder(WebDataStreamName webDataStreamName) {
            this.property = webDataStreamName.property;
            this.webDataStream = webDataStreamName.webDataStream;
        }

        public WebDataStreamName build() {
            return new WebDataStreamName(this);
        }
    }
}

