/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageSettings;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.StorageStub;
import com.google.storage.v2.stub.StorageStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class StorageClient
implements BackgroundResource {
    private final StorageSettings settings;
    private final StorageStub stub;

    public static final StorageClient create() throws IOException {
        return StorageClient.create(StorageSettings.newBuilder().build());
    }

    public static final StorageClient create(StorageSettings settings) throws IOException {
        return new StorageClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final StorageClient create(StorageStub stub) {
        return new StorageClient(stub);
    }

    protected StorageClient(StorageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected StorageClient(StorageStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StorageSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public StorageStub getStub() {
        return this.stub;
    }

    public final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable() {
        return this.stub.readObjectCallable();
    }

    public final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable() {
        return this.stub.writeObjectCallable();
    }

    public final StartResumableWriteResponse startResumableWrite(StartResumableWriteRequest request) {
        return (StartResumableWriteResponse)this.startResumableWriteCallable().call((Object)request);
    }

    public final UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable() {
        return this.stub.startResumableWriteCallable();
    }

    public final QueryWriteStatusResponse queryWriteStatus(String uploadId) {
        QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
        return this.queryWriteStatus(request);
    }

    public final QueryWriteStatusResponse queryWriteStatus(QueryWriteStatusRequest request) {
        return (QueryWriteStatusResponse)this.queryWriteStatusCallable().call((Object)request);
    }

    public final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable() {
        return this.stub.queryWriteStatusCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

