/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BidiStream;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ClientStreamReadyObserver;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.NoopApiTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedBidiCallable;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TracedBidiCallableTest {
    private static final SpanName SPAN_NAME = SpanName.of((String)"fake-client", (String)"fake-method");
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    private FakeBidiObserver outerObserver;
    private FakeCallContext outerCallContext;
    @Mock
    private ApiTracerFactory tracerFactory;
    private ApiTracer parentTracer = NoopApiTracer.getInstance();
    @Mock
    private ApiTracer tracer;
    private TracedBidiCallable<String, String> tracedCallable;
    private FakeBidiCallable innerCallable;
    private FakeStreamController innerController;

    @Before
    public void setUp() {
        this.outerObserver = new FakeBidiObserver();
        this.outerCallContext = FakeCallContext.createDefault();
        Mockito.when((Object)this.tracerFactory.newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.BidiStreaming)).thenReturn((Object)this.tracer);
        this.innerCallable = new FakeBidiCallable();
        this.innerController = new FakeStreamController();
        this.tracedCallable = new TracedBidiCallable((BidiStreamingCallable)this.innerCallable, this.tracerFactory, SPAN_NAME);
    }

    @Test
    public void testTracerCreated() {
        this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.BidiStreaming);
    }

    @Test
    public void testOperationCancelled() {
        this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        this.outerObserver.clientStream.closeSendWithError((Throwable)new CancellationException());
        this.innerCallable.responseObserver.onError((Throwable)new RuntimeException("server generated result from cancelling"));
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        Truth.assertThat((Boolean)this.outerObserver.complete).isTrue();
    }

    @Test
    public void testOperationCancelled2() {
        BidiStream stream = this.tracedCallable.call((ApiCallContext)this.outerCallContext);
        stream.cancel();
        this.innerCallable.responseObserver.onError((Throwable)new RuntimeException("server generated result from cancelling"));
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testOperationFinished() {
        this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        this.innerCallable.responseObserver.onComplete();
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        Truth.assertThat((Boolean)this.outerObserver.complete).isTrue();
    }

    @Test
    public void testOperationFailed() {
        RuntimeException expectedException = new RuntimeException("fake");
        this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        this.innerCallable.responseObserver.onError((Throwable)expectedException);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedException);
        Truth.assertThat((Boolean)this.outerObserver.complete).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.error).isEqualTo((Object)expectedException);
    }

    @Test
    public void testSyncError() {
        RuntimeException expectedException;
        this.innerCallable.syncError = expectedException = new RuntimeException("fake");
        try {
            this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedException);
    }

    @Test
    public void testRequestNotify() {
        this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        this.outerObserver.clientStream.send((Object)"request1");
        this.outerObserver.clientStream.send((Object)"request2");
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)2))).requestSent();
        Truth.assertThat((Iterable)this.innerCallable.clientStream.sent).containsExactly(new Object[]{"request1", "request2"});
    }

    @Test
    public void testRequestNotify2() {
        BidiStream stream = this.tracedCallable.call((ApiCallContext)this.outerCallContext);
        stream.send((Object)"request1");
        stream.send((Object)"request2");
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)2))).requestSent();
        Truth.assertThat((Iterable)this.innerCallable.clientStream.sent).containsExactly(new Object[]{"request1", "request2"});
    }

    @Test
    public void testResponseNotify() {
        this.tracedCallable.call((BidiStreamObserver)this.outerObserver, (ApiCallContext)this.outerCallContext);
        this.innerCallable.responseObserver.onResponse((Object)"response1");
        this.innerCallable.responseObserver.onResponse((Object)"response2");
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)2))).responseReceived();
        Truth.assertThat((Iterable)this.outerObserver.responses).containsExactly(new Object[]{"response1", "response2"});
    }

    private static class FakeStreamController
    implements StreamController {
        private boolean wasCancelled;

        private FakeStreamController() {
        }

        public void cancel() {
            this.wasCancelled = true;
        }

        public void disableAutoInboundFlowControl() {
        }

        public void request(int count) {
        }
    }

    private static class FakeBidiObserver
    implements BidiStreamObserver<String, String> {
        private ClientStream<String> clientStream;
        private StreamController streamController;
        private List<String> responses = new ArrayList<String>();
        private Throwable error;
        private boolean complete;

        private FakeBidiObserver() {
        }

        public void onReady(ClientStream<String> stream) {
            this.clientStream = stream;
        }

        public void onStart(StreamController controller) {
            this.streamController = controller;
        }

        public void onResponse(String response) {
            this.responses.add(response);
        }

        public void onError(Throwable t) {
            this.error = t;
            this.complete = true;
        }

        public void onComplete() {
            this.complete = true;
        }
    }

    private static class FakeClientStream
    implements ClientStream<String> {
        private List<String> sent = new ArrayList<String>();
        private Throwable closeError;
        private boolean closed;

        private FakeClientStream() {
        }

        public void send(String request) {
            this.sent.add(request);
        }

        public void closeSendWithError(Throwable t) {
            this.closed = true;
            this.closeError = t;
        }

        public void closeSend() {
            this.closed = true;
        }

        public boolean isSendReady() {
            return true;
        }
    }

    private static class FakeBidiCallable
    extends BidiStreamingCallable<String, String> {
        RuntimeException syncError;
        FakeStreamController responseController;
        ResponseObserver<String> responseObserver;
        ClientStreamReadyObserver<String> onReady;
        ApiCallContext callContext;
        FakeClientStream clientStream;

        private FakeBidiCallable() {
        }

        public ClientStream<String> internalCall(ResponseObserver<String> responseObserver, ClientStreamReadyObserver<String> onReady, ApiCallContext context) {
            if (this.syncError != null) {
                throw this.syncError;
            }
            this.responseController = new FakeStreamController();
            this.responseObserver = responseObserver;
            this.onReady = onReady;
            this.callContext = context;
            this.clientStream = new FakeClientStream();
            onReady.onReady((ClientStream)this.clientStream);
            responseObserver.onStart((StreamController)this.responseController);
            return this.clientStream;
        }
    }
}

