/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.FakeStatusException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

class FakeExceptionCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    FakeExceptionCallable(UnaryCallable<RequestT, ResponseT> callable, Set<StatusCode.Code> retryableCodes) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        FakeCallContext context = FakeCallContext.createDefault().nullToSelf(inputContext);
        ApiFuture innerCallFuture = this.callable.futureCall(request, (ApiCallContext)context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback((ApiFuture)innerCallFuture, (ApiFutureCallback)transformingFuture, (Executor)MoreExecutors.directExecutor());
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        public void onFailure(Throwable throwable) {
            StatusCode.Code statusCode = StatusCode.Code.UNKNOWN;
            boolean canRetry = false;
            boolean rethrow = false;
            if (throwable instanceof FakeStatusException) {
                FakeStatusException e = (FakeStatusException)throwable;
                statusCode = e.getStatusCode().getCode();
                canRetry = FakeExceptionCallable.this.retryableCodes.contains((Object)e.getStatusCode().getCode());
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                if (throwable instanceof ApiException) {
                    rethrow = true;
                } else {
                    statusCode = StatusCode.Code.UNKNOWN;
                    canRetry = false;
                }
            }
            if (rethrow) {
                super.setException(throwable);
            } else {
                super.setException((Throwable)ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)FakeStatusCode.of(statusCode), (boolean)canRetry));
            }
        }
    }
}

