/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeSimpleApi;
import com.google.auth.Credentials;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class UnaryCallableTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void simpleCall() throws Exception {
        FakeSimpleApi.StashCallable stashCallable = new FakeSimpleApi.StashCallable(1);
        Integer response = (Integer)stashCallable.call(2, FakeCallContext.createDefault());
        Truth.assertThat((Integer)response).isEqualTo((Object)1);
        FakeCallContext callContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)callContext.getChannel()).isNull();
        Truth.assertThat((Object)callContext.getCredentials()).isNull();
    }

    @Test
    public void call() throws Exception {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeSimpleApi.StashCallable stashCallable = new FakeSimpleApi.StashCallable(1);
        UnaryCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        Integer response = (Integer)callable.call((Object)2);
        Truth.assertThat((Integer)response).isEqualTo((Object)1);
        Truth.assertThat((Object)stashCallable.getContext()).isNotNull();
        Truth.assertThat((Object)stashCallable.getContext()).isSameAs((Object)defaultCallContext);
    }

    @Test
    public void callWithContext() throws Exception {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeSimpleApi.StashCallable stashCallable = new FakeSimpleApi.StashCallable(1);
        UnaryCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        Integer response = (Integer)callable.call((Object)2, (ApiCallContext)context);
        Truth.assertThat((Integer)response).isEqualTo((Object)1);
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameAs((Object)credentials);
    }
}

