/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.FakeStreamingApi;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class StreamingCallableTest {
    private ClientContext clientContext;

    @Before
    public void setUp() {
        this.clientContext = ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @Test
    public void clientStreaming() {
        FakeStreamingApi.ClientStreamingStashCallable callIntList = new FakeStreamingApi.ClientStreamingStashCallable(100);
        ClientStreamingCallable callable = FakeCallableFactory.createClientStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        AccumulatingStreamObserver responseObserver = new AccumulatingStreamObserver();
        ApiStreamObserver requestObserver = callable.clientStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)0);
        requestObserver.onNext((Object)2);
        requestObserver.onNext((Object)4);
        requestObserver.onCompleted();
        Truth.assertThat((Iterable)ImmutableList.copyOf(responseObserver.getValues())).containsExactly(new Object[]{100}).inOrder();
        Truth.assertThat(callIntList.getActualRequests()).containsExactly(new Object[]{0, 2, 4}).inOrder();
    }

    @Test
    public void testClientStreamingCall() {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeStreamingApi.ClientStreamingStashCallable stashCallable = new FakeStreamingApi.ClientStreamingStashCallable();
        ApiStreamObserver observer = (ApiStreamObserver)Mockito.mock(ApiStreamObserver.class);
        ClientStreamingCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        callable.clientStreamingCall(observer);
        Truth.assertThat(stashCallable.getActualObserver()).isSameAs((Object)observer);
        Truth.assertThat((Object)stashCallable.getContext()).isSameAs((Object)defaultCallContext);
    }

    @Test
    public void testClientStreamingCallWithContext() {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeStreamingApi.ClientStreamingStashCallable stashCallable = new FakeStreamingApi.ClientStreamingStashCallable();
        ApiStreamObserver observer = (ApiStreamObserver)Mockito.mock(ApiStreamObserver.class);
        ClientStreamingCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        callable.clientStreamingCall(observer, (ApiCallContext)context);
        Truth.assertThat(stashCallable.getActualObserver()).isSameAs((Object)observer);
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameAs((Object)credentials);
    }

    private static class AccumulatingStreamObserver
    implements ApiStreamObserver<Integer> {
        private List<Integer> values = new ArrayList<Integer>();
        private Throwable error;
        private boolean completed = false;

        private AccumulatingStreamObserver() {
        }

        public void onNext(Integer value) {
            this.values.add(value);
        }

        public void onError(Throwable t) {
            this.error = t;
        }

        public void onCompleted() {
            this.completed = true;
        }

        public List<Integer> getValues() {
            if (!this.completed) {
                throw new IllegalStateException("Stream not completed.");
            }
            if (this.error != null) {
                throw ApiExceptionFactory.createException((Throwable)this.error, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNKNOWN), (boolean)false);
            }
            return this.values;
        }
    }
}

