/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.PagedCallable;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakePagedApi;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PagedCallableTest {
    @Test
    public void futureCall() {
        List<List<Integer>> results = Arrays.asList(Arrays.asList(0, 1, 2), Arrays.asList(3, 4), Collections.emptyList());
        FakePagedApi.PagedStashCallable callable = new FakePagedApi.PagedStashCallable(results);
        PagedCallable pagedCallable = new PagedCallable((UnaryCallable)callable, (PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory());
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)((FakePagedApi.ListIntegersPagedResponse)((Object)pagedCallable.call((Object)0, (ApiCallContext)FakeCallContext.createDefault()))).iterateAll())).containsExactly(new Object[]{0, 1, 2, 3, 4}).inOrder();
    }

    @Test
    public void testToString() {
        FakePagedApi.PagedStashCallable stash = new FakePagedApi.PagedStashCallable(null);
        PagedCallable pagedCallable = new PagedCallable((UnaryCallable)stash, (PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory());
        Truth.assertThat((String)pagedCallable.toString()).contains((CharSequence)"paged");
    }
}

