/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.Watchdog;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.common.truth.Truth;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.threeten.bp.Duration;

@RunWith(value=MockitoJUnitRunner.class)
public class InstantiatingWatchdogProviderTest {
    @Mock
    private ScheduledExecutorService executor;
    @Mock
    private ApiClock clock;
    private Duration checkInterval = Duration.ofSeconds((long)11L);

    @Test
    public void happyPath() {
        WatchdogProvider provider = InstantiatingWatchdogProvider.create();
        Truth.assertThat((Boolean)provider.needsExecutor()).isTrue();
        provider = provider.withExecutor(this.executor);
        Truth.assertThat((Boolean)provider.needsClock()).isTrue();
        provider = provider.withClock(this.clock);
        Truth.assertThat((Boolean)provider.needsCheckInterval()).isTrue();
        provider = provider.withCheckInterval(this.checkInterval);
        Watchdog watchdog = provider.getWatchdog();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executor)).scheduleAtFixedRate((Runnable)watchdog, this.checkInterval.toMillis(), this.checkInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void requiresExecutor() {
        WatchdogProvider provider = InstantiatingWatchdogProvider.create().withCheckInterval(this.checkInterval).withClock(this.clock);
        Throwable actualError = null;
        try {
            provider.getWatchdog();
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void requiresCheckInterval() {
        WatchdogProvider provider = InstantiatingWatchdogProvider.create().withExecutor(this.executor).withClock(this.clock);
        Throwable actualError = null;
        try {
            provider.getWatchdog();
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void requiresClock() {
        WatchdogProvider provider = InstantiatingWatchdogProvider.create().withExecutor(this.executor).withCheckInterval(this.checkInterval);
        Throwable actualError = null;
        try {
            provider.getWatchdog();
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }
}

