/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.common.truth.Truth;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FixedTransportChannelProviderTest {
    @Test
    public void testBasic() throws Exception {
        FakeTransportChannel transportChannel = FakeTransportChannel.create(new FakeChannel());
        FixedTransportChannelProvider provider = FixedTransportChannelProvider.create((TransportChannel)transportChannel);
        Truth.assertThat((Boolean)provider.shouldAutoClose()).isFalse();
        Truth.assertThat((Boolean)provider.needsExecutor()).isFalse();
        Exception thrownException = null;
        try {
            provider.withExecutor((ScheduledExecutorService)new ScheduledThreadPoolExecutor(0));
        }
        catch (Exception e) {
            thrownException = e;
        }
        Truth.assertThat((Throwable)thrownException).isInstanceOf(UnsupportedOperationException.class);
        Truth.assertThat((Boolean)provider.needsHeaders()).isFalse();
        thrownException = null;
        try {
            provider.withHeaders(Collections.emptyMap());
        }
        catch (Exception e) {
            thrownException = e;
        }
        Truth.assertThat((Throwable)thrownException).isInstanceOf(UnsupportedOperationException.class);
        Truth.assertThat((Object)provider.getTransportChannel()).isSameAs((Object)transportChannel);
        Truth.assertThat((String)provider.getTransportName()).isEqualTo((Object)FakeTransportChannel.getFakeTransportName());
    }
}

