/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeSimpleApi;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.truth.Truth;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class AuthCallableTest {
    private ClientContext clientContext;

    @Before
    public void setUp() {
        this.clientContext = ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @Test
    public void testAuth() throws InterruptedException, ExecutionException, CancellationException {
        FakeSimpleApi.StashCallable stash = new FakeSimpleApi.StashCallable(42);
        Truth.assertThat((Object)stash.getContext()).isNull();
        UnaryCallSettings callSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().build();
        UnaryCallable callable = FakeCallableFactory.createUnaryCallable(stash, callSettings, this.clientContext.toBuilder().setCredentials((Credentials)Mockito.mock(Credentials.class)).build());
        Truth.assertThat((Integer)((Integer)callable.futureCall((Object)0).get())).isEqualTo((Object)42);
        Truth.assertThat((Object)stash.getContext()).isNotNull();
        FakeCallContext callContext = (FakeCallContext)stash.getContext();
        Truth.assertThat((Object)callContext.getCredentials()).isNotNull();
    }
}

