/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.CancelledException;
import com.google.api.gax.rpc.DataLossException;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.OutOfRangeException;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.ResourceExhaustedException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnauthenticatedException;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.UnimplementedException;
import com.google.api.gax.rpc.UnknownException;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiExceptionFactoryTest {
    @Test
    public void cancelled() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.CANCELLED)).isInstanceOf(CancelledException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.CANCELLED)).isInstanceOf(CancelledException.class);
    }

    @Test
    public void notFound() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.NOT_FOUND)).isInstanceOf(NotFoundException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.NOT_FOUND)).isInstanceOf(NotFoundException.class);
    }

    @Test
    public void unknown() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.UNKNOWN)).isInstanceOf(UnknownException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.UNKNOWN)).isInstanceOf(UnknownException.class);
    }

    @Test
    public void invalidArgument() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.INVALID_ARGUMENT)).isInstanceOf(InvalidArgumentException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.INVALID_ARGUMENT)).isInstanceOf(InvalidArgumentException.class);
    }

    @Test
    public void deadlineExceeded() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.DEADLINE_EXCEEDED)).isInstanceOf(DeadlineExceededException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.DEADLINE_EXCEEDED)).isInstanceOf(DeadlineExceededException.class);
    }

    @Test
    public void alreadyExists() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.ALREADY_EXISTS)).isInstanceOf(AlreadyExistsException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.ALREADY_EXISTS)).isInstanceOf(AlreadyExistsException.class);
    }

    @Test
    public void permissionDenied() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.PERMISSION_DENIED)).isInstanceOf(PermissionDeniedException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.PERMISSION_DENIED)).isInstanceOf(PermissionDeniedException.class);
    }

    @Test
    public void resourceExhausted() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.RESOURCE_EXHAUSTED)).isInstanceOf(ResourceExhaustedException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.RESOURCE_EXHAUSTED)).isInstanceOf(ResourceExhaustedException.class);
    }

    @Test
    public void failedPrecondition() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.FAILED_PRECONDITION)).isInstanceOf(FailedPreconditionException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.FAILED_PRECONDITION)).isInstanceOf(FailedPreconditionException.class);
    }

    @Test
    public void aborted() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.ABORTED)).isInstanceOf(AbortedException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.ABORTED)).isInstanceOf(AbortedException.class);
    }

    @Test
    public void outOfRange() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.OUT_OF_RANGE)).isInstanceOf(OutOfRangeException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.OUT_OF_RANGE)).isInstanceOf(OutOfRangeException.class);
    }

    @Test
    public void internal() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.INTERNAL)).isInstanceOf(InternalException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.INTERNAL)).isInstanceOf(InternalException.class);
    }

    @Test
    public void unavailable() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.UNAVAILABLE)).isInstanceOf(UnavailableException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.UNAVAILABLE)).isInstanceOf(UnavailableException.class);
    }

    @Test
    public void dataLoss() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.DATA_LOSS)).isInstanceOf(DataLossException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.DATA_LOSS)).isInstanceOf(DataLossException.class);
    }

    @Test
    public void unauthenticated() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.UNAUTHENTICATED)).isInstanceOf(UnauthenticatedException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.UNAUTHENTICATED)).isInstanceOf(UnauthenticatedException.class);
    }

    @Test
    public void unimplemented() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.UNIMPLEMENTED)).isInstanceOf(UnimplementedException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.UNIMPLEMENTED)).isInstanceOf(UnimplementedException.class);
    }

    @Test
    public void unknown_default() {
        Truth.assertThat((Throwable)this.createException(StatusCode.Code.OK)).isInstanceOf(UnknownException.class);
        Truth.assertThat((Throwable)this.createExceptionWithMessage(StatusCode.Code.OK)).isInstanceOf(UnknownException.class);
    }

    private ApiException createException(StatusCode.Code statusCode) {
        return ApiExceptionFactory.createException((Throwable)new RuntimeException(), (StatusCode)FakeStatusCode.of(statusCode), (boolean)false);
    }

    private ApiException createExceptionWithMessage(StatusCode.Code statusCode) {
        return ApiExceptionFactory.createException((String)"message", (Throwable)new RuntimeException(), (StatusCode)FakeStatusCode.of(statusCode), (boolean)false);
    }
}

