/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiClientHeaderProviderTest {
    private static final String X_GOOG_API_CLIENT = "x-goog-api-client";
    private static final String CLOUD_RESOURCE_PREFIX = "google-cloud-resource-prefix";

    @Test
    public void testServiceHeaderDefault() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)1);
        Truth.assertThat((String)((String)provider.getHeaders().get(X_GOOG_API_CLIENT))).matches("^gl-java/.* gax/.*$");
    }

    @Test
    public void testServiceHeaderManual() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().setClientLibToken("gccl", "1.2.3").build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)1);
        Truth.assertThat((String)((String)provider.getHeaders().get(X_GOOG_API_CLIENT))).matches("^gl-java/.* gccl/1\\.2\\.3 gax/.*$");
    }

    @Test
    public void testServiceHeaderManualGapic() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().setTransportToken("grpc", "1.2.3").setClientLibToken("gccl", "4.5.6").setGeneratedLibToken("gapic", "7.8.9").build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)1);
        Truth.assertThat((String)((String)provider.getHeaders().get(X_GOOG_API_CLIENT))).matches("^gl-java/.* gccl/4\\.5\\.6 gapic/7\\.8\\.9 gax/.* grpc/1\\.2\\.3$");
    }

    @Test
    public void testServiceHeaderManualGrpc() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().setTransportToken("grpc", "1.2.3").setClientLibToken("gccl", "4.5.6").build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)1);
        Truth.assertThat((String)((String)provider.getHeaders().get(X_GOOG_API_CLIENT))).matches("^gl-java/.* gccl/4\\.5\\.6 gax/.* grpc/1\\.2\\.3$");
    }

    @Test
    public void testServiceHeaderGapic() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().setTransportToken("grpc", "1.2.3").setGeneratedLibToken("gapic", "4.5.6").build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)1);
        Truth.assertThat((String)((String)provider.getHeaders().get(X_GOOG_API_CLIENT))).matches("^gl-java/.* gapic/4\\.5\\.6 gax/.* grpc/1\\.2\\.3$");
    }

    @Test
    public void testCloudResourcePrefixHeader() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().setTransportToken("grpc", "1.2.3").setGeneratedLibToken("gapic", "4.5.6").setResourceToken("test-prefix").build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)2);
        Truth.assertThat((String)((String)provider.getHeaders().get(X_GOOG_API_CLIENT))).matches("^gl-java/.* gapic/4\\.5\\.6 gax/.* grpc/1\\.2\\.3$");
        Truth.assertThat((String)((String)provider.getHeaders().get(CLOUD_RESOURCE_PREFIX))).isEqualTo((Object)"test-prefix");
    }

    @Test
    public void testCustomHeaderKeys() {
        ApiClientHeaderProvider provider = ApiClientHeaderProvider.newBuilder().setTransportToken("grpc", "1.2.3").setGeneratedLibToken("gapic", "4.5.6").setResourceToken("test-prefix").setApiClientHeaderKey("custom-header1").setResourceHeaderKey("custom-header2").build();
        Truth.assertThat((Integer)provider.getHeaders().size()).isEqualTo((Object)2);
        Truth.assertThat((String)((String)provider.getHeaders().get("custom-header1"))).matches("^gl-java/.* gapic/4\\.5\\.6 gax/.* grpc/1\\.2\\.3$");
        Truth.assertThat((String)((String)provider.getHeaders().get("custom-header2"))).isEqualTo((Object)"test-prefix");
    }
}

